local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
local idioma = settings:get("assets_warehouse_idioma") or "espanol"

local head_hugher_descripcion = " A thing with tentacles who hug heads?"
local light_spider_descripcion = "A little spider who create a very confortable webs"

if idioma == "espanol" then
    head_hugher_descripcion = "Una cosa con tentaculos que abraza cabezas?"
    light_spider_descripcion = "Una arañita que crea telas muy confortables" 
end

if minetest.get_modpath("mobs") then
    mobs:register_mob("assets_warehouse:peppert_and_carrot_light_spider", {
        type = "animal",
        visual_size = {x = 10, y = 10}, 
        passive = false,
        attack_type = "dogshoot",
        damage = 4,
        reach = 4,
        knock_back = true,
        hp_min = 50,
        hp_max = 100,
        armor = 80,
        collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
        visual = "mesh",
        mesh = "peppert_and_carrot_light_spiderMD"..model_detail..".x",
        rotate = 180,
        textures = {
            {"peppert_and_carrot_light_spiderTQ"..texture_detail..".png"}
        },
        view_range = 10,
        walk_velocity = 1,
        run_velocity = 2,
        jump = true,
        jump_height = 0.5,
        fall_damage = 0,
        stepheight = 1.1,
        water_damage = 0,
        lava_damage = 0,
        light_damage = 0,
        
        animation = {
              stand_start  = 0,
              stand_end  =0, 
              walk_start  =10,
              walk_end = 40,
              walk_speed = 30,
              run_start  = 10, 
              run_end = 40,
              run_speed = 60,
              punch_start = 50,
              punch_end= 70,
              punch_speed = 30,
              shoot_start =80,
              shoot_end=100,
        },
        
    })
    
    
    mobs:register_mob("assets_warehouse:peppert_and_carrot_head_huger", {
        type = "monster",
        visual_size = {x = 10, y = 10}, 
        passive = true,
        attack_type = "dogfight",
        damage = 4,
        reach = 4,
        knock_back = true,
        hp_min = 50,
        hp_max = 100,
        armor = 80,
        collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
        visual = "mesh",
        mesh = "peppert_and_carrot_head_hugherMD"..model_detail..".x",
        rotate = 180,
        textures = {
            {"peppert_and_carrot_head_hugerTQ"..texture_detail..".png"}
        },
        view_range = 10,
        walk_velocity = 1,
        run_velocity = 2,
        jump = true,
        jump_height = 1,
        fall_damage = 0,
        stepheight = 2.1,
        water_damage = 0,
        lava_damage = 0,
        light_damage = 0,
        animation = {
              stand_start  = 0,
              stand_end  =0, 
              walk_start  =10,
              walk_end = 30,
              walk_speed = 30,
              run_start  = 10, 
              run_end = 30,
              run_speed = 60,
              punch_start = 40,
              punch_end= 60,
              punch_speed = 30,
              
        },
        
    })
    mobs:register_egg("assets_warehouse:peppert_and_carrot_head_huger", head_hugher_descripcion, "peppert_and_carrot_head_hugepreview.png", 0, false)
    mobs:register_egg("assets_warehouse:peppert_and_carrot_light_spider", light_spider_descripcion, "peppert_and_carrot_light_spiderpreview.png", 0, false)

    mobs:spawn({
        name = "assets_warehouse:peppert_and_carrot_light_spider",
        nodes = {"default:stone"},
        max_light = 7,
        chance = 5000,
        active_object_count = 3,
        max_height = 200
    })


    mobs:spawn({
        name = "assets_warehouse:peppert_and_carrot_head_huger",
        nodes = {"default:stone"},
        max_light = 7,
        chance = 5000,
        active_object_count = 3,
        max_height = 2000
    })
    
end