local function swap_node(pos, name)
    local node = minetest.get_node(pos)
    if node.name == name then
        return
    end
    node.name = name
    minetest.swap_node(pos, node)
end

function assets_warehouse.lamp(name,mesh,texture,intensity,selectionbox,collisionbox,description)
    minetest.register_node("assets_warehouse:lamp_" .. name, {
        description = description,
        drawtype = "mesh",
        mesh = mesh,
        mesh = "krutchyMD1.obj",
        tiles = texture,
        light_source = intensity,
        paramtype = "light",
        paramtype2 = "facedir",
        stack_max = 1,
        groups = {light = 1,chopy=3},
        is_ground_content=true,
        diggable=true,
        range=5.0,
        selection_box = selectionbox,
        collision_box = collisionbox,
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            --rotation1 = pointed_thing.minetest.dir_to_facedir()
            --minetest.swap_node(pos, node)
            --minetest.swap_node(pos, {name = "assets_warehouse:lamp_"..name.."_off"})
            --minetest.swap_node(pos, {"assets_warehouse:lamp_"..name.."_off"})
            swap_node(pos, "assets_warehouse:lamp_"..name.."_off")
            --minetest.set_node(pos, {name = "assets_warehouse:lamp_"..name.."_off"})
        end,
        sunlight_propagates=true,
        use_texture_alpha=false,
        walkable=true,
        pointable=true,
    })
    minetest.register_node("assets_warehouse:lamp_" .. name.."_off", {
        description = description,
        drawtype = "mesh",
        mesh = mesh,
        tiles = texture,
        light_source = 0,
        paramtype = "light",
        paramtype2 = "facedir",
        stack_max = 1,
        groups = {light = 1,chopy=3},
        is_ground_content=true,
        diggable=true,
        range=5.0,
        selection_box = selectionbox,
        collision_box = collisionbox,
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            swap_node(pos, "assets_warehouse:lamp_"..name)
            --minetest.swap_node(pos, "assets_warehouse:lamp_"..name)
        end,
        sunlight_propagates=true,
        use_texture_alpha=false,
        walkable=true,
        pointable=true,
        })
end
