local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")


model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
local idioma = settings:get("assets_warehouse_idioma") or "espanol"



local peppert_and_carrot_sword1_descripcion = "A sword of a medieval knight who don't like the little girls"
local peppert_and_carrot_water_tree_guardian_hammer_descripcion = "Hammer of the water tree guardian"
local peppert_and_carrot_staff_descripcion = "An ancient and powerfull staff of the Chaosa Witches or maybe just a stick from a random tree"

if idioma == "espanol" then
    peppert_and_carrot_sword1_descripcion = "La espada de un caballero medieval al que no le gustan las niñas"
    peppert_and_carrot_water_tree_guardian_hammer_descripcion = "Martillo del guardian del arbol de agua"
    peppert_and_carrot_staff_descripcion = "Un viejo y poderoso baston de las Brujas de Chaosa o tal vez solo una vara de un arbol aleatorio "
    peppert_and_carrot_sword_of_dark_knightdescripcion = "La espada de un caballero magico"
end

assets_warehouse.item("assets_warehouse:peppert_and_carrot_sword1",{
    wield_mesh ='peppert_and_carrot_sword1MD'..model_detail..'.obj',--'peppert_and_carrot_sword1_wield.x',
    wielded_entity = true,
    mesh ='peppert_and_carrot_sword1MD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_sword1.png'},
    wield = "peppert_and_carrot_sword1preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "",
    atack = "assets_warehouse:peppert_and_carrot_sword1_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        end
       
    end,
})

assets_warehouse:register_attack("assets_warehouse:peppert_and_carrot_sword1_atack", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    textures = {'peppert_and_carrot_sword1_atack.png'},
    damage = 1,
    lifetime = 0.4,
    --range = 1,

    -- direct hit
    --hit_player = function(self, player)
    --    player:punch(self.object, 1.0, {
    --        full_punch_interval = 1.0,
    --        damage_groups = {fleshy = 5},
    --    }, nil)
    --end,

    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 5},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})

assets_warehouse:register_attack("assets_warehouse:peppert_and_carrot_sword1_atack2", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    textures = {'peppert_and_carrot_sword1_atack2.png'},
    damage = 1,
    --lifetime = 0.2*10,
    --velocity = 2,
    --range = 1,

    -- direct hit
    --hit_player = function(self, player)
    --    player:punch(self.object, 1.0, {
    --        full_punch_interval = 1.0,
    --        damage_groups = {fleshy = 8},
    --    }, nil)
    --end,

    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 8},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})



assets_warehouse.item("assets_warehouse:peppert_and_carrot_water_tree_guardian_hammer",{
    wield_mesh ='peppert_and_and_carrot_water_tree_guardian_hammerMD'..model_detail..'.obj',--'peppert_and_carrot_sword1_wield.x',
    wielded_entity = true,
    mesh ='peppert_and_and_carrot_water_tree_guardian_hammerMD'..model_detail..'.obj',
    texture = {'peppert_and_and_carrot_water_tree_guardian_hammer.png'},
    wield = "peppert_and_and_carrot_water_tree_guardian_hammer_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_water_tree_guardian_hammer_descripcion,
    atack = "assets_warehouse:peppert_and_carrot_guatertreeguardianhammer_atack1",
})


    

assets_warehouse:register_attack("assets_warehouse:peppert_and_carrot_guatertreeguardianhammer_atack1", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    textures = {'peppert_and_carrot_guatertreeguardianhammer_atack1.png'},
    damage = 1,
    lifetime = 0.7,
    --range = 1,

    -- direct hit
    --hit_player = function(self, player)
    --    player:punch(self.object, 1.0, {
    --        full_punch_interval = 1.0,
    --        damage_groups = {fleshy = 5},
    --    }, nil)
    --end,

    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 10},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})



assets_warehouse.item("assets_warehouse:peppert_and_carrot_staff",{
    wield_mesh ='peppert_and_carrot_staffMD1.obj',
    wielded_entity = true,
    mesh ='peppert_and_carrot_staffMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_staff.png'},
    wield = "peppert_and_carrot_staffpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = peppert_and_carrot_staff_descripcion,
    atack = "assets_warehouse:peppert_and_carrot_staff_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_staff_special")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_staff_special")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        end
       
    end,
})

assets_warehouse:register_attack("assets_warehouse:peppert_and_carrot_staff_atack", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    textures = {'peppert_and_carrot_staff_atack.png'},
    damage = 1,
    lifetime = 0.4,
    --range = 1,

    -- direct hit
    --hit_player = function(self, player)
    --    player:punch(self.object, 1.0, {
    --        full_punch_interval = 1.0,
    --        damage_groups = {fleshy = 2},
    --    }, nil)
    --end,

    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 2},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})

assets_warehouse:register_attack("assets_warehouse:peppert_and_carrot_staff_special", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    textures = {'peppert_and_carrot_staff_atack.png'},
    damage = 1,
    lifetime = 0.2*10,
    velocity = 2,
    --range = 1,

    -- direct hit
    --hit_player = function(self, player)
    --    player:punch(self.object, 1.0, {
    --        full_punch_interval = 1.0,
    --        damage_groups = {fleshy = 2},
    --    }, nil)
    --end,

    hit_mob = function(self, player)
        local pos = self.object:get_pos()
        tnt.boom(pos, {damage_radius=3,radius=2,ignore_protection=false})
       
    end,

    hit_node = function(self, pos, node)
        tnt.boom(pos, {damage_radius=3,radius=2,ignore_protection=false})
    end
})

assets_warehouse.item("assets_warehouse:peppert_and_carrot_sword_of_dark_knight",{
    wield_mesh ='peppert_and_carrot_sword_of_dark_knightMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='peppert_and_carrot_sword_of_dark_knightMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_sword_of_dark_knight.png'},
    wield = "peppert_and_carrot_sword_of_dark_knight_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_sword_of_dark_knightdescripcion,
    atack = "assets_warehouse:peppert_and_carrot_sword1_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        end
       
    end,
})

