

local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")
local idioma = settings:get("assets_warehouse_idioma") or "espanol"



model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2


local Aperture_Science_greedy_descripcion = "Character based in Greedi from Aperture Desk Job"
local Aperture_Science_toilet_descripcion = "A toilet made by Aperture Science"
local Aperture_Science_washing_machine_descripcion = 'A washing machine made by Aperture Science'
local aperture_science_toilet_turret_mob_descripcion = "A toilet turret made by Greedy"
local aperture_science_washing_turret_mob_descripcion = "A evil washing machine made by envy people"

if idioma == "espanol" then
    Aperture_Science_greedy_descripcion = "Personaje basado en Greedy de Aperture Desk Job"
    Aperture_Science_toilet_descripcion = "Un retrete hecho por Aperture Science"
    Aperture_Science_washing_machine_descripcion = "Una lavadora hecha por Aperture Science"
    aperture_science_toilet_turret_mob_descripcion = "Una torreta de retrete creada por Greedy"
    aperture_science_washing_turret_mob_descripcion = "Una torreta lavadora creada por gente envidiosa"
    
    
end
minetest.register_node('assets_warehouse:Aperture_Science_greedy', {
	drawtype = 'mesh',
	mesh = 'greedyMD'..model_detail..'.obj',
	tiles ={'greedy.png'}, 
	description= Aperture_Science_greedy_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5,0.8,-0.25,0.5,0,0.25},
					
		},	
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.5,0.8,-0.25,0.5,0,0.25},
					
		},	
	},
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})
minetest.register_node('assets_warehouse:Aperture_Science_Toilet', {
	drawtype = 'mesh',
	mesh = 'Aperture_Science_Toilet_turret2.obj',
	tiles ={'aperture_turret_toilet.png'}, 
	description= Aperture_Science_toilet_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.21,-0.5,-0.3,0.21,0,0.25},
            {-0.3,0,0.25,0.30,0.55,0.5},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.21,-0.5,-0.3,0.21,0,0.25},
            {-0.3,0,0.25,0.30,0.55,0.5},
                    
        },	
    },
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
    paramtype="light",
	sunlight_propagates=true,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

minetest.register_node('assets_warehouse:Aperture_Science_washing_machine', {
	drawtype = 'mesh',
	mesh = 'Aperture_Science_washing_machine.obj',
	tiles ={'Aperture_Science_washing_turret.png'}, 
	description= Aperture_Science_washing_machine_descripcion,
	stack_max = 1,
	groups = {choppy = 2, oddly_breakable_by_hand = 2},
	paramtype2 = "facedir",
	is_ground_content=true,
	climbable=false,
	buildable_to=false,
	damage_per_second=0,
	diggable=true,
	drowning=0,
	floodable=false,
	range=5.0,
    paramtype="light",
	sunlight_propagates=false,
	use_texture_alpha=false,
	walkable=true,
	pointable=true,
})

if minetest.get_modpath("mobs") then
    mobs:register_mob("assets_warehouse:aperture_science_toilet_turret_mob", {
        type = "monster",
        visual_size = {x = 10, y = 10}, 
        passive = false,
        attack_type = "dogshoot",
        damage = 4,
        reach = 4,
        shoot_interval = 0.2,
        arrow = 'assets_warehouse:testarrow',
        shoot_offset = 0.5,
        knock_back = false,
        hp_min = 50,
        hp_max = 100,
        armor = 80,
        collisionbox = {-0.75, -0.5, -0.75, 0.75, 2.5, 0.75},
        visual = "mesh",
        mesh = "Aperture_Science_Toilet_turret.obj",
        rotate = 180,
        textures = {
            {"aperture_turret_toilet.png"}
        },
        view_range = 10,
        walk_velocity = 0,
        run_velocity = 0,
        jump = false,
        jump_height = 0,
        can_leap = true,
        fall_damage = 0,
        stepheight = 2.1,
        --drops = {
        --    {name = "default:mese_crystal", chance = 9, min = 0, max = 2},
        --    {name = "default:mese_crystal_fragment", chance = 1, min = 0, max = 2},
        --},
        water_damage = 0,
        lava_damage = 0,
        light_damage = 0,
        
    })
    
    mobs:register_mob("assets_warehouse:aperture_science_washing_turret_mob", {
        type = "monster",
        visual_size = {x = 10, y = 10}, 
        passive = false,
        attack_type = "dogshoot",
        damage = 4,
        reach = 4,
        shoot_interval = 0.1,
        arrow = 'assets_warehouse:testarrow',
        shoot_offset = 0.5,
        knock_back = false,
        hp_min = 50,
        hp_max = 100,
        armor = 80,
        collisionbox = {-0.75, -0.5, -0.75, 0.75, 2.5, 0.75},
        visual = "mesh",
        mesh = "Aperture_Science_washing_turret.obj",
        rotate = 180,
        textures = {
            {"Aperture_Science_washing_turret.png"}
        },
        view_range = 10,
        walk_velocity = 0,
        run_velocity = 0,
        jump = false,
        jump_height = 0,
        can_leap = true,
        fall_damage = 0,
        stepheight = 2.1,
        --drops = {
        --    {name = "default:mese_crystal", chance = 9, min = 0, max = 2},
        --    {name = "default:mese_crystal_fragment", chance = 1, min = 0, max = 2},
        --},
        animation = {
            --speed_normal = 18,
            --speed_run    = 18,
            --walk_start   = 10,
            --walk_end     = 41,
            --walk_speed   = 20,
            --run_start    = 10,
            --run_end      = 41,
            --run_speed    = 30,
            stand_start  = 60,
            stand_end    = 110,
            shoot_start  = 1,
            shoot_end    = 60,
            --die_start    = 125,
            --die_end      = 141,
            --death_speed  = 25,
            --die_loop     = false,
            --jump_start   = 150 ,
            --jump_end     = 168,
            --jump_loop    = false,
            --punch_start  = 175,
            --punch_end    = 189
        },
        water_damage = 0,
        lava_damage = 0,
        light_damage = 0,
        
    })

    mobs:register_arrow("assets_warehouse:testarrow", {
        visual = "wielditem",
        visual_size = {x = 0.1, y = 0.1},
        textures = {"default:iron_lump"},
        velocity = 10,
        rotate = 180,
        damage = 1,

        -- direct hit
        hit_player = function(self, player)
            player:punch(self.object, 1.0, {
                full_punch_interval = 1.0,
                damage_groups = {fleshy = 2},
            }, nil)
        end,

        hit_mob = function(self, player)
            player:punch(self.object, 1.0, {
                full_punch_interval = 1.0,
                damage_groups = {fleshy = 2},
            }, nil)
        end,

        hit_node = function(self, pos, node)
        end
    })


    mobs:register_egg("assets_warehouse:aperture_science_toilet_turret_mob", aperture_science_toilet_turret_mob_descripcion, "aperture_turret_toilet_mob.png", 0, false)
    mobs:register_egg("assets_warehouse:aperture_science_washing_turret_mob",aperture_science_washing_turret_mob_descripcion , "Aperture_Science_washing_turret_mob.png", 0, false)

    mobs:spawn({
        name = "assets_warehouse:aperture_science_toilet_turret_mob",
        nodes = {"default:stone"},
        max_light = 7,
        chance = 5000,
        active_object_count = 3,
        max_height = -20
    })
end

minetest.register_craft({
    output = "assets_warehouse:Aperture_Science_Toilet",
    recipe = {
        {"dye:green", "dye:white", "dye:green"},
        {"default:clay_lump", "bucket:bucket_water", "default:clay_lump"},
        {"", "default:clay", ""},
    }
})

minetest.register_craft({
    output = "assets_warehouse:Aperture_Science_washing_machine",
    recipe = {
        {"dye:blue", "dye:orange", "dye:blue"},
        {"default:clay_lump", "bucket:bucket_water", "default:clay_lump"},
        {"dye:orange", "default:clay", "dye:orange"},
    }
})

minetest.register_craft({
    output = "assets_warehouse:aperture_science_toilet_turret_mob",--"assets_warehouse:aperture_science_toilet_turret_mob",
    recipe = {
        {"default:mese_crystal", "default:iron_lump", "default:mese_crystal"},
        {"default:steelblock", "default:mese", "default:steelblock"},
        {"", "assets_warehouse:Aperture_Science_Toilet", ""},
    }
})

minetest.register_craft({
    output = "assets_warehouse:aperture_science_washing_turret_mob",
    recipe = {
        {"default:iron_lump", "default:mese", "default:iron_lump"},
        {"default:steelblock", "default:steelblock", "default:steelblock"},
        {"default:mese_crystal", "assets_warehouse:Aperture_Science_washing_machine", "default:mese_crystal"},
    }
})