--Parte de este codigo esta  basado en el de arrows from mobs mod de TenPlus1
--Wield3d de stujones11, Stuart Jones and parkoursurvive de aitech

local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")


model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
useoldmodel = settings:get("assets_wareohuse_use_oldmodel") or "false"
--playermodel = settings:get("assets_wareohuse_model") or "assets_warehouse:cannine_body_cloth"
playerskin = settings:get("assets_wareohuse_skin") or "playerTQ1:cannine_body_cloth"


local node_ok = function(pos, fallback)

    fallback = fallback or mobs.fallback_node

    local node = minetest.get_node_or_nil(pos)

    if node and minetest.registered_nodes[node.name] then
        return node
    end

    return minetest.registered_nodes[fallback]
end


function assets_warehouse:register_attack(name, def)

    if not name or not def then return end -- errorcheck

    minetest.register_entity(name, {

        physical = def.physical or false,
        collide_with_objects = def.collide_with_objects or false,
        static_save = false,

        visual = def.visual,
        visual_size = def.visual_size,
        textures =  def.textures or {'default_mask.png'},
        velocity = def.velocity or 100,
        hit_player = def.hit_player,
        hit_node = def.hit_node,
        hit_mob = def.hit_mob,
        hit_object = def.hit_object,
        --drop = def.drop or false, -- drops arrow as registered item when true
        collisionbox = def.collisionbox or {-.1, -.1, -.1, .1, .1, .1},
        timer = 0,
        
        range = def.range or 1,
        
        lifetime = def.lifetime or 0.2,
        
        owner_id = def.owner_id,
        
        on_activate = def.on_activate,

        on_punch = def.on_punch or function(
                self, hitter, tflp, tool_capabilities, dir)
        end,

        on_step = def.on_step or function(self, dtime)

            self.timer = self.timer + dtime

            local pos = self.object:get_pos()
            --local lifetime2 = (self.range/5)*self.lifetime 
        

            if self.timer > self.lifetime then
                self.object:remove() ; -- print("removed arrow")
                return
            end

            -- does arrow have a tail (fireball)
            if def.tail and def.tail == 1 and def.tail_texture then

                minetest.add_particle({
                    pos = pos,
                    velocity = {x = 0, y = 0, z = 0},
                    acceleration = {x = 0, y = 0, z = 0},
                    expirationtime = def.expire or 0.25,
                    collisiondetection = false,
                    texture = def.tail_texture,
                    size = def.tail_size or 5,
                    glow = def.glow or 0
                })
            end

            if self.hit_node then
                local node = node_ok(pos).name
                if minetest.registered_nodes[node].walkable then
                    self:hit_node(pos, node)
                    if self.drop == true then
                        pos.y = pos.y + 1
                        self.lastpos = (self.lastpos or pos)
                        minetest.add_item(self.lastpos,
                                self.object:get_luaentity().name)
                    end
                    self.object:remove() ; -- print("hit node")
                    return
                end
            end

            if self.hit_player or self.hit_mob or self.hit_object then

                for _,player in pairs(
                        minetest.get_objects_inside_radius(pos, 1.0)) do

                    if self.hit_player and player:is_player() then

                        self:hit_player(player)

                        self.object:remove() ; -- print("hit player")

                        return
                    end

                    local entity = player:get_luaentity()

                    if entity
                    and self.hit_mob
                    and entity._cmi_is_mob == true
                    and tostring(player) ~= self.owner_id
                    and entity.name ~= self.object:get_luaentity().name then

                        self:hit_mob(player)

                        self.object:remove() ; --print("hit mob")

                        return
                    end

                    if entity
                    and self.hit_object
                    and (not entity._cmi_is_mob)
                    and tostring(player) ~= self.owner_id
                    and entity.name ~= self.object:get_luaentity().name then

                        self:hit_object(player)

                        self.object:remove() ; -- print("hit object")

                        return
                    end
                end
            end

            self.lastpos = pos
        end
    })
end


--Funcion que crea la clase item
function assets_warehouse.item(name,def)
    --Creando la entidad que representara el objeto
    minetest.register_entity(name.."drop_entity", {--("assets_warehouse:"..name.."drop_entity", {
        physical = true,
        visual = "mesh",
        visual_size = {x = 20, y = 10, z = 10},
        mesh = def.mesh,
        textures = def.texture,
        on_step = function(self, dtime, moveresult)--Hace que la entidad se mueva hacia abajo cuando do este tocando nada debajo
            if moveresult  then
                if moveresult.touching_ground == true then
                    self.object:set_velocity({x=0.0, y=0.0, z=0.0})
                else
                    self.object:set_acceleration({x = 0, y = -1, z = 0})
                end
            end
        end,
        --No usar el tipo fixet para selectionbox o collisionbox,Dont use type fixed for collision or selection box
        selectionbox = def.selectionbox,
        collisionbox = def.collisionbox,
        timer = 0,
        --Hace que al tocar la entidad se obtenga el objeto pero solo si se coge con la mano
        on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir)
            local itemstack = puncher:get_wielded_item(itemstack)
            if itemstack.is_empty(itemstack) then 
                puncher:set_wielded_item(name)--("assets_warehouse:"..name)
            else 
                minetest.log("none", "You need to pick the object whit the hand")
                return
            end
        end,
        use_texture_alpha = true
        
    })
    use_texture_alpha = true
    
    local wielded_entity = def.wielded_entity or nil
    
    if wielded_entity == true then
        assets_warehouse.cloth(name,{
        mesh =def.wield_mesh,
        texture = def.texture,
        wield = def.wield,
        selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
        description = def.description,
        cloth_type = "wielded",
        })
    end
    
    --Creando la representacion del objeto que sera mostrada en la mano/s del jugador
    minetest.register_tool(name, {--('assets_warehouse:'..name, {
        drawtype = 'mesh',
        mesh = def.mesh,
        tiles = def.texture, 
        description= def.description,
        stack_max = 1,
        wield_image = def.wield,
        inventory_image = def.wield,
        groups = def.groups or {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
        range= def.range or 5.0,
        
        --Hace que el objeto sea lanzado 
        on_drop = function(itemstack, user, pointed_thing)
            local player = user
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local yaw = player:get_look_horizontal()
            local power = 50
            local controls = player:get_player_control()
            local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
            local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
            itemstack.clear(itemstack)
            if controls.sneak then
                aceleration = {x=dir.x*power/2, y=dir.y*power/2, z=dir.z*power/2}
                        
            end
            if pointed_thing.type == "node" then
                
                obj = minetest.add_entity(addinpos,name.."drop_entity")--(addinpos,"assets_warehouse:"..name.."drop_entity")
                obj:set_acceleration(aceleration)
                obj:set_yaw(yaw)
            else 
                obj = minetest.add_entity(addinpos,name.."drop_entity")--(addinpos,"assets_warehouse:"..name.."drop_entity")
                obj:set_acceleration(aceleration)
                obj:set_yaw(yaw)
            end
            return itemstack
        end,
       
        on_place = def.custom_function or function(itemstack, placer, pointed_thing)
            minetest.log("none", "No second use")
        end,
        on_secondary_use = def.custom_function or function(itemstack, user, pointed_thing)
            minetest.log("none", "No second use")
        end,
        sunlight_propagates=true,
        use_texture_alpha=false,
        walkable=true,
        pointable=true,
        backface_culling = true,
    })
end


--Ataque que se realizara por defecto al usar el objeto si es que no se le ha asignado uno
assets_warehouse:register_attack("assets_warehouse:testatack", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    damage = 1,
    
    -- direct hit
    hit_player = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 2},
        }, nil)
    end,

    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 2},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})


--Funcion que se encarga de animar las entidades de la clase cloth
assets_warehouse.entity_anim=function(self,number,x,y,time,framerate)
    --local animation = self.object:get_animation()--`: returns `range`, `frame_speed`, --`frame_blend` and--`frame_loop`.
    --el dato number se encarga de hacerle saber a la funcion si la animacion ya se esta realizando
    if self.animation == number then -- or self.animation == 0 then --or self.animation < number then
        return
    end
    self.animation = number
    local framerate = framerate or 30
    --minetest.log("none","Framerate"..framerate)
    self.object:set_animation({x = x,y = y},framerate,0,true )
    local time = time or 1
       
end

--Funcion que crea la clase ropa,no es demasiado diferente de la clase item
function assets_warehouse.cloth(name,def)
    local visual_size = {x = 1, y = 1, z = 1}
    local on_step = def.custon_stepwielded or function(self, dtime, moveresult)
        if moveresult  then
            if moveresult.touching_ground == true then
                self.object:set_velocity({x=0.0, y=0.0, z=0.0})
            else
                self.object:set_acceleration({x = 0, y = -1, z = 0})
            end
        end
        if self then
            if self.object then
                -- Comprueba que el personaje este emparentado al jugador
                if self.object:get_attach() == nil then
                    self.object:remove()
    
                end
            end
        end
    end
    
    local name_end = "_cloth"
    if def.cloth_type == "wielded" then
        name_end ="_wielded"
        on_step = custon_stepwielded or nil
        visual_size = {x = 1, y = 1, z = 1}
    end
    
    if def.cloth_type == "body" then
        visual_size = {x = 10, y = 10, z = 10}
    end
    
    --if def.cloth_type == "hat" then
    --    on_step = --custon_stepwielded or nil
    --end
    
    local visual = "mesh"
    
    if def.cloth_type == "shirt" or def.cloth_type == "pants" or def.cloth_type == "gloves" then
        visual = "sprite"
    end
    
    minetest.register_entity(name..name_end, {--("assets_warehouse:"..name..name_end, {
        basename = name,
        physical = false,
        visual = visual,
        visual_size = visual_size,
        mesh = def.mesh,
        texturecloth = def.texturecloth,
        textures = def.texture or {"invisible"},
        backface_culling = false,
        maskforpants = def.maskforpants or "default_maskforpants.png",
        timer = 0,
        pointable = false,
        cloth_type = def.cloth_type,
        texture_mask = def.texture_mask or "default_mask.png",
        on_step = on_step,
        selectionbox = def.selectionbox, --{-0.1,-0.5,-0.1,0.1,0.05,0.1},
        collisionbox = def.collisionbox, -- {-0.1,-0.5,-0.1,0.1,0.05,0.1},
        use_texture_alpha = true,
        
        
        
    })
    --minetest.log("none","useoldmodelcloth"..useoldmodel)
    if def.cloth_type ~= "body" and def.cloth_type ~= "wielded" and useoldmodel == "false" then
        minetest.register_tool(name,{--('assets_warehouse:'..name,{--..'_item', { 
            basename = name,
            drawtype = 'mesh',
            mesh = def.mesh,
            tiles = def.texture, 
            maskforpants = def.maskforpants,
            inventory_image  = def.texture,
            description= def.description,
            stack_max = 1,
            --wield_image = def.wield,
            inventory_image = def.wield,
            groups = def.groups or {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
            range=5.0,
            on_drop = function(itemstack, user, pointed_thing)
                local player = user
                local pos = player:get_pos()
                local dir = player:get_look_dir()
                local yaw = player:get_look_horizontal()
                local power = 50
                local controls = player:get_player_control()
                local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
                local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
                itemstack.clear(itemstack)
                if controls.sneak then
                    aceleration = {x=dir.x*power/2, y=dir.y*power/2, z=dir.z*power/2}

                end
                if pointed_thing.type == "node" then
                    minetest.add_item(addinpos,name.."_item")--(addinpos,"assets_warehouse:"..name.."_item")
                else 
                    minetest.add_item(addinpos,name.."_item")--(addinpos,"assets_warehouse:"..name.."_item")
                end
                return itemstack
            end,
            
            
            on_place = def.custom_function or function(itemstack, placer, pointed_thing)
                assets_warehouse_put_cloth({
                    player = placer,
                    name = name,
                    itemstack = itemstack,
                    cloth_type = def.cloth_type,
                    texture_mask = def.texture_mask
                    }
                )
                if def.cloth_type ~= "wielded" then
                    return itemstack
                end
                
            end,
            on_secondary_use = def.custom_function or function(itemstack, user, pointed_thing)
                assets_warehouse_put_cloth({
                    player = user,
                    name = name,
                    itemstack = itemstack,
                    cloth_type = def.cloth_type,
                    texture_mask = def.texture_mask
                    }
                )
                if def.cloth_type ~= "wielded" then
                    return itemstack
                end
               
            end,
            sunlight_propagates=true,
            use_texture_alpha=false,
            walkable=true,
            pointable=true,
            backface_culling = true,
        })
    end
end

function asset_warehouse_wielded_item_function(def)
    local use = def.use or 1
    local player = def.player
    for _, childrens in pairs(player:get_children()) do
        if  childrens:get_luaentity().cloth_type  then
            if  childrens:get_luaentity().cloth_type == cloth_type  then
                --minetest.log("none","Se ha encontrado ropa del mismo tipo,cancelando el poner ropa "..childrens:get_luaentity().name)
                return
            end
            if childrens:get_luaentity().cloth_type == "wielded" then
                wielding = true
            end
        end
    end

end

minetest.register_entity("assets_warehouse:bodytest", {
    mesh ='playerMD'..model_detail..'.b3d',
    texture = {'playerTQ1.png'},
    visual_size ={x=10,y=10,z=10},
    wield = "",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "body",
    physical = false,
    visual = "mesh",
    pointable = false,
    
})



minetest.register_tool('assets_warehouse:code_test', {
    mesh ='cloth1.x',
    texture = {'minint_uniform.png'},
    wield = "peppert_and_and_carrot_water_tree_guardian_armor_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "code_test",
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    range=5.0,
    
    on_use = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 50
        local controls = player:get_player_control()
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y,z=pos.z}
        
        obj = minetest.add_entity(addinpos,"assets_warehouse:bodytest")
        obj:set_bone_position("head",{x=0,y=1.5102427005767822,z=-0.11746767908334732},{x=0,y=0,z=0})
        --0.006902-0.04148,-0.117468 m Vector((3.473289922339973e-08, -0.11746767908334732, 1.5102427005767822))
        obj:set_bone_position("upperleg01.R",{x=0.101224,y=-0.07598638534545898,z=-0.030770733952522278},{x=0,y=0,z=0})
        
        --((-0., 0., -0.07598638534545898))
    end,
    
    
    
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
    backface_culling = true,
})



--Funcion que le quita la ropa al jugador,no es muy diferente de la de equipar

function assets_warehouse_put_cloth(def)
    --Obteniendo datos de el archivo players_cloths
    local world_path = minetest.get_worldpath()
    local ropas = Settings(world_path.."/players_cloths.conf")
    
    local player_hat = ropas:get("assets_warehouse_player_hat") or ""
    local player_shirt = ropas:get("assets_warehouse_player_shirt") or ""
    local player_pants = ropas:get("assets_warehouse_player_plants") or ""
    local player_gloves = ropas:get("assets_warehouse_player_gloves") or ""
    --Obteniendo datos del jugador
    local player = def.player
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local itemstack = def.itemstack
    local cloth_type = def.cloth_type
    local texture_mask = def.texture_mask or "default_mask.png"
    --Estableciendo las texturas de la ropa
    local default_texture_hat = "default_mask_hat.png"
    local default_texture_shirt = "default_mask_shirt.png"
    local default_texture_pants = "default_mask_pants.png"
    local default_texture_gloves = "default_mask_gloves.png"
    --Estableciendo las mascaras de texturas 
    local default_mask_hat = "default_mask_hat.png"
    local default_mask_shirt = "default_mask_shirt.png"
    local default_mask_pants = "default_mask_pants.png"
    local default_mask_gloves = "default_mask_gloves.png"
    local maskforpants = def.maskforpants or "default_maskforpants.png"
    
    local body = nil
    local torso = nil
    local cabeza = nil
    --Obteniendo el cuerpo del jugador
    for _, childrens in pairs(player:get_children()) do
        if  childrens:get_luaentity().cloth_type  then
            if childrens:get_luaentity().cloth_type == "body" then
                body = childrens
            end
        end
    end
    --Obteniendo el torso del jugador
    if body ~= nil  then
        for _, childrens in pairs(body:get_children()) do
            if  childrens:get_luaentity().cloth_type  then
                if childrens:get_luaentity().cloth_type == "torso" then
                    torso = childrens
                end
            end
        end
    end
    --Obteniendo la cabeza del jugador
    if torso ~= nil then
        for _, childrens in pairs(torso:get_children()) do
            if  childrens:get_luaentity().cloth_type  then
                if childrens:get_luaentity().cloth_type == "cabeza" then
                    cabeza = childrens
                end
            end
        end
    end
    
    local cloth_action = def.cloth_action or "equip"
    --Obteniendo mascaras de texturas de la ropa que el jugador lleva puesta 
    --y comprobando si el jugador esta intentando ponerse una ropa del mismo tipo que ya lleva puesta
    for _, childrens in pairs(player:get_children()) do
        if  childrens:get_luaentity().cloth_type  then
            --minetest.log("none","Se ha encontrado ropa "..childrens:get_luaentity().name)
            if  childrens:get_luaentity().cloth_type == cloth_type and cloth_action == "equip"  then
                --minetest.log("none","Se ha encontrado ropa del mismo tipo,cancelando el poner ropa "..childrens:get_luaentity().name)
                return
            end
            
        end
    end
    --for _, childrens in pairs(cabeza:get_children()) do
    --    if  childrens:get_luaentity().cloth_type  then
    --        --minetest.log("none","Se ha encontrado ropa "..childrens:get_luaentity().name)
    --        if  childrens:get_luaentity().cloth_type == cloth_type and cloth_action == "equip"  then
    --            --minetest.log("none","Se ha encontrado ropa del mismo tipo,cancelando el poner ropa "..childrens:get_luaentity().name)
    --            return
    --        end
    --        
    --    end
    --end
    -----------------------
    
    local bodypart = ""
    local bodysection = player
    if cloth_action == "equip" then
        --Obteniendo que tipo de ropa el jugador se ha puesto
        --minetest.log("none",cloth_type)
        if cloth_type == "hat" then
            player_hat = def.name
            default_mask_hat = texture_mask
            bodypart = "head"
            bodysection = cabeza
        elseif cloth_type == "shirt" then
            player_shirt = def.name
            default_mask_shirt = def.texture_mask
        elseif cloth_type == "pants" then
            player_pants = def.name
            default_mask_pants = texture_mask
        elseif cloth_type == "gloves" then
            player_gloves = def.name
            default_mask_gloves = texture_mask
        end
        --Creando ropa y pegandola al jugador
        equip = minetest.add_entity(pos,def.name.."_cloth")--(pos,"assets_warehouse:"..def.name.."_cloth")
        equip:set_attach(bodysection,bodypart,{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
        
        
        --Removiendo el objeto del inventario
        itemstack.clear(itemstack)
    end
    
    if cloth_action == "unequip" then
        --minetest.log("none","unequip")
        for _, childrens in pairs(player:get_children()) do
         --minetest.log("none",childrens:get_luaentity().name)
            --minetest.log("none",childrens:get_entity_name())
            
            if  childrens:get_luaentity().cloth_type  then
                if  childrens:get_luaentity().cloth_type == cloth_type  then
                    local name = childrens:get_luaentity().name
                    local basename = childrens:get_luaentity().basename--Habia un problema que era causado por poner una coma al final cuando no debia
                    --minetest.log("none",childrens:get_luaentity().name)
                    --obj = minetest.add_entity(addinpos,name)
                    --minetest.log("none","asset_warehouse:"..basename.."_item")
                    minetest.add_item(addinpos,basename.."_item")--(addinpos,"assets_warehouse:"..basename.."_item")
                    --assets_warehouse:"..name..'_item
                    childrens:remove(childrens:get_luaentity())
                    if cloth_type == "hat" then
                        player_hat = ""
                    end    
                    if cloth_type == "shirt" then
                        player_shirt = ""
                        for _, childrens in pairs(body:get_children()) do
                            --minetest.log("none",childrens:get_luaentity().name)    
                            if  childrens:get_luaentity().cloth_type  then
                                if  childrens:get_luaentity().cloth_type == "pants"  then
                                    local name = childrens:get_luaentity().name
                                    local basename = childrens:get_luaentity().basename
                                    local pantstexture = childrens:get_luaentity().textures[1]
                                    local maskforpants = equip:get_luaentity().maskforpants
                                    childrens:set_properties({
                                        textures = {pantstexture},        
                                    })
                                end
                            
                            end
                        end
                    end
                    if cloth_type == "pants" then
                        player_pants = ""
                    end
                    if cloth_type == "gloves" then
                        player_gloves = ""
                    end
                end
                
            end
        end
    end
    if cloth_action == "recover" then
        if player_hat ~= "" then
            equip = minetest.add_entity(pos,player_hat.."_cloth")--(pos,"assets_warehouse:"..player_hat.."_cloth")
            equip:set_attach(cabeza,"head",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
        end    
        if player_shirt ~= "" then
            equip = minetest.add_entity(pos,player_shirt.."_cloth")
            equip:set_attach(player,"",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
        end
        if player_pants ~= "" then
            equip = minetest.add_entity(pos,player_pants.."_cloth")
            equip:set_attach(player,"",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
            for _, childrens in pairs(body:get_children()) do
                --minetest.log("none",childrens:get_luaentity().name)
                if  childrens:get_luaentity().cloth_type  then
                    if  childrens:get_luaentity().cloth_type == "shirt"  then
                        local name = childrens:get_luaentity().name
                        local basename = childrens:get_luaentity().basename
                        local pantstexture = equip:get_luaentity().textures[1]
                        local masktextureforpants = childrens:get_luaentity().maskforpants
                        equip:set_properties({
                            textures = {pantstexture.."^"..masktextureforpants.."^[makealpha:0.0, 0.0, 0.0]"},        
                        })
                    end
                end
            end
        end
        if player_gloves ~= "" then
            equip = minetest.add_entity(pos,player_gloves.."_cloth")
            equip:set_attach(player,"",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
        end
    end
    
    --Guardando datos sobre que ropa lleva el jugador 
    local content = "assets_warehouse_player_hat = "..player_hat .."\n".."assets_warehouse_player_shirt = "..player_shirt.."\n".."assets_warehouse_player_plants = "..player_pants.."\n".."assets_warehouse_player_gloves = "..player_gloves
    
    minetest.safe_file_write(world_path.."/players_cloths.conf", content)
    
    --Aplicando mascara de textura en caso de haberla
    for _, childrens in pairs(player:get_children()) do
        if  childrens:get_luaentity().cloth_type  then
            --minetest.log("none","Se ha encontrado ropa "..childrens:get_luaentity().name)
           
            if childrens:get_luaentity().cloth_type == "hat" then
                default_mask_hat = childrens:get_luaentity().texture_mask
                default_texture_hat = childrens:get_luaentity().texturecloth
            elseif childrens:get_luaentity().cloth_type == "shirt" then
                default_mask_shirt = childrens:get_luaentity().texture_mask
                default_texture_shirt = childrens:get_luaentity().texturecloth
            elseif childrens:get_luaentity().cloth_type == "pants" then
                default_mask_pants = childrens:get_luaentity().texture_mask
                default_texture_pants = childrens:get_luaentity().texturecloth
            elseif childrens:get_luaentity().cloth_type == "gloves" then
                default_mask_gloves = childrens:get_luaentity().texture_mask
                default_texture_gloves = childrens:get_luaentity().texturecloth
            end
        end
    end
    
    body:set_properties({
            textures = {"("..playerskin.."^"..default_texture_hat.."^"..default_texture_shirt.."^"..default_texture_pants.."^"..default_texture_gloves.."^"..default_mask_hat.."^"..default_mask_shirt.."^"..default_mask_pants.."^"..default_mask_gloves..")^[makealpha:0.0, 0.0, 0.0]"},        
        })
    torso:set_properties({
            textures = {"("..playerskin.."^"..default_texture_hat.."^"..default_texture_shirt.."^"..default_texture_pants.."^"..default_texture_gloves.."^"..default_mask_hat.."^"..default_mask_shirt.."^"..default_mask_pants.."^"..default_mask_gloves..")^[makealpha:0.0, 0.0, 0.0]"},        
        })
        
    
    
    return itemstack
end



assets_warehouse.cloth("assets_warehouse:cannine_body",{
    mesh ='playerMD'..model_detail..'.b3d',
    texture = {playerskin},
    wield = "",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "body",
    cloth_type = "body",
    --texture_mask = "minint_uniform_mask.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehouse:piernas",{
    mesh ='piernas.b3d',
    texture = {playerskin},
    wield = "",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "body",
    cloth_type = "body",
    custon_stepwielded = function(self, dtime, moveresult)
        if moveresult  then
            if moveresult.touching_ground == true then
                self.object:set_velocity({x=0.0, y=0.0, z=0.0})
            else
                self.object:set_acceleration({x = 0, y = -1, z = 0})
            end
        end
        if self then
            if self.object then
                -- Comprueba que el personaje este emparentado al jugador
                if self.object:get_attach() == nil then
                    self.object:remove()
                else 
                    --Animaciones del personaje
                    local player = "none"
                    local body = "none"
                    if minetest.is_player(self.object:get_attach()) then
                        player = self.object:get_attach()
                        body = self.object
                    elseif minetest.is_player(self.object:get_attach():get_attach()) then
                        player = self.object:get_attach():get_attach()
                        body = self.object:get_attach()
                    end
                    if player then
                        playerstats = {
                            speed=0.5,
                            --jump=armor.def[name].jump,
                            --gravity=armor.def[name].gravity
                        }
                        player:set_physics_override(playerstats)
                        local pos = player:get_pos()
                        local controls = player:get_player_control()
                        local wielding = false
                        
                        for _, childrens in pairs(body:get_children()) do
                            if  childrens:get_luaentity().cloth_type  then
                                --minetest.log("none","Se ha encontrado ropa "..childrens:get_luaentity().name)
                                if childrens:get_luaentity().cloth_type == "wielded" then
                                    wielding = true
                                end
                                if childrens:get_luaentity().cloth_type == "wielded" then
                                    wielding = true
                                    local itemstack = player:get_wielded_item(itemstack)
                                    if itemstack.is_empty(itemstack) then 
                                        childrens:remove(childrens)   
                                        
                                        return  
                                    else 
                                        if itemstack.get_name(itemstack) .. "_wielded" ~= childrens:get_luaentity().name then
                                            childrens:remove(childrens)   
                                            return  
                                        end
                                    end
                                end
                            end
                        end
                        
                        
                        --Portando un objeto
                        -- Sin objeto    
                        player:set_eye_offset({x=0, y=0, z=0.5},{x=0, y=0, z=0}) 
                        --En guardia sin objeto
                        if controls.sneak then     
                            if controls.up then    
                                if controls.LMB  then
                                    assets_warehouse.entity_anim(self,8,130,160)
                                    self.animation = 8
                                elseif controls.RMB then
                                    assets_warehouse.entity_anim(self,8,130,160)
                                    self.animation = 8
                                else
                                    assets_warehouse.entity_anim(self,7,170,199)
                                    self.animation = 7
                                end
                            else
                                if controls.LMB  then
                                    assets_warehouse.entity_anim(self,6,110,116)
                                    self.animation = 6
                                elseif controls.RMB then
                                    assets_warehouse.entity_anim(self,6,110,116)
                                    self.animation = 6
                                else
                                    assets_warehouse.entity_anim(self,5,110,110)
                                    self.animation = 5
                                end
                            end
                        --Movimiento normal
                        elseif controls.up then
                            assets_warehouse.entity_anim(self,3,31,59)
                            self.animation = 3
                        --Quieto
                        else
                            --if controls.LMB  then
                            --    assets_warehouse.entity_anim(self,2,10,21)
                            --    self.animation = 2
                            --elseif controls.RMB then
                            --    assets_warehouse.entity_anim(self,2,10,21)
                            --    self.animation = 2
                            --else
                            assets_warehouse.entity_anim(self,1,0,30)
                            self.animation = 1
                            --end
                        end
                    end
                end
            end
        end
    end
    
})

assets_warehouse.cloth("assets_warehouse:torso",{
    mesh ='torso.b3d',
    texture = {playerskin},
    wield = "",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "torso",
    cloth_type = "torso",
    custon_stepwielded = function(self, dtime, moveresult)
        if moveresult  then
            if moveresult.touching_ground == true then
                self.object:set_velocity({x=0.0, y=0.0, z=0.0})
            else
                self.object:set_acceleration({x = 0, y = -1, z = 0})
            end
        end
        if self then
            if self.object then
                -- Comprueba que el personaje este emparentado al jugador
                if self.object:get_attach() == nil then
                    self.object:remove()
                else 
                    --Animaciones del personaje
                    local player = "none"
                    local body = "none"
                    if minetest.is_player(self.object:get_attach()) then
                        player = self.object:get_attach()
                        body = self.object
                    elseif minetest.is_player(self.object:get_attach():get_attach()) then
                        player = self.object:get_attach():get_attach()
                        body = self.object:get_attach()
                    end
                    if player then
                        local pos = player:get_pos()
                        local controls = player:get_player_control()
                        local wielding = false
                        
                        for _, childrens in pairs(body:get_children()) do
                            if  childrens:get_luaentity().cloth_type  then
                                --minetest.log("none","Se ha encontrado ropa "..childrens:get_luaentity().name)
                                if childrens:get_luaentity().cloth_type == "wielded" then
                                    wielding = true
                                end
                                if childrens:get_luaentity().cloth_type == "wielded" then
                                    wielding = true
                                    local itemstack = player:get_wielded_item(itemstack)
                                    if itemstack.is_empty(itemstack) then 
                                        childrens:remove(childrens)   
                                        
                                        return  
                                    else 
                                        if itemstack.get_name(itemstack) .. "_wielded" ~= childrens:get_luaentity().name then
                                            childrens:remove(childrens)   
                                            return  
                                        end
                                    end
                                end
                            end
                        end
                        
                        --if wielding == false and def.cloth_type == "body" then
                        --    for _, entities in pairs(minetest.registered_entities) do
                                 
                        --        local itemstack = player:get_wielded_item(itemstack)
                        --        if itemstack.is_empty(itemstack) then 
                                    --minetest.log("none","entity")  
                        --        else 
                        --            if entities.name == itemstack.get_name(itemstack) .."_wielded" then
                        --                equip = minetest.add_entity(pos,itemstack.get_name(itemstack).."_wielded")
                        --                equip:set_attach(self.object,"Item.R",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
                        --            end
                        --        end
                        --    end
                        --end
                            
                        --Portando un objeto
                        --if wielding == true then
                            --En guardia
                        player:set_eye_offset({x=0, y=0, z=0.5},{x=0, y=0, z=0})
                        
                        if controls.LMB  then
                            assets_warehouse.entity_anim(self,4,180,210)
                            self.animation = 4
                        
                        elseif controls.RMB then
                            assets_warehouse.entity_anim(self,3,240,270)
                            self.animation = 3
                        elseif controls.UP  then
                            assets_warehouse.entity_anim(self,2,31,59)
                            self.animation = 2
                        else
                            assets_warehouse.entity_anim(self,1,0,29)
                            self.animation = 1
                        end
                    end
                end
            end
        end
    end
    
})

assets_warehouse.cloth("assets_warehouse:cabeza",{
    mesh ='cabeza.b3d',
    texture = {playerskin},
    wield = "",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "cabeza",
    cloth_type = "cabeza",
    custon_stepwielded = function(self, dtime, moveresult)
        if moveresult  then
            if moveresult.touching_ground == true then
                self.object:set_velocity({x=0.0, y=0.0, z=0.0})
            else
                self.object:set_acceleration({x = 0, y = -1, z = 0})
            end
        end
        if self then
            assets_warehouse.entity_anim(self,16,90,90)
        end
    end
    
})

assets_warehouse.cloth("assets_warehouse:player_eyes",{
    mesh ='eyes.obj',
    texture = {'eyes.png'},
    wield = "",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "eyes",
    cloth_type = "eyes",
    groups = {not_in_creative_inventory = 1},
    --texture_mask = "minint_uniform_mask.png"--"minint_uniform_texture_mask.png"
    
})



player_api.register_model("playerMD1.b3d", {
    animation_speed = 30,
    textures = {"invisible.png"},
    animations = {
        -- Standard animations.
        stand     = {x = 0,   y = 79},
        lay       = {x = 162, y = 166, eye_height = 0.3, override_local = true,
            collisionbox = {-0.6, 0.0, -0.6, 0.6, 0.3, 0.6}},
        walk      = {x = 168, y = 187},
        mine      = {x = 189, y = 198},
        walk_mine = {x = 200, y = 219},
        sit       = {x = 81,  y = 160, eye_height = 0.8, override_local = true,
            collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.0, 0.3}}
    },
    collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
    stepheight = 0.6,
    eye_height = 1.57,
})


minetest.register_on_joinplayer(function(player)
    --minetest.log("none","useoldmodel"..useoldmodel)
    local useoldmodel = useoldmodel
    if useoldmodel == "true" then
        return
    end
   
    player_api.set_model(player,"playerMD1.b3d")
   
    local name = player:get_player_name()
    local pos = player:get_pos()
    if name and pos then
        pos.y = pos.y + 0.5
        local playermodel = minetest.add_entity(pos, "assets_warehouse:piernas_cloth")  
        local playertorso = minetest.add_entity(pos, "assets_warehouse:torso_cloth")  
        local playercabeza = minetest.add_entity(pos, "assets_warehouse:cabeza_cloth")  

        local eyes = minetest.add_entity(pos, "assets_warehouse:player_eyes_cloth") 
        if playermodel then
            playermodel:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            playertorso:set_attach(playermodel,"torso", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            playercabeza:set_attach(playertorso,"cabeza", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            eyes:set_attach(playercabeza,"head", {x=0, y=0, z=0}, {x=0, y=0, z=0},true)
            
            player:set_eye_offset({x=0, y=0, z=0.5},{x=0, y=0, z=0})
            
            --
        end        
    end
    
    assets_warehouse_put_cloth({
        player = player,
        cloth_action = "recover"
    })
    
      
end)

minetest.register_on_player_receive_fields(function(player, formname, fields)
    local name = player:get_player_name()
    if formname ~= "" then--por alguna extrana razon al usar sfinv para crear la seccion de los botones el formspec no tiene nombre
        --minetest.log("none","Cloth")
        return
    end

    if fields.AWUnequip_hat then
        assets_warehouse_put_cloth({
            player = player,
            cloth_type = "hat",
            cloth_action = "unequip"
        })
    elseif fields.AWUnequip_shirt then
        assets_warehouse_put_cloth({
            player = player,
            cloth_type = "shirt",
            cloth_action = "unequip"
        })
    elseif fields.AWUnequip_pants then
        assets_warehouse_put_cloth({
            player = player,
            cloth_type = "pants",
            cloth_action = "unequip"
        })
    elseif fields.AWUnequip_shirt then
        assets_warehouse_put_cloth({
            player = player,
            cloth_type = "gloves",
            cloth_action = "unequip"
        })
    elseif fields.postal_menu then
        minetest.show_formspec(playername, "assets_warehouse:",formspec_postal_stuff) 
    end
   
end)

--Se encarga de crear una pestanna en el inventario por defecto del juego en donde poderse quitar la ropa
sfinv.register_page("asset_warehouse_about:_", {
    title = "About AssetsW",
    get = function(self, player, context)
        return sfinv.make_formspec(player, context, [[
                textarea[0.1,0.1;8,6;;;About the mod:
                I don't have the property of the serie,comic,game and movies from what i based the objects of this mod,and not have any relations whit the owners,i just create the assets because they like me.This are Care Bears from Nelvana and America Greetings Cards,Aperture Desk Job from Valve,Peppert and Carrot from David Revoy,Postal Movie from Uwe Boll,project Tuxemon,zoonami mod from isahia and Hedgewars 
                Part of the code is based in give_initial_stuff from Celeron55 and others,mobs from TenPlus1,Wield3d from stujones11(Stuart Jones)
                The mesh from the book is from archimesh addon for blender from Antonio Vasquez
                The textures of the flags are from Wikikpedia,flagM26_7 is from ,Oliver Wolters,flagCuba Madden Licence PublicDomain,flagMexico Alex Covarrubias,Based on the arms by Juan Manuel Gabino Villascán. Licence PublicDomain,flagMVenezuela Licence Public Domain,flagTemplar helix84 - own work part of Image:Cyriaci.svg
                All objects and textures(except from those above)are licenced under CC-BY-SA-International 4.0
                This mod was created whit Makehuman plugin for Blender,if you want to create new cloths using this mod as base you can do it but i recomended only create hats and hand objects,you can view some of the clothes code for this and for the hand objects you need to create a entity of the carried object(item,tool or node) whit the same name]
            ]], true)
    end
})

if useoldmodel == "false" then
    sfinv.register_page("asset_warehouse_cloth:_", {
        title = "Assets",
        get = function(self, player, context)
            return sfinv.make_formspec(player, context, [[
                    --label[0,0;Catalogs]
                    --image_button[0,0.4;1,1;postal_menu.png;postal_menu;;;;postal_menu.png]
                    label[0,0;Unequip Cloth]
                    button[2,0.5;2,1;AWUnequip_hat;Hat]
                    button[2,1.0;2,1;AWUnequip_shirt;Shirt]
                    button[2,1.5;2,1;AWUnequip_pants;Pants]
                    button[2,2.0;2,1;AWUnequip_gloves;Gloves]
                    ]], true)
        end
    })
end

--set_physics_override(override_table)`
--    * `override_table` is a table with the following fields:
--        * `speed`: multiplier to default walking speed value (default: `1`)
--        * `jump`: multiplier to default jump value (default: `1`)
--        * `gravity`: multiplier to default gravity value (default: `1`)
--        * `sneak`: whether player can sneak (default: `true`)
--        * `sneak_glitch`: whether player can use the new move code replications
--          of the old sneak side-effects: sneak ladders and 2 node sneak jump
--          (default: `false`)
--        * `new_move`: use new move/sneak code. When `false` the exact old code
--          is used for the specific old sneak behaviour (default: `true`)

--def = {
--    speed=armor.def[name].speed,
--    jump=armor.def[name].jump,
--    gravity=armor.def[name].gravity
--}