local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = minetest.settings:get("assets_warehouse_model_quality") or 1
texture_detail = minetest.settings:get("assets_warehouse_texture_quality") or 1
local idioma = settings:get("assets_warehouse_idioma") or "espanol"

local postal_oldtvdescripcion = "A old tv"
local postal_oldrefri_descripcion = "A old refri"
local postal_dude_bed_descripcion = "The bed of the postal dude in this bed the peoples fells like rockstars"
local postal_uncle_dave_bed_descripcion = "The bed of Uncle Dave"

if idioma == "espanol" then
    postal_oldtvdescripcion = "Una vieja tele"
    postal_oldrefri_descripcion = "Un viejo refrigerador"
    postal_dude_bed_descripcion = "La cama del sujeto de las postales,en esta cama la gente se siente como estrellas de rock"
    postal_uncle_dave_bed_descripcion = "La cama de Dave"
end

assets_warehouse.item("assets_warehouse:postal_krutchy",{
    mesh ='krutchyMD'..model_detail..'.obj',
    texture = {'krutchy.png'},
    wield = "krutchypreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = "krutchy is a doll whith a dangerous content",
    atack = "assets_warehouse:krutchy_atack",
    custom_function = function(itemstack, placer, pointed_thing)
         minetest.log("none", "Only my father and my priester can touch me there")
    end,
})

assets_warehouse:register_attack("assets_warehouse:krutchy_atack", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    textures = {'atack.png'},
    damage = 1,
    lifetime = 0.2,

    
    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 2},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})



minetest.register_node('assets_warehouse:postal_oldtv', {
    drawtype = 'mesh',
    mesh = 'oldtv.obj',
    tiles ={'oldtv.png'}, 
    description= postal_oldtvdescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.3,0.0,-0.25,0.3,-0.5,0.25},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.3,0.0,-0.25,0.3,-0.5,0.25},		
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:postal_oldrefri', {
    drawtype = 'mesh',
    mesh = 'oldrefri.obj',
    tiles ={'oldrefri.png'}, 
    description= postal_oldrefri_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.35,1.25,0.0,0.35,-0.5,0.5},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.35,1.25,0.0,0.35,-0.5,0.5},		
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:postal_dude_bed', {
    drawtype = 'mesh',
    mesh = 'postal_dude_bed.obj',
    tiles ={'postal_dude_bed.png'}, 
    description= postal_dude_bed_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        if minetest.get_modpath("beds") then
            beds.on_rightclick(pos, clicker)
        end
        return itemstack
    end,
    selection_box = {
        type = "fixed",
        fixed = {
            {-1.0,-0.1,-0.5,0.5,-0.5,1.4},
            {-1.0,0.2,1.4,0.5,-0.5,1.5},
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-1.0,-0.1,-0.5,0.5,-0.5,1.4},
            {-1.0,0.2,1.4,0.5,-0.5,1.5},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:postal_uncle_dave_bed', {
    drawtype = 'mesh',
    mesh = 'postal_uncle_dave_bed.obj',
    tiles ={'postal_uncle_dave_bed.png'}, 
    description= postal_uncle_dave_bed_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        if minetest.get_modpath("beds") then
            beds.on_rightclick(pos, clicker)
        end
        return itemstack
    end,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.9,-0.1,1.45,0.55,-0.5,-0.2},
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.9,-0.1,1.45,0.55,-0.5,-0.2},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})