local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
idioma = settings:get("assets_warehouse_idioma") or "espanol"

local palareforzadadescripcion = "A reinforced iron shovel"
local destapadordescripcion = "A horn?"
local simple_jacketdescripcion = "A simple jacket"
local plantdecorationdescripcion = "A plant"

if idoma == "espanol" then
    palareforzadadescripcion = "Una pala reforzada"
    destapadordescripcion = "Un cuerno?"
    simple_jacketdescripcion = "Una chaqueta simple"
    plantdecorationdescripcion = "Una planta"

end

minetest.override_item("default:dirt_with_grass",{
    tiles = {{name = "grass4TQ"..texture_detail..".png", align_style = "world",scale = 8}, "default_dirt.png",
        {name = "default_dirt.png^default_grass_side.png",
            tileable_vertical = true}},

})



for i = 1, 5 do
    minetest.register_node("assets_warehousepart2:plantdecoration" .. i, {
        description = plantdecorationdescripcion,
        drawtype = "mesh",
        mesh = "plantdecoration"..i..".obj",
        waving = 1,
        tiles = {"plantdecoration"..i..".png"},
        paramtype = "light",
        sunlight_propagates = true,
        walkable = false,
        buildable_to = true,
        groups = {snappy = 3, flammable = 3, flora = 1, attached_node = 1,
            grass = 1, fern = 1},
        sounds = default.node_sound_leaves_defaults(),
        
    })
end