--Settings(filename)
--local newstack = ItemStack("default:dirt")

local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 1
texture_detail = settings:get("assets_warehouse_texture_quality") or 1
player_model = settings:get("assets_wareohuse_player_model") or "false"
idioma = settings:get("assets_warehouse_idioma") or "espanol"
model = settings:get("assets_wareohuse_model") or "assets_warehouse:cannine_body_cloth"
playerskin = settings:get("assets_wareohuse_skin") or "playerTQ1.png"
local part1 = "textarea[0.5,10.5;90,8;;;Assets Warehouse configuration menu,for the changes take effect you need to restart the game ]"
local part2 = "textarea[0.5,20.5;90,4;;;Model Quality ]"
local part3 = "textarea[0.5,80.5;90,4;;;Texture Quality ]"
local part4 = "textarea[0.5,120;90,10;;;Player mode]"
local part5 = "textarea[0.5,150;90,20;;;Lenguage]"
local part6 = "textarea[0.5,180;90,20;;;]"
local part7 = "textarea[0.5,180;90,20;;;Test]"
local part8 = "textarea[0.5,180;90,20;;;]"
local part9 = "textarea[0.5,180;90,20;;;]"

if minetest.get_modpath("assets_warehousepart2") then
    part6 = "textarea[0.5,180;90,20;;;Model]"
    part7 = "button_exit[0.5,190;20,5;cannine;cannine]"
    part8 = "button_exit[40,190;20,5;bunny;bunny]"
    part9 = "button_exit[60,190;20,5;brown;alternativeskin]"
end

if idioma == "espanol" then
    part1 = "textarea[0.5,10.5;90,8;;;Menu de configuracion de Assets Warehouse,para que los cambios hagan efecto debe reiniciar el juego]"
    part2 = "textarea[0.5,20.5;90,4;;;Calidad de los modelos ]"
    part3 = "textarea[0.5,80.5;90,4;;;Calidad de las texturas ]"
    part4 = "textarea[0.5,120;90,10;;;Modelo del jugador]"
    part5 = "textarea[0.5,150;90,20;;;Idioma]"
    
end



local formspec_config = { 
        "formspec_version[4]",
        "size[100,100]",
        "anchor[0.5,0.5]",
        "padding[0.0,0.0]",
        "scrollbaroptions[min=0,max=100,smallstep=10,largestep=20,thumbsize=10,arrows=default]",
        "scrollbar[95,0;5,100;vertical;'testscroll';]",
        "scroll_container[1.10,0.0;90,150;'testscroll';vertical;0.1]",
        part1,
        part2,
        "model[0,30;30,30;'peppert_and_carrot_water_tree';peppert_and_carrot_watertreeMD1.obj;peppert_and_carrot_watertree.png;]",
        "model[30,30;30,30;'peppert_and_carrot_water_tree';peppert_and_carrot_watertreeMD2.obj;peppert_and_carrot_watertree.png;]",
        "model[60,30;30,30;'peppert_and_carrot_water_tree';peppert_and_carrot_watertreeMD3.obj;peppert_and_carrot_watertree.png;]",
        "button_exit[0.5,70;10,5;Low;1]",
        "button_exit[30,70;10,5;Medium;2]",
        "button_exit[60,70;10,5;High;3]",
        part3,
        "model[0,90;30,15;'rusticbancpalau';rusticbancpalauMD2.obj;rusticbancpalauTQ1.png;]", 
        "model[30,90;30,15;'rusticbancpalau';rusticbancpalauMD2.obj;rusticbancpalauTQ2.png;]", 
        "model[60,90;30,15;'rusticbancpalau';rusticbancpalauMD2.obj;rusticbancpalauTQ3.png;]", 
        "button_exit[0.5,110;10,5;TextureLow;1]",
        "button_exit[30,110;10,5;TextureMediun;2]",
        "button_exit[60,110;10,5;TextureHigh;3]",
        part4,
        "button_exit[0,130;20,5;oldmodel;Minetest]",
        "button_exit[40,130;40,5;aw_model;Assets Warehouse]",
        part5,
        "button_exit[0,160;40,5;espanol;Usar el lenguage espanol]",
        "button_exit[40,160;40,5;english;Use English spech]",
        part6,
        part7,
        part8,
        part9,
        "scroll_container_end[]",
}

formspec_config =  table.concat(formspec_config, "")

minetest.register_on_player_receive_fields(function(player, formname, fields)
    local name = player:get_player_name()
    
    local settings = Settings(world_path.."/assets_warehouse.conf")
    if formname ~= "assets_warehouse:config_menu" then
        return
    end

    if fields.Low then
        model_detail = 1
    elseif fields.Medium then
        model_detail = 2
    elseif fields.High then
        model_detail = 3
    elseif fields.TextureLow then
        texture_detail = 1
    elseif fields.TextureMediun then
        texture_detail = 2
    elseif fields.TextureHigh then
        texture_detail = 3
    elseif fields.oldmodel then
        useoldmodel = true
    elseif fields.aw_model then
        useoldmodel = false
    elseif fields.espanol then
        idioma = "espanol"
    elseif fields.english then
        idioma = "english"
    --elseif fields.cannine then
    --    model = "assets_warehouse:cannine_body_cloth"
    --    playerskin = "playerTQ1.png"
    --elseif fields.bunny then
    --    playerskin = "bunnyskin.png"
    --    model = "assets_warehousepart2:bunny_body_cloth"
    --elseif fields.brown then
    --    playerskin = "brown.png"
    
    end
    
    local content = "assets_warehouse_model_quality = "..model_detail .."\n".."assets_warehouse_texture_quality = "..texture_detail.."\n".."assets_wareohuse_use_oldmodel = "..tostring(useoldmodel).."\n".."assets_warehouse_idioma = "..idioma .."\n".."assets_wareohuse_model = "..model.."\n".."assets_wareohuse_skin = "..playerskin
    
    minetest.safe_file_write(world_path.."/assets_warehouse.conf", content)
    
end)

minetest.register_tool("assets_warehouse:config_menu", {
    description = "configuration_menu",
    tiles = "configuration_menu.png",
    inventory_image = "configuration_menu.png",
    wield_image = "configuration_menu.png",
    groups = {cracky = 1},
    on_use = function(itemstack, player, pointed_thing)
        local playername = player:get_player_name()
        if pointed_thing.type == "node" then
            minetest.show_formspec(playername, "assets_warehouse:config_menu",formspec_config) 
        else 
            minetest.show_formspec(playername, "assets_warehouse:config_menu",formspec_config)    
        end
    end,
    on_receive_fields = function(pos, formname, fields, player)
        if fields.quit then
            return
        end

        print(fields.x)
    end
})