local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")


model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2

--The trees are based in those who appear in Peppert and Carrot Episode 26
minetest.register_node('assets_warehouse:tree1', {
    drawtype = 'mesh',
    mesh = 'tree1.obj',
    tiles ={'vegetattion_treeTQ'..texture_detail..'.png'}, 
    description= 'A tree',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.8,-0.5,0.5},
            {0,3.5,-0.45,1.0,0.5,0.45},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.8,-0.5,0.5},
            {0,3.5,-0.45,1.0,0.5,0.45},	
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:tree2', {
    drawtype = 'mesh',
    mesh = 'tree2.obj',
    tiles ={'vegetattion_tree2TQ'..texture_detail..'.png'}, 
    description= 'A tree',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.35,0.5,-0.35,1.0,-0.5,0.35},--Low
            {-0.35,1.5,-0.35,0.8,0.5,0.35},--MediumLow
            {0.75,3.0,-0.35,1.2,1.5,0.35},--MediumUp
            	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.35,0.5,-0.35,1.0,-0.5,0.35},--Low
            {-0.35,1.5,-0.35,0.8,0.5,0.35},--MediumLow
            {0.75,3.0,-0.35,1.2,1.5,0.35},--MediumUp
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_node('assets_warehouse:tree3', {
    drawtype = 'mesh',
    mesh = 'tree3.obj',
    tiles ={'vegetattion_tree3TQ'..texture_detail..'.png'}, 
    description= 'A tree',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.35,4.5,-0.35,0.35,-0.5,0.35},--Low
            
                
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.35,0.5,-0.35,1.0,-0.5,0.35},--Low
            
        },	
    },
    paramtype="light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

minetest.register_biome({
    name = "AW_forest",
    node_top = "default:dirt_with_grass",
    depth_top = 1,
    node_filler = "default:dirt",
    depth_filler = 1,
    node_riverbed = "default:sand",
    depth_riverbed = 2,
    node_dungeon = "default:cobble",
    node_dungeon_alt = "default:mossycobble",
    node_dungeon_stair = "stairs:stair_cobble",
    y_max = 31000,
    y_min = 6,
    heat_point = 50,
    humidity_point = 35,
})

minetest.register_decoration({
        name = "assets_warehouse:tree1",
        deco_type = "schematic",
        place_on = {"default:dirt_with_grass"},
        sidelen = 16,
        noise_params = {
            offset = 0.024,
            scale = 0.015,
            spread = {x = 250, y = 250, z = 250},
            seed = 2,
            octaves = 3,
            persist = 0.66
        },
        biomes = {"AW_forest","grassland"},
        y_max = 31000,
        y_min = 1,
        schematic = minetest.get_modpath("assets_warehouse") .. "/schematics/assets_warehouse_tree1.mts",
        flags = "place_center_x, place_center_z",
        rotation = "random",
    })
minetest.register_decoration({
        name = "assets_warehouse:tree2",
        deco_type = "schematic",
        place_on = {"default:dirt_with_grass"},
        sidelen = 16,
        noise_params = {
            offset = 0.024,
            scale = 0.015,
            spread = {x = 250, y = 250, z = 250},
            seed = 2,
            octaves = 3,
            persist = 0.66
        },
        biomes = {"AW_forest","grassland"},
        y_max = 31000,
        y_min = 1,
        schematic = minetest.get_modpath("assets_warehouse") .. "/schematics/assets_warehouse_tree2.mts",
        flags = "place_center_x, place_center_z",
        rotation = "random",
    })
minetest.register_decoration({
        name = "assets_warehouse:tree3",
        deco_type = "schematic",
        place_on = {"default:dirt_with_grass"},
        sidelen = 16,
        noise_params = {
            offset = 0.024,
            scale = 0.015,
            spread = {x = 250, y = 250, z = 250},
            seed = 2,
            octaves = 3,
            persist = 0.66
        },
        biomes = {"AW_forest","grassland"},
        y_max = 31000,
        y_min = 1,
        schematic = minetest.get_modpath("assets_warehouse") .. "/schematics/assets_warehouse_tree3.mts",
        flags = "place_center_x, place_center_z",
        rotation = "random",
    })