
local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2

local idioma = settings:get("assets_warehouse_idioma") or "espanol"

local bed_nordic_descripcion = "A bed in nordic style"
local writtetable_colony_flash_descripcion = "A colony style writtetable in flash design"
local writtetable_colony_nova_descripcion = "A colony style writtetable in nova design"
local chair_colony_palau_descripcion = "Chair with a palau design"
local chair_nordic_descripcion = "Chair with a nordic design"
local couch_descripcion = "A couch"
local shouwcase_colony_descripcion = "A shouwcase"
local rusticbancpalau_descripcion = "A rustic banc in a palau design"
local armchair_descripcion = "A armchair"
local pelotadenitroglicerina_descripcion = "Beware"
local hedge_descripcion =  "A little hedege who carry a toon of weapons"

if idioma == "espanol" then
    bed_nordic_descripcion = "Una cama en estilo nordico"
    writtetable_colony_flash_descripcion = "Una mesa colonial de escribir en diseño flash"
    writtetable_colony_nova_descripcion = "Una mesa colonial de escribir en diseño nova"
    chair_colony_palau_descripcion = "Silla con diseño palau"
    chair_nordic_descripcion = "Silla con diseño nordico"
    couch_descripcion = "Un sofa"
    shouwcase_colony_descripcion = "Una vitrina"
    rusticbancpalau_descripcion = "Un banco rustico en estilo palau"
    armchair_descripcion = "Un armario"
    pelotadenitroglicerina_descripcion = "Cuidado"
    hedge_descripcion =  "Una pequeño herizo que carga un monton de armas"
end

minetest.register_node('assets_warehouse:bed_nordic', {
    drawtype = 'mesh',
    mesh = 'bed_nordic.obj',
    tiles ={'bed_nordicTQ'..texture_detail..'.png'}, 
    description= bed_nordic_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3, bed = 1},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        if minetest.get_modpath("beds") then
            beds.on_rightclick(pos, clicker)
        end
        return itemstack
    end,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,-0.1,-0.5,0.5,-0.5,1.5},	
            {-0.5,0.5,1.4,0.5,-0.5,1.5},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,-0.1,-0.5,0.5,-0.5,1.5},	
            {-0.5,0.5,1.4,0.5,-0.5,1.5},		
        },	
    },
    sunlight_propagates=false,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

assets_warehouse.set_and_get_storage(5,5,1,3,"assets_warehouse:writtetable_colony_flash",writtetable_colony_flash_descripcion,'writtetable_colony_flash.obj',{'writtetable_colony_flashTQ'..texture_detail..'.png'},
{type = "fixed",fixed = {{-0.5,0.3,-0.1,0.5,-0.5,0.5},},},{type = "fixed",fixed = {{-0.5,0.3,-0.1,0.5,-0.5,0.5},},})

assets_warehouse.set_and_get_storage(5,5,1,3,"assets_warehouse:writtetable_colony_nova",writtetable_colony_nova_descripcion,'writtetable_colony_nova.obj',{'writtetable_colony_novaTQ'..texture_detail..'.png'},
{type = "fixed",fixed = {{-0.25,0.05,0.1,0.25,-0.5,0.5},},},{type = "fixed",fixed = {{-0.25,0.05,0.1,0.25,-0.5,0.5},},})

minetest.register_node('assets_warehouse:chair_colony_palau', {
    drawtype = 'mesh',
    mesh = 'chair_colony_palauMD'..model_detail..'.obj',
    tiles ={'chair_colony_palauTQ'..texture_detail..'.png'}, 
    description= chair_colony_palau_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3, bed = 1},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.1,0,0.2,-0.5,0.4},	
            {-0.2,0.5,0.35,0.2,-0.5,0.4},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.1,0,0.2,-0.5,0.4},	
            {-0.2,0.5,0.35,0.2,-0.5,0.4},		
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})
minetest.register_node('assets_warehouse:chair_nordic', {
    drawtype = 'mesh',
    mesh = 'chair_nordicMD'..model_detail..'.obj',
    tiles ={'chair_nordicTQ'..texture_detail..'.png'}, 
    description= chair_nordic_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3, bed = 1},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.05,-0.05,0.2,-0.5,0.4},	
            {-0.2,0.4,0.35,0.2,-0.5,0.4},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.2,-0.05,-0.05,0.2,-0.5,0.4},	
            {-0.2,0.4,0.35,0.2,-0.5,0.4},	
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})
minetest.register_node('assets_warehouse:couch', {
    drawtype = 'mesh',
    mesh = 'couchMD'..model_detail..'.obj',
    tiles ={'couchTQ'..texture_detail..'.png'}, 
    description= couch_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3, bed = 1},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,-0.2,-0.44,1.65,-0.5,0.5},	
            {-0.5,0.2,0.2,1.65,-0.5,0.5},
            {-0.5,0.2,-0.44,-0.15,-0.5,0.5},
            {1.3,0.2,-0.44,1.65,-0.5,0.5},
                    
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,-0.2,-0.44,1.65,-0.5,0.5},	
            {-0.5,0.2,0.2,1.65,-0.5,0.5},
            {-0.5,0.2,-0.44,-0.15,-0.5,0.5},
            {1.3,0.2,-0.44,1.65,-0.5,0.5},
                    
        },	
    },
    sunlight_propagates=false,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

assets_warehouse.set_and_get_storage(5,5,1,5,"assets_warehouse:shouwcase_colony",shouwcase_colony_descripcion,'shouwcase_colony.obj',{'shouwcase_colonyTQ'..texture_detail..'.png'},
{type = "fixed",fixed = {{-0.2,0.85,0.1,0.2,-0.5,0.5},},},{type = "fixed",fixed = {{-0.2,0.85,0.1,0.2,-0.5,0.5},},})



minetest.register_node('assets_warehouse:rusticbancpalau', {
    drawtype = 'mesh',
    mesh = 'rusticbancpalauMD'..model_detail..'.obj',
    tiles ={'rusticbancpalauTQ'..texture_detail..'.png'}, 
    description= rusticbancpalau_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3, bed = 1},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.45,0.0,-0.2,0.45,-0.5,0.2},	
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.45,0.0,-0.2,0.45,-0.5,0.2},	
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

assets_warehouse.set_and_get_storage(5,5,1,5,"assets_warehouse:armchair",armchair_descripcion,'armchair.obj',{'armchairTQ'..texture_detail..'.png'},
{type = "fixed",fixed = {{-0.5,0.4,0.06,0.5,-0.5,0.53},},},{type = "fixed",fixed = {{-0.5,0.4,0.06,0.5,-0.5,0.53},},})


assets_warehouse.item("assets_warehouse:elpidio_valdez_pelota_de_nitroglicerina",{
    texture = {'nitroglicerine_pelota.png'},
    wield = "nitroglicerine_pelota.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = pelotadenitroglicerina_descripcion,
    atack = "assets_warehouse:peppert_and_carrot_staff_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            tnt.boom(pos, {damage_radius=3,radius=2,ignore_protection=false})
            itemstack.clear(itemstack)
            return itemstack
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_staff_special")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)
            itemstack.clear(itemstack)
            return itemstack
        end
       
    end,
})

minetest.register_node('assets_warehouse:hedge', {
    drawtype = 'mesh',
    mesh = 'hedgeMD'..model_detail..'.obj',
    tiles ={'hedge.png'}, 
    description= hedge_descripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},			
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.5,0.5,-0.5,0.5,-0.5,0.5},
        },	
    },
    paramtype = "light",
    sunlight_propagates=true,
    use_texture_alpha=true,
    walkable=true,
    pointable=true,
})