local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = minetest.settings:get("assets_warehouse_model_quality") or 1
texture_detail = minetest.settings:get("assets_warehouse_texture_quality") or 1
local idioma = settings:get("assets_warehouse_idioma") or "espanol"

local part1 = "textarea[0.1,10;90,50;;;This is the catalog of the assets based in those from the Postal Movie of Uwe Boll ]"
local part2 = "textarea[0.1,50;40,40;;;A old tv who  only shows canals whit bad news]"
local part3 = "textarea[0.1,80;40,40;;;This is a old refrigenrator who can't let the milk in good state ]"
local part4 = "textarea[0.1,140;40,40;;;The bed of the postal dude, in this bed the people fells like rockstars,in this bed reckneds,polices even olds has have fun ]"
local part5 = "textarea[0.1,190;40,40;;;The bed of Dave,this bed is a important part of his cult,in her theres the 'initiation' of the females of the cult,not recommended for Talibans ]"

if idioma == "espanol" then
    part1 = "textarea[0.1,10;90,50;;;Este es el catalogo de los assets basados en esos de la pelicula Postal de Uwe Boll  ]"
    part2 = "textarea[0.1,50;40,40;;;Una vieja tele que solo muestra canales con malas noticias]"
    part3 = "textarea[0.1,80;40,40;;;Es un viejo refrigerador que no puede dejar la leche en buen estado]"
    part4 = "textarea[0.1,140;40,40;;;Esta es la cama del sujeto de las postales,en esta cama la gente se siente como estrellas de rock,en esta cama recneds,policias e incluso viejos tienen diversion ]"
    part5 = "textarea[0.1,190;40,40;;;La cama de Dave,esta cama es parte importante de su culto,en ella sucede la iniciacion de las hembras del culto,no recomendada para Talibanes ]"

end

local formspec_postal_stuff = {
    "formspec_version[4]",
    "size[100,100]",
    "anchor[0.5,0.5]",
    "padding[0.0,0.0]",
    "scrollbaroptions[min=0,max=100,smallstep=10,largestep=20,thumbsize=10,arrows=default]",
    "scrollbar[95,0;5,100;vertical;'testscroll';]",
    "scroll_container[1.10,0.0;90,100;'testscroll';vertical;0.25]",
    
    part1,
    
    part2,
    "model[40,50;50,25;'oldtv';oldtv.obj;oldtv.png;]",
    
    part3,
    "model[40,80;50,50;'oldrefri';oldrefri.obj;oldrefri.png;]",
    
    part4,
    "model[40,140;100,50;'postal_dude_bed';postal_dude_bed_catalog.obj;postal_dude_bed.png;]",
    
    part5,
    "model[40,190;100,50;'postal_uncle_dave_bed_catalog';postal_uncle_dave_bed_catalog.obj;postal_uncle_dave_bed.png;]",
    
    
    "scroll_container_end[]",   
}

formspec_postal_stuff =  table.concat(formspec_postal_stuff, "")



minetest.register_tool("assets_warehouse:postal_stuf", {
    description = "postal_stuff_catalog",
    tiles = "postal_menu.png",
    inventory_image = "postal_menu.png",
    wield_image = "postal_menu.png",
    groups = {cracky = 1},
    on_use = function(itemstack, player, pointed_thing)
        local playerpos = player:get_pos()
        local playername = player:get_player_name()
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 50
        if pointed_thing.type == "node" then
            minetest.show_formspec(playername, "assets_warehouse:",formspec_postal_stuff) 
        else 
            minetest.show_formspec(playername, "assets_warehouse:testformspec",formspec_postal_stuff)    
        end
    end,
    on_receive_fields = function(pos, formname, fields, player)
        if fields.quit then
            return
        end

        print(fields.x)
    end
})