local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2

minetest.log("none","Shirt2")
assets_warehouse.cloth("assets_warehousepart2:shirt1",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'shirt_1.png'},
    wield = "shirt1_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "shirt_1",
    cloth_type = "shirt",
    texture_mask = "tshirt_mask.png"--"minint_uniform_texture_mask.png"    
})
assets_warehouse.cloth("assets_warehousepart2:pants1",{
    mesh ='base_pantsMD3.b3d',--..model_detail..'.b3d',
    texture = {'pants.png'},
    wield = "pants_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "pants",
    cloth_type = "pants",
    texture_mask = "default_mask_pants.png"--"minint_uniform_texture_mask.png"    
})

assets_warehouse.cloth("assets_warehousepart2:shampo_cloth",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'shampo_cloth.png'},
    wield = "shampo_cloth_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "shampo_cloth",
    cloth_type = "shirt",
    texture_mask = "tshirt_mask.png"--"minint_uniform_texture_mask.png"    
})

assets_warehouse.cloth("assets_warehousepart2:light_blue_pants",{
    mesh ='base_pantsMD3.b3d',--..model_detail..'.b3d',
    texture = {'light_blue_pants.png'},
    wield = "light_blue_pants_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "pants",
    cloth_type = "pants",
    texture_mask = "default_mask_pants.png"--"minint_uniform_texture_mask.png"    
})

assets_warehouse.cloth("assets_warehousepart2:bandana",{
    mesh ='bandana.obj',
    texture = {'bandana.png'},
    wield = "bandana_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "bandana",
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"    
})

assets_warehouse.item("assets_warehousepart2:wesnoth_magic_wand",{
    wield_mesh ='wesnoth_magic_wandMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='wesnoth_magic_wandMD'..model_detail..'.obj',
    texture = {'wesnoth_magic_wand.png'},
    wield = "wesnoth_magic_wand_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = "A wand used by the magicians",
    atack = "assets_warehouse2:wesnoth_magic_wand_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            obj = minetest.add_entity(addinpos,"assets_warehouse2:wesnoth_magic_wand_atack")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse2:wesnoth_magic_wand_atack")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        end
       
    end,
})

assets_warehouse:register_attack("assets_warehousepart2:wesnoth_magic_wand_atack", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    textures = {'wesnoth_magic_wand_atack.png'},
    damage = 1,
    lifetime = 4,
    --range = 1,

    -- direct hit
    --hit_player = function(self, player)
    --    player:punch(self.object, 1.0, {
    --        full_punch_interval = 1.0,
    --        damage_groups = {fleshy = 2},
    --    }, nil)
    --end,

    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 5},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})
