local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
idioma = settings:get("assets_warehouse_idioma") or "espanol"

local machete1_descripcion = "To machete"
local mambi_hat = "A hat"
local camisa_descripcion = "Shirt"
local camisa_soldado_descripcion = "Shirt of a guard"
local sombero_soldado_descripcion = "Hat of soldier"
if idioma == "espanol" then
    machete1_descripcion = "Al machete"
    mambi_hat = "Un sombrero"
    camisa_descripcion = "Una camisa"
    camisa_soldado_descripcion = "Camisa de un guardia"
    sombero_soldado_descripcion = "Sombrero de soldado"
end

assets_warehouse.item("assets_warehousepart2:elpidio_valdez_machete_1",{
    wield_mesh ='macheteMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='macheteMD'..model_detail..'.obj',
    texture = {'elpidio_valdez_machete.png'},
    wield = "elpidio_valdez_machete_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = machete1_descripcion,
    atack = "assets_warehouse2:wesnoth_magic_wand_atack",
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_hat1",{
    mesh ='mambi_hat_1MD'..model_detail..'.obj',
    texture = {'elpidio_valdez_mambi_hat.png'},
    wield = "elpidio_valdez_mambi_hat_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = mambi_hat,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_shirt1",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'elpidio_valdez_mambi_cloth_1.png'},
    wield = "elpidio_valdez_mambi_cloth_1_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = camisa_descripcion,
    cloth_type = "shirt",
    texture_mask = "elpidio_valdez_mambi_cloth_1mask.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_shirt2",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'elpidio_valdez_mambi_cloth_2.png'},
    wield = "elpidio_valdez_mambi_cloth_2_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = camisa_descripcion,
    cloth_type = "shirt",
    texture_mask = "elpidio_valdez_mambi_cloth_2mask.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_shirt3",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'elpidio_valdez_mambi_cloth_3.png'},
    wield = "elpidio_valdez_mambi_cloth_3_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = camisa_descripcion,
    cloth_type = "shirt",
    texture_mask = "elpidio_valdez_mambi_cloth_1mask.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_hat2",{
    mesh ='mambi_hat_1MD'..model_detail..'.obj',
    texture = {'elpidio_valdez_mambi_hat2.png'},
    wield = "elpidio_valdez_mambi_hat2_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = mambi_hat,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_soldier_hat",{
    mesh ='soldier_hatMD'..model_detail..'.obj',
    texture = {'elpidio_valdez_soldier_hat.png'},
    wield = "elpidio_valdez_soldier_hat_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = sombero_soldado_descripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_soldier_cloth",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'elpidio_valdez_soldier_cloth.png'},
    wield = "elpidio_valdez_soldier_cloth_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = camisa_soldado_descripcion,
    cloth_type = "shirt",
    texture_mask = "elpidio_valdez_mambi_cloth_1mask.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_rezoplez_cloth",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'elpidio_valdez_rezoplez_cloth.png'},
    wield = "elpidio_valdez_rezoplez_cloth_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = camisa_soldado_descripcion,
    cloth_type = "shirt",
    texture_mask = "elpidio_valdez_mambi_cloth_1mask.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_zetacio_cloth",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'elpidio_valdez_zetacio_cloth.png'},
    wield = "elpidio_valdez_zetacio_cloth_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = camisa_soldado_descripcion,
    cloth_type = "shirt",
    texture_mask = "elpidio_valdez_mambi_cloth_1mask.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:elpidio_valdez_soldier_hat2",{
    mesh ='soldier_hat2MD'..model_detail..'.obj',
    texture = {'elpidio_valdez_soldier_hat2.png'},
    wield = "elpidio_valdez_soldier_hat2_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = sombero_soldado_descripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})
