local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")


model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2


assets_warehouse.item("assets_warehousepart2:peppert_and_carrot_sword_of_dark_knight",{
    wield_mesh ='peppert_and_carrot_sword_of_dark_knightMD'..model_detail..'.obj',--'peppert_and_carrot_sword1_wield.x',
    wielded_entity = true,
    mesh ='peppert_and_carrot_sword_of_dark_knightMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_sword_of_dark_knight.png'},
    wield = "peppert_and_carrot_sword_of_dark_knight_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "A sword of a magic knight",
    atack = "assets_warehouse:peppert_and_carrot_sword1_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        end
       
    end,
})

minetest.register_node('assets_warehousepart2:peppert_and_carrot_pumpkinstar', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_pumkpinstarMD'..model_detail..'.obj',
    tiles ={'peppert_and_carrot_pumkpinstar.png'}, 
    description= 'Pumpking in form of star',
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.25,-0.5,-0.25,0.25,-0.25,0.25},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.25,0.25,-0.25,0.25,-0.25,0.25},		
        },	
    },
    on_use = minetest.item_eat(4),
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})