local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
idioma = settings:get("assets_warehouse_idioma") or "espanol"

local royal_robedescripcion = "A royal robe"
local heavy_hammerdescripcion = "A hammer"
local shirtdescripcion = "A shirt"
local pantsdescripcion = "Pants"
local wesnoth_magic_wanddescripcion = "A wand used by the magicians"
local training_long_sworddescripcion = "Almost like fight whit a feather"
local reinforced_iron_pickdescripcion = "A reincorced pick"
local palareforzadadescripcion = "A reinforced iron shovel"
local destapadordescripcion = "A horn?"
local simple_jacketdescripcion = "A simple jacket"
local barcodepapeldescripcion= "My friend"

if idioma == "espanol" then
    royal_robedescripcion = "Una bata de la realeza"
    heavy_hammerdescripcion = "Un martillo"
    shirtdescripcion = "Una camisa"
    pantsdescripcion = "Pantalones"
    wesnoth_magic_wanddescripcion = "Una bara usada por los magos"
    training_long_sworddescripcion ="Casi como luchar con una pluma"
    reinforced_iron_pickdescripcion = "Un pico reforzado"
    palareforzadadescripcion = "Una pala reforzada"
    destapadordescripcion = "Un cuerno?"
    simple_jacketdescripcion = "Una chaqueta simple"
    barcodepapeldescripcion = "Mi amigo"
end



minetest.log("none","Shirt2")
assets_warehouse.cloth("assets_warehousepart2:shirt1",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'shirt_1.png'},
    wield = "shirt1_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = shirtdescripcion,
    cloth_type = "shirt",
    texture_mask = "tshirt_mask.png"--"minint_uniform_texture_mask.png"    
})
assets_warehouse.cloth("assets_warehousepart2:pants1",{
    mesh ='base_pantsMD'..model_detail..'.b3d',
    texture = {'pants.png'},
    wield = "pants_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = pantsdescripcion,
    cloth_type = "pants",
    texture_mask = "default_mask_pants.png"--"minint_uniform_texture_mask.png"    
})

assets_warehouse.cloth("assets_warehousepart2:light_blue_pants",{
    mesh ='base_pantsMD'..model_detail..'.b3d',
    texture = {'light_blue_pants.png'},
    wield = "light_blue_pants_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = pantsdescripcion,
    cloth_type = "pants",
    texture_mask = "default_mask_pants.png"--"minint_uniform_texture_mask.png"    
})

assets_warehouse.cloth("assets_warehousepart2:bandana",{
    mesh ='bandana.obj',
    texture = {'bandana.png'},
    wield = "bandana_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "bandana",
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"    
})

assets_warehouse.item("assets_warehousepart2:wesnoth_magic_wand",{
    wield_mesh ='wesnoth_magic_wandMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='wesnoth_magic_wandMD'..model_detail..'.obj',
    texture = {'wesnoth_magic_wand.png'},
    wield = "wesnoth_magic_wand_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = wesnoth_magic_wanddescripcion,
    atack = "assets_warehouse2:wesnoth_magic_wand_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            obj = minetest.add_entity(addinpos,"assets_warehouse2:wesnoth_magic_wand_atack")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse2:wesnoth_magic_wand_atack")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        end
       
    end,
})

assets_warehouse:register_attack("assets_warehousepart2:wesnoth_magic_wand_atack", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    textures = {'wesnoth_magic_wand_atack.png'},
    damage = 1,
    lifetime = 4,
    --range = 1,

    -- direct hit
    --hit_player = function(self, player)
    --    player:punch(self.object, 1.0, {
    --        full_punch_interval = 1.0,
    --        damage_groups = {fleshy = 2},
    --    }, nil)
    --end,

    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 5},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})

assets_warehouse.cloth("assets_warehousepart2:royal_robe",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'royal_robe.png'},
    wield = "royal_robepreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = royal_robedescripcion,
    cloth_type = "shirt",
    texture_mask = "royar_robemask.png",--"minint_uniform_texture_mask.png"   
    maskforpants = "shampoo_cloth_maskforpants.png", 
})

assets_warehouse.item("assets_warehousepart2:heavy_hammer",{
    wield_mesh ='heavy_hammerMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='heavy_hammerMD'..model_detail..'.obj',
    texture = {'heavy_hammer.png'},
    wield = "heavy_hammerpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = heavy_hammerdescripcion,
    atack = "assets_warehouse2:wesnoth_magic_wand_atack",
    
})

assets_warehouse.item("assets_warehousepart2:training_long_sword",{
    wield_mesh ='training_long_swordMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='training_long_swordMD'..model_detail..'.obj',
    texture = {'training_long_sword.png'},
    wield = "training_long_swordpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = training_long_sworddescripcion,
    atack = "assets_warehouse2:wesnoth_magic_wand_atack",
    
})

assets_warehouse.item("assets_warehousepart2:reinforced_iron_pick",{
    wield_mesh ='reinforced_iron_pickMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='reinforced_iron_pickMD'..model_detail..'.obj',
    texture = {'reinforced_iron_pick.png'},
    wield = "reinforced_iron_pickpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,0.05,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
    description = reinforced_iron_pickdescripcion,
    atack = "assets_warehouse2:wesnoth_magic_wand_atack",
    
})

assets_warehouse.item("assets_warehousepart2:pala_de_hierro_reforzada",{
    wield_mesh ='palaMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='palaMD'..model_detail..'.obj',
    texture = {'pala.png'},
    wield = "palapreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = palareforzadadescripcion,
    atack = "assets_warehouse:peppert_and_carrot_sword1_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        end
       
    end,
})


minetest.register_entity("assets_warehousepart2:destapador_wielded", {--("assets_warehouse:"..name..name_end, {
    basename = "assets_warehousepart2:destapador_wielded",
    physical = false,
    visual = "mesh",
    visual_size = {x=1,y=1,z=1},
    mesh = 'destapadorMD'..model_detail..'.obj',
    textures = {"destapador.png"},
    backface_culling = false,
    maskforpants = "default_maskforpants.png",
    timer = 0,
    pointable = false,
    cloth_type = "wielded",
    texture_mask = "default_mask.png",
    
})
assets_warehouse.cloth("assets_warehousepart2:destapador",{
    mesh ='destapadorclothMD'..model_detail..'.obj',
    texture = {'destapador.png'},
    wield = "destapadorpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = destapadordescripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:simple_jacket_red",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'simple_jacket_red.png'},
    wield = "simple_jacket_redpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = simple_jacketdescripcion,
    cloth_type = "shirt",
    texture_mask = "simple_jacketmask.png",--"minint_uniform_texture_mask.png"
    maskforpants = "default_maskforpants.png",
})



assets_warehouse.cloth("assets_warehousepart2:barcodepapel",{
    mesh ='barcodepapel.obj',
    texture = {'bunnyskin.png'},
    wield = "barcodepapelpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = barcodepapeldescripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})
