local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")


model_detail = settings:get("assets_warehouse_model_quality") or 2
texture_detail = settings:get("assets_warehouse_texture_quality") or 2
idioma = settings:get("assets_warehouse_idioma") or "espanol"

local peppert_and_carrot_sword_of_dark_knightdescripcion = "A sword of a magic knight"
local peppert_and_carrot_pumkpinstardescripcion ='Pumpking in form of star'
local peppert_and_carrot_zafron_house_furnituredescripcion = 'A furniture from the house of zafron'
local peppert_and_carrot_shichimi_little_cauldrondescripcion = "A little cauldron from Shichimi"
local peppert_and_carrot_glamour_clothdescripcion = "Cloth of sucess"
local peppert_and_carrot_mspigeon_hat = "Hat of the famous MSpigeon"
local peppert_and_carrot_glamour_hatdescripcion = "Hat of sucess"
local peppert_and_carrot_genie_hatdescripcion = "Hat of genie of sucess"
local peppert_and_carrot_peppert_jacketdescripcion = "Jacket of Peppert"
local peppert_and_carrot_schimi_kimonodescripcion = "A kimono used for Shichimi"
local peppert_and_carrot_ah_witch_head_decodescripcion = "A deco for the hair of the Ah witches"
local peppert_and_carrot_wasabi_hair_decodescripcion = "A deco for the hair of Wasabi"

if idioma == "espanol" then
    peppert_and_carrot_sword_of_dark_knightdescripcion = "La espada de un caballero magico"
    peppert_and_carrot_pumkpinstardescripcion = "Una calabaza en forma de estrella"
    peppert_and_carrot_zafron_house_furnituredescripcion = "Un mueble de la casa de Zafron"
    peppert_and_carrot_shichimi_little_cauldrondescripcion = "Un pequeño caldero de Shichimi "
    peppert_and_carrot_glamour_clothdescripcion = "Ropa del exito"
    peppert_and_carrot_mspigeon_hatdescripcion = "Sombrero de la famosa Mspigeon"
    peppert_and_carrot_glamour_hatdescripcion = "Sombrero del exito"
    peppert_and_carrot_genie_hatdescripcion = "Sombrero del genio del exito"
    peppert_and_carrot_peppert_jacket = "Chaqueta de Peppert"
    peppert_and_carrot_schimi_kimonodescripcion = "Un kimono usado por Shichimi"
    peppert_and_carrot_ah_witch_head_decodescripcion = "Una decoracion para el pelo de las brujas de Ah"
    peppert_and_carrot_wasabi_hair_decodescripcion = "Una decoracion para el cabello de Wasabi"
end

assets_warehouse.item("assets_warehousepart2:peppert_and_carrot_sword_of_dark_knight",{
    wield_mesh ='peppert_and_carrot_sword_of_dark_knightMD'..model_detail..'.obj',
    wielded_entity = true,
    mesh ='peppert_and_carrot_sword_of_dark_knightMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_sword_of_dark_knight.png'},
    wield = "peppert_and_carrot_sword_of_dark_knight_preview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_sword_of_dark_knightdescripcion,
    atack = "assets_warehouse:peppert_and_carrot_sword1_atack",
    custom_function = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 100
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
        
        if pointed_thing.type == "node" then
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        else 
            obj = minetest.add_entity(addinpos,"assets_warehouse:peppert_and_carrot_sword1_atack2")--"assets_warehouse:testatack")
            obj:set_acceleration(aceleration)
            obj:set_yaw(yaw)--math.pi/2)
        end
       
    end,
})

minetest.register_node('assets_warehousepart2:peppert_and_carrot_pumpkinstar', {
    drawtype = 'mesh',
    mesh = 'peppert_and_carrot_pumkpinstarMD'..model_detail..'.obj',
    tiles ={'peppert_and_carrot_pumkpinstar.png'}, 
    description= peppert_and_carrot_pumkpinstardescripcion,
    stack_max = 1,
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    paramtype2 = "facedir",
    is_ground_content=true,
    climbable=false,
    buildable_to=false,
    damage_per_second=0,
    diggable=true,
    drowning=0,
    floodable=false,
    range=5.0,
    selection_box = {
        type = "fixed",
        fixed = {
            {-0.25,-0.5,-0.25,0.25,-0.25,0.25},		
        },	
    },
    collision_box = {
        type = "fixed",
        fixed = {
            {-0.25,0.25,-0.25,0.25,-0.25,0.25},		
        },	
    },
    on_use = minetest.item_eat(4),
    sunlight_propagates=true,
    use_texture_alpha=false,
    walkable=true,
    pointable=true,
})

assets_warehouse.set_and_get_storage(5,5,2,2,"assets_warehousepart2:peppert_and_carrot_zafron_house_furniture",peppert_and_carrot_zafron_house_furnituredescripcion,'peppert_and_carrot_zafron_house_furniture.obj',{'peppert_and_carrot_zafron_house_furniture.png'},
{type = "fixed",fixed = {{-0.5,-0.5,-0.5,0.5,0.5,0.5},},},{type = "fixed",fixed = {{-0.5,-0.5,-0.5,0.5,0.5,0.5},},})


assets_warehouse.set_and_get_storage(5,5,1,1,"assets_warehousepart2:peppert_and_carrot_shichimi_little_cauldron",peppert_and_carrot_shichimi_little_cauldrondescripcion,'peppert_and_carrot_shichimi_little_cauldronMD'..model_detail..'.obj',{'peppert_and_carrot_shichimi_little_cauldron.png'},
{type = "fixed",fixed = {{-0.15,-0.5,-0.15,0.15,-0.25,0.15},},},{type = "fixed",fixed = {{-0.15,-0.5,-0.15,0.15,-0.25,0.15},},})

assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_glamourt_cloth",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'peppert_and_carrot_glamourt_cloth.png'},
    wield = "peppert_and_carrot_glamourt_clothpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_glamour_clothdescripcion,
    cloth_type = "shirt",
    texture_mask = "peppert_and_carrot_glamourt_clothmask.png",--"minint_uniform_texture_mask.png"
    
})



assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_mspigeon_hat",{
    mesh ='peppert_and_carrot_mspigeon_hatMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_mspigeon_hat.png'},
    wield = "peppert_and_carrot_mspigeon_hatpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_mspigeon_hatdescripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_glamour_hat",{
    mesh ='peppert_and_carrot_glamour_hatMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_glamour_hat.png'},
    wield = "peppert_and_carrot_glamour_hatpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_glamour_hatdescripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_genie_hat",{
    mesh ='peppert_and_carrot_genie_hatMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_genie_hat.png'},
    wield = "peppert_and_carrot_genie_hatpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_genie_hatdescripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})


assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_peppert_jacket",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'peppert_and_carrot_peppert_jacket.png'},
    wield = "peppert_and_carrot_peppert_jacketpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_peppert_jacketdescripcion,
    cloth_type = "shirt",
    texture_mask = "peppert_and_carrot_glamourt_clothmask.png",--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_schimi_kimono",{
    mesh ='base_shirtMD'..model_detail..'.b3d',
    texture = {'peppert_and_carrot_schimi_kimono.png'},
    wield = "peppert_and_carrot_schimi_kimonopreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_schimi_kimonodescripcion,
    cloth_type = "shirt",
    texture_mask = "peppert_and_carrot_schimi_kimonomask.png",--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_ah_witch_head_deco",{
    mesh ='peppert_and_carrot_ah_witch_head_decoMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_ah_witch_head_deco.png'},
    wield = "peppert_and_carrot_ah_witch_head_decopreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_ah_witch_head_decodescripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_wasabi_hair_deco",{
    mesh ='peppert_and_carrot_wasabi_hair_decoMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_wasabi_hair_deco.png'},
    wield = "peppert_and_carrot_wasabi_hair_decopreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_wasabi_hair_decodescripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})

assets_warehouse.cloth("assets_warehousepart2:peppert_and_carrot_ah_witch_head_deco_black",{
    mesh ='peppert_and_carrot_ah_witch_head_decoMD'..model_detail..'.obj',
    texture = {'peppert_and_carrot_ah_witch_head_deco_black.png'},
    wield = "peppert_and_carrot_ah_witch_head_deco_blackpreview.png",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = peppert_and_carrot_ah_witch_head_decodescripcion,
    cloth_type = "hat",
    texture_mask = "default_mask_hat.png"--"minint_uniform_texture_mask.png"
    
})