assets_warehousepart2 = {}

local default_path = minetest.get_modpath("assets_warehousepart2")
local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/assets_warehouse.conf")

model_detail = settings:get("assets_warehouse_model_quality") or 1
texture_detail = settings:get("assets_warehouse_texture_quality") or 1
player_model = settings:get("assets_wareohuse_player_model") or 1


local idioma = settings:get("assets_warehouse_idioma") or "espanol"

local flowers_crown_descripcion = "For a little bear"
local uniform_descripcion = "A green island uniform"
local egyptian_hat_descripcion = "A egyptian hat"
local egyptian_tiara_descripcion = "A egyptian tiara"
local ushanka_rusian_hat_descripcion = "A rusian hat"
local hair_ribborns_descripcion = "From a smart girl"

if idioma == "espanol" then
    flowers_crown_descripcion = "Para un pequeno oso"
    uniform_descripcion = "Uniforme de isla verde"
    egyptian_hat_descripcion = "Un sombrero egypcio"
    egyptian_tiara_descripcion = "Una tiara egypcia"
    ushanka_rusian_hat_descripcion = "Un sombrero ruso"
    hair_ribborns_descripcion = "De una chica inteligente"
end

if minetest.get_modpath("aw_personaje_anthro") then
    ---------------Prueba de Ropa----------------
    function assets_warehousepart2.ropa(tipo,nombre,textura,descripcion,preview)--(sexo,x,y,offsetx,offsety)
        minetest.register_entity('assets_warehousepart2:'..nombre, {
            physical = false,
            pointable = false,
            visual_size =  {x=1,y=1,z=1} ,
            pointable = true,
            textures = {"aw_makehuman_logo.png"}or{"invisible.png"},
            tipoderopa = tipo,
            jugador = nil,
            on_detach = function(self, parent)
                if self then       
                    if self.object then
                        --minetest.debug("none","Se ha quitado la ropa")
                        -------------------------------------------------
                        --Piernas
                        local comprobacionpiernas = self.piernas
                            
                        --if comprobacionpiernas ~= nil then
                        --    local piernas = comprobacionpiernas:get_luaentity()
                        --    piernas:remove()
                        --end  
                        --------------------------------------------------
                        --Dando cuerpo normal  
                        local player = parent
                        local pos = player:get_pos()
                        
                        minetest.after(1,function()
                            self.object:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                        end
                        )
                        
                    end
                end
            end,
            --local staticdata = get_staticdata(self),
            on_activate = function(self,staticdata, dtime_s)
                --minetest.debug("none","la ropa esta puesta")
                if self then       
                    if self.object then
                        minetest.after(10,function()
                            if self.jugador == nil then
                                self.object:remove(self)
                            end
                        end
                        )
                    end
                end
            end,
            on_deactivate = function(self, removal)
                 if self then       
                    if self.object then
                        local parent = self.jugador--self.object:get_attach()
                        
                        if minetest.is_player(parent) then
                            if removal == true then
                                local meta = parent:get_meta()
                                meta:set_string("aw_personaje_ropa_"..tipo,"invisible.png")
                                meta:set_string("aw_personaje_objeto_equipado_"..tipo,"nada")
                                local x = meta:get_int("aw_personaje_fisico_masa") or 1
                                local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
                                local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
                                meta:set_string("aw_personaje_objeto_equipado_"..tipo,"ninguno")
                                
                                aw_personaje_anthro.cambiarcuerpojugador(parent,sexo,x,y)
                            end
                        end
                    end
                end
            end
        })
         
        -------------------------------------------------------
        minetest.register_tool('assets_warehousepart2:'..nombre,{--..sexo..'piernasmasa'..x..'musculos'..y.."durmiendo", {
            description = descripcion,
            groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
            range=5.0,
            inventory_image = preview,
            
            on_use = function(itemstack, user, pointed_thing)
                local player = user
                local pos = player:get_pos()
                local dir = player:get_look_dir()
                local yaw = player:get_look_horizontal()
                local power = 50
                local controls = player:get_player_control()
                local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
                local addinpos = {x=pos.x,y=pos.y,z=pos.z}
                
                --Dando cuerpo normal  
                local meta = player:get_meta()
                local x = meta:get_int("aw_personaje_fisico_masa") or 1
                local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
                local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
                
                meta:set_string("aw_personaje_ropa_"..tipo,textura)
                
                 
                if meta:get("aw_personaje_objeto_equipado_"..tipo) == "ninguno" then
                    aw_personaje_anthro.cambiarcuerpojugador(player,sexo,x,y)
                    
                    local ropa = minetest.add_entity(pos, 'assets_warehousepart2:'..nombre)
                    ropa:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                    
                    ropa:get_luaentity().jugador = player 
                    meta:set_string("aw_personaje_objeto_equipado_"..tipo,'assets_warehousepart2:'..nombre)
                end
            end,  
        })      
        minetest.register_on_joinplayer(function(player)
            local name = player:get_player_name()
            local pos = player:get_pos()
            
            
            ---------------------------------------
            --Dandole propiedades al jugador
            --------------------------------------
            local meta = player:get_meta()
            
            --------------
            if meta:get("aw_personaje_objeto_equipado_"..tipo) == nil then
                meta:set_string("aw_personaje_objeto_equipado_"..tipo,"ninguno")
            end      
            if meta:get("aw_personaje_objeto_equipado_"..tipo) == "ninguno" then
                --minetest.debug("none","No hay objeto equipado del tipo"..tipo)
            else
                --minetest.debug("none","Hay objeto equipado del tipo"..tipo)
                local x = meta:get_int("aw_personaje_fisico_masa") or 1
                local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
                local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
                
                if minetest.registered_entities[meta:get("aw_personaje_objeto_equipado_"..tipo)] then
                    aw_personaje_anthro.cambiarcuerpojugador(player,sexo,x,y)
                    
                    local ropa = minetest.add_entity(pos,meta:get("aw_personaje_objeto_equipado_"..tipo))
                    ropa:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                    
                    ropa:get_luaentity().jugador = player 
                end
            end
        end) 
    end
    ---------------Prueba de sombrero----------------
    function assets_warehousepart2.sombrero(nombre,textura,mesh,descripcion,preview)--(sexo,x,y,offsetx,offsety)
        --Creando la entidad que representara el objeto
        minetest.register_entity("assets_warehousepart2:"..nombre.."entidad", {--("assets_warehouse:"..name.."drop_entity", {
            physical = false,
            pointable = false,
            visual = "mesh",
            visual_size = {x = 1.2, y = 1, z = 1.2},
            mesh = mesh,
            textures = textura,
            tipo = "sombrero",
            on_activate = function(self,staticdata, dtime_s)
                --minetest.debug("none","la ropa esta puesta")
                if self then       
                    if self.object then
                        minetest.after(1.4,function()
                            local parent = self.object:get_attach()
                            if parent == nil then
                                --minetest.debug("none","Prueba de sombrero parent")
                                self.object:remove(self)
                            end
                        end
                        )
                    end
                end
            end,
        })
        minetest.register_entity('assets_warehousepart2:'..nombre, {
            physical = false,
            pointable = false,
            visual_size =  {x=1,y=1,z=1} ,
            textures = {"aw_makehuman_logo.png"}or{"invisible.png"},
            jugador = nil,
            tipo = "sombrero",
            on_detach = function(self, parent)
                if self then       
                    if self.object then
                        --minetest.debug("none","Se ha quitado la ropa")
                        -------------------------------------------------
                        --Piernas
                        local comprobacionpiernas = self.piernas
                            
                        --if comprobacionpiernas ~= nil then
                        --    local piernas = comprobacionpiernas:get_luaentity()
                        --    piernas:remove()
                        --end  
                        --------------------------------------------------
                        --Dando cuerpo normal  
                        local player = parent
                        local pos = player:get_pos()
                        
                        minetest.after(1,function()
                            self.object:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                            for _,children in pairs(parent:get_children()) do
                                if children:get_luaentity().cabeza then
                                    --minetest.debug("none","Sombrero")
                                    local pos = parent:get_pos()
                                    local sombrero = minetest.add_entity(pos, 'assets_warehousepart2:'..nombre.."entidad")
                                    sombrero:set_attach(children:get_luaentity().cabeza,"head", {x=0, y=-0.0, z=0}, {x=0, y=0, z=0},true)
                                end
                                --minetest.debug("Prueba de sombrero revisando lista")
                            end
                        end
                        )
                    end
                end
            end,
            --local staticdata = get_staticdata(self),
            on_activate = function(self,staticdata, dtime_s)
                --minetest.debug("none","la ropa esta puesta")
                if self then       
                    if self.object then
                        minetest.after(1.4,function()
                            local parent = self.jugador
                            if parent == nil then
                                --minetest.debug("none","Prueba de sombrero parent")
                                self.object:remove(self)
                            else
                                if minetest.is_player(parent) then
                                    --minetest.debug("none","Prueba de sombrero el objeto esta emparentado") 
                                    for _,children in pairs(parent:get_children()) do
                                        if children:get_luaentity().cabeza then
                                            --minetest.debug("none","Sombrero")
                                            local pos = parent:get_pos()
                                            local sombrero = minetest.add_entity(pos, 'assets_warehousepart2:'..nombre.."entidad")
                                            sombrero:set_attach(children:get_luaentity().cabeza,"head", {x=0, y=-0.0, z=0}, {x=0, y=0, z=0},true)
                                        end
                                        --minetest.debug("Prueba de sombrero revisando lista")
                                    end
                                end
                            end
                        end
                        )
                    end
                end
            end,
            on_deactivate = function(self, removal)
                 if self then       
                    if self.object then
                        local parent = self.jugador
                        if minetest.is_player(parent) then
                            if removal == true then
                                local meta = parent:get_meta()
                                meta:set_string("aw_personaje_objeto_equipado_sombrero","ninguno")
                                local x = meta:get_int("aw_personaje_fisico_masa") or 1
                                local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
                                local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
                                meta:set_string("aw_personaje_objeto_equipado_".."sombrero","ninguno")
                                
                                for _,children in pairs(parent:get_children()) do
                                    if children:get_luaentity().cabeza then
                                        for _,sombrero in pairs(children:get_luaentity().cabeza:get_children()) do
                                            if sombrero.name == 'assets_warehousepart2:'..nombre.."entidad" then
                                                sombrero:remove(sombrero)
                                            end
                                        end
                                    end
                                end
                                
                                
                            end
                        end
                    end
                end
            end
        })
         
        -------------------------------------------------------
        minetest.register_tool('assets_warehousepart2:'..nombre,{--..sexo..'piernasmasa'..x..'musculos'..y.."durmiendo", {
            description =descripcion,
            groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
            range=5.0,
            inventory_image = preview,
            
            on_use = function(itemstack, user, pointed_thing)
                local player = user
                local pos = player:get_pos()
                local dir = player:get_look_dir()
                local yaw = player:get_look_horizontal()
                local power = 50
                local controls = player:get_player_control()
                local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
                local addinpos = {x=pos.x,y=pos.y,z=pos.z}
                
                --Dando cuerpo normal  
                local meta = player:get_meta()
                local x = meta:get_int("aw_personaje_fisico_masa") or 1
                local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
                local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
                 
                if meta:get("aw_personaje_objeto_equipado_".."sombrero") == "ninguno" then
                    
                    local sombrero = minetest.add_entity(pos, 'assets_warehousepart2:'..nombre)
                    sombrero:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                    
                    sombrero:get_luaentity().jugador = player 
                    meta:set_string("aw_personaje_objeto_equipado_".."sombrero",'assets_warehousepart2:'..nombre)
                        
                    
                end
            end,  
        })      
        minetest.register_on_joinplayer(function(player)
            local name = player:get_player_name()
            local pos = player:get_pos()
            
            
            ---------------------------------------
            --Dandole propiedades al jugador
            --------------------------------------
            local meta = player:get_meta()
            
            --------------
            if meta:get("aw_personaje_objeto_equipado_".."sombrero") == nil then
                meta:set_string("aw_personaje_objeto_equipado_".."sombrero","ninguno")
            end      
            if meta:get("aw_personaje_objeto_equipado_".."sombrero") == "ninguno" then
                --minetest.debug("none","No hay objeto equipado del tipo"..tipo)
            else
                --minetest.debug("none","Hay objeto equipado del tipo"..tipo)
                local x = meta:get_int("aw_personaje_fisico_masa") or 1
                local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
                local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
                
                if minetest.registered_entities[meta:get("aw_personaje_objeto_equipado_".."sombrero")] then
                    
                    local sombrero = minetest.add_entity(pos,meta:get("aw_personaje_objeto_equipado_".."sombrero"))
                    sombrero:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                    
                    sombrero:get_luaentity().jugador = player 
                end
            end
        end) 
    end
    --assets_warehousepart2.ropa(tipo,nombre,textura,objeto,parte,ropamesh,descripcion)
    --assets_warehousepart2.ropa("hat","elpidio_valdez_soldier_hat","elpidio_valdez_soldier_hat.png",true,"cabeza",'soldier_hatMD'..model_detail..'.obj',sombero_soldado_descripcion,"elpidio_valdez_soldier_hat_preview.png")
    assets_warehousepart2.ropa("camisa","minint_uniform","minint_uniform.png")--uniform_descripcion,"minint_uniform_preview.png")--(sexo,x,y,offsetx,offsety)
    assets_warehousepart2.sombrero("flowers_crown",{'flowers_crown.png'},'flowers_crownMD'..model_detail..'.obj',flowers_crown_descripcion,"flowers_crownpreview.png")
    assets_warehousepart2.sombrero("egyptian_hat",{'egyptian_hat.png'},'egyptian_hat.obj',egyptian_hat_descripcion,"egyptian_hat_preview.png")
    assets_warehousepart2.sombrero("egyptian_tiara",{'egyptian_hat.png'},'egyptian_tiara.obj',egyptian_tiara_descripcion,"egyptian_diadema_preview.png")
    assets_warehousepart2.sombrero("ushanka_rusian_hat",{'ushanka_rusian_hat.png'},'ushanka_rusian_hatMD'..model_detail..'.obj',ushanka_rusian_hat_descripcion,"ushanka_preview.png")
    assets_warehousepart2.sombrero("hair_ribborns",{'hair_ribborns.png'},'hair_ribbornsMD'..model_detail..'.obj',hair_ribborns_descripcion,"hair_ribborns_preview.png")
    minetest.register_tool('assets_warehousepart2:quitar_sombrero',{--..sexo..'piernasmasa'..x..'musculos'..y.."durmiendo", {
        description ="quitar sombrero",
        groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
        range=5.0,
        inventory_image = "aw_makehuman_logo.png",
        
        on_use = function(itemstack, user, pointed_thing)
            local player = user
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local yaw = player:get_look_horizontal()
            local power = 50
            local controls = player:get_player_control()
            local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
            local addinpos = {x=pos.x,y=pos.y,z=pos.z}
            local meta = player:get_meta()
            
            --meta:set_string("aw_personaje_objeto_equipado_sombrero","ninguno")
            for _,children in pairs(player:get_children()) do
                if children:get_luaentity().cabeza then
                    minetest.debug("none","cabeza")
                    for _,sombrero in pairs(children:get_luaentity().cabeza:get_children()) do
                        minetest.debug("none",sombrero:get_luaentity().name)
                        if sombrero:get_luaentity().tipo == "sombrero"then
                            minetest.debug("none",sombrero.tipo)
                            sombrero:remove(sombrero)
                        end
                    end
                end
                if children:get_luaentity().name ==meta:get("aw_personaje_objeto_equipado_sombrero") or children:get_luaentity().tipo == "sombrero" then
                    children:remove(children)
                end
            end
            meta:set_string("aw_personaje_objeto_equipado_sombrero","ninguno")
        end,  
    }) 
end
dofile(default_path.."/care_bears/care_bears_forestoffelings.lua")


local node_ok = function(pos, fallback)

    fallback = fallback or mobs.fallback_node

    local node = minetest.get_node_or_nil(pos)

    if node and minetest.registered_nodes[node.name] then
        return node
    end

    return minetest.registered_nodes[fallback]
end


function assets_warehousepart2:register_attack(name, def)

    if not name or not def then return end -- errorcheck

    minetest.register_entity(name, {

        physical = def.physical or false,
        collide_with_objects = def.collide_with_objects or false,
        static_save = false,

        visual = def.visual,
        visual_size = def.visual_size,
        textures =  def.textures or {'default_mask.png'},
        velocity = def.velocity or 100,
        hit_player = def.hit_player,
        hit_node = def.hit_node,
        hit_mob = def.hit_mob,
        hit_object = def.hit_object,
        --drop = def.drop or false, -- drops arrow as registered item when true
        collisionbox = def.collisionbox or {-.1, -.1, -.1, .1, .1, .1},
        timer = 0,
        
        range = def.range or 1,
        
        lifetime = def.lifetime or 0.2,
        
        owner_id = def.owner_id,
        
        on_activate = def.on_activate,

        on_punch = def.on_punch or function(
                self, hitter, tflp, tool_capabilities, dir)
        end,

        on_step = def.on_step or function(self, dtime)

            self.timer = self.timer + dtime

            local pos = self.object:get_pos()
            --local lifetime2 = (self.range/5)*self.lifetime 
        

            if self.timer > self.lifetime then
                self.object:remove() ; -- print("removed arrow")
                return
            end

            -- does arrow have a tail (fireball)
            if def.tail and def.tail == 1 and def.tail_texture then

                minetest.add_particle({
                    pos = pos,
                    velocity = {x = 0, y = 0, z = 0},
                    acceleration = {x = 0, y = 0, z = 0},
                    expirationtime = def.expire or 0.25,
                    collisiondetection = false,
                    texture = def.tail_texture,
                    size = def.tail_size or 5,
                    glow = def.glow or 0
                })
            end

            if self.hit_node then
                local node = node_ok(pos).name
                if minetest.registered_nodes[node].walkable then
                    self:hit_node(pos, node)
                    if self.drop == true then
                        pos.y = pos.y + 1
                        self.lastpos = (self.lastpos or pos)
                        minetest.add_item(self.lastpos,
                                self.object:get_luaentity().name)
                    end
                    self.object:remove() ; -- print("hit node")
                    return
                end
            end

            if self.hit_player or self.hit_mob or self.hit_object then

                for _,player in pairs(
                        minetest.get_objects_inside_radius(pos, 1.0)) do

                    if self.hit_player and player:is_player() then

                        self:hit_player(player)

                        self.object:remove() ; -- print("hit player")

                        return
                    end

                    local entity = player:get_luaentity()

                    if entity
                    and self.hit_mob
                    and entity._cmi_is_mob == true
                    and tostring(player) ~= self.owner_id
                    and entity.name ~= self.object:get_luaentity().name then

                        self:hit_mob(player)

                        self.object:remove() ; --print("hit mob")

                        return
                    end

                    if entity
                    and self.hit_object
                    and (not entity._cmi_is_mob)
                    and tostring(player) ~= self.owner_id
                    and entity.name ~= self.object:get_luaentity().name then

                        self:hit_object(player)

                        self.object:remove() ; -- print("hit object")

                        return
                    end
                end
            end

            self.lastpos = pos
        end
    })
end


--Funcion que crea la clase item
function assets_warehousepart2.item(name,def)
    --Creando la entidad que representara el objeto
    minetest.register_entity(name.."drop_entity", {--("assets_warehousepart2:"..name.."drop_entity", {
        physical = true,
        visual = "mesh",
        visual_size = {x = 20, y = 10, z = 10},
        mesh = def.mesh,
        textures = def.texture,
        on_step = function(self, dtime, moveresult)--Hace que la entidad se mueva hacia abajo cuando do este tocando nada debajo
            if moveresult  then
                if moveresult.touching_ground == true then
                    self.object:set_velocity({x=0.0, y=0.0, z=0.0})
                else
                    self.object:set_acceleration({x = 0, y = -1, z = 0})
                end
            end
        end,
        --No usar el tipo fixet para selectionbox o collisionbox,Dont use type fixed for collision or selection box
        selectionbox = def.selectionbox,
        collisionbox = def.collisionbox,
        timer = 0,
        --Hace que al tocar la entidad se obtenga el objeto pero solo si se coge con la mano
        on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir)
            local itemstack = puncher:get_wielded_item(itemstack)
            if itemstack.is_empty(itemstack) then 
                puncher:set_wielded_item(name)--("assets_warehousepart2:"..name)
            else 
                minetest.log("none", "You need to pick the object whit the hand")
                return
            end
        end,
        groups = def.groups or {crumbly = 4,soil = 4,choppy = 4, oddly_breakable_by_hand = 4, flammable = 4},
        
        use_texture_alpha = true
        
    })
    use_texture_alpha = true
    
    local wielded_entity = def.wielded_entity or nil
    
    --if wielded_entity == true then
    --    assets_warehousepart2.cloth(name,{
    --    mesh =def.wield_mesh,
    --    texture = def.texture,
    --    wield = def.wield,
    --    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    --    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    --    description = def.description,
    --    cloth_type = "wielded",
    --    })
    --end
    
    --Creando la representacion del objeto que sera mostrada en la mano/s del jugador
    minetest.register_tool(name, {--('assets_warehousepart2:'..name, {
        drawtype = 'mesh',
        mesh = def.mesh,
        tiles = def.texture, 
        description= def.description,
        stack_max = 1,
        wield_image = def.wield,
        inventory_image = def.wield,
        groups = def.groups or {crumbly = 4,soil = 4,choppy = 4, oddly_breakable_by_hand = 4, flammable = 4},
        range= def.range or 5.0,
        
        --Hace que el objeto sea lanzado 
        on_drop = function(itemstack, user, pointed_thing)
            local player = user
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local yaw = player:get_look_horizontal()
            local power = 50
            local controls = player:get_player_control()
            local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
            local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
            itemstack.clear(itemstack)
            if controls.sneak then
                aceleration = {x=dir.x*power/2, y=dir.y*power/2, z=dir.z*power/2}
                        
            end
            if pointed_thing.type == "node" then
                
                obj = minetest.add_entity(addinpos,name.."drop_entity")--(addinpos,"assets_warehousepart2:"..name.."drop_entity")
                obj:set_acceleration(aceleration)
                obj:set_yaw(yaw)
            else 
                obj = minetest.add_entity(addinpos,name.."drop_entity")--(addinpos,"assets_warehousepart2:"..name.."drop_entity")
                obj:set_acceleration(aceleration)
                obj:set_yaw(yaw)
            end
            return itemstack
        end,
       
        on_place = def.custom_function or function(itemstack, placer, pointed_thing)
            minetest.log("none", "No second use")
        end,
        on_secondary_use = def.custom_function or function(itemstack, user, pointed_thing)
            minetest.log("none", "No second use")
        end,
        sunlight_propagates=true,
        use_texture_alpha=false,
        walkable=true,
        pointable=true,
        backface_culling = true,
    })
end


--Ataque que se realizara por defecto al usar el objeto si es que no se le ha asignado uno
assets_warehousepart2:register_attack("assets_warehousepart2:testatack", {
    visual = "sprite",
    visual_size = {x = 0.1, y = 0.1},
    damage = 1,
    
    -- direct hit
    hit_player = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 2},
        }, nil)
    end,

    hit_mob = function(self, player)
        player:punch(self.object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = {fleshy = 2},
        }, nil)
    end,

    hit_node = function(self, pos, node)
    end
})
dofile(default_path.."/normal_clothes.lua")
dofile(default_path.."/peppert_and_carrot_stuff.lua")
dofile(default_path.."/peppert_and_carrot_clothes.lua")
dofile(default_path.."/animados.lua")

--dofile(default_path.."/modifier.lua")

--dofile(default_path.."/player.lua")