aw_personaje_anthro={}
aw_personaje_anthro_hud = {}

local world_path = minetest.get_worldpath()
local settings = Settings(world_path.."/aw_personaje_anthro.conf")

local detalle_modelos = settings:get("aw_personaje_anthro_model_quality") or 1
local calidad_texturas = settings:get("aw_personaje_anthro_texture_quality") or 1

if minetest.get_modpath("aw_personaje_anthrohigh") then
    minetest.log("none","Se encontro el mod con los modelos de alto detalle")
    minetest.log("none",detalle_modelos)
else
    minetest.log("none","No se encontro el mod con los modelos de alto detalle"..detalle_modelos)
    if detalle_modelos == "3" then
        detalle_modelos = 2
    end
    if calidad_texturas == "3" then
        calidad_texturas = 2
    end
end

detalle_modelos = tostring(detalle_modelos)
calidad_texturas = tostring(calidad_texturas)

--assets_warehouse.entity_anim=function(self,number,x,y,time,framerate)
aw_personaje_anthro.entity_anim=function(self,number,x,y,time,framerate)
    --local animation = self.object:get_animation()--`: returns `range`, `frame_speed`, --`frame_blend` and--`frame_loop`.
    --el dato number se encarga de hacerle saber a la funcion si la animacion ya se esta realizando
    if self.animation == number then -- or self.animation == 0 then --or self.animation < number then
        return
    end
    self.animation = number
    local framerate = framerate or 30
    --minetest.log("none","Framerate"..framerate)
    self.object:set_animation({x = x,y = y},framerate,0,true )
    local time = time or 1
       

end
--Funcion que crea la clase ropa,no es demasiado diferente de la clase item

function aw_personaje_anthro.cloth(name,def)
    local visual_size = {x = 1, y = 1, z = 1}
    --se encarga de las animaciones
    
    local name_end = "_cloth"
    if def.cloth_type == "wielded" then
        name_end ="_wielded"
        on_step = nil
        visual_size = {x = 1, y = 1, z = 1}
    end
    --body significa que es una parte del cuerpo del jugador
    if def.cloth_type == "body" then
        visual_size = {x = 10, y = 10, z = 10}
    end
    
    
    minetest.register_entity(name..name_end, {--("assets_warehouse:"..name..name_end, {
        basename = name,
        physical = false,
        visual = "mesh",
        visual_size =  def.visual_size or visual_size ,
        mesh = def.mesh,
        textures = def.texture,
        timer = 0,
        pointable = false,
        cloth_type = def.cloth_type,
        texture_mask = def.texture_mask or "default_mask.png",
        on_step = def.on_step,
        selectionbox = def.selectionbox, --{-0.1,-0.5,-0.1,0.1,0.05,0.1},
        collisionbox = def.collisionbox, -- {-0.1,-0.5,-0.1,0.1,0.05,0.1},
        
        
    })
    --minetest.log("none","useoldmodelcloth"..useoldmodel)
    if def.cloth_type ~= "body" and def.cloth_type ~= "wielded" and useoldmodel == "false" then
        minetest.register_tool(name,{--('assets_warehouse:'..name,{--..'_item', { 
            basename = name,
            drawtype = 'mesh',
            mesh = def.mesh,
            tiles = def.texture, 
            inventory_image  = def.texture,
            description= def.description,
            stack_max = 1,
            --wield_image = def.wield,
            inventory_image = def.wield,
            groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
            range=5.0,
            on_drop = function(itemstack, user, pointed_thing)
                local player = user
                local pos = player:get_pos()
                local dir = player:get_look_dir()
                local yaw = player:get_look_horizontal()
                local power = 50
                local controls = player:get_player_control()
                local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
                local addinpos = {x=pos.x,y=pos.y+1.5,z=pos.z}
                itemstack.clear(itemstack)
                if controls.sneak then
                    aceleration = {x=dir.x*power/2, y=dir.y*power/2, z=dir.z*power/2}

                end
                if pointed_thing.type == "node" then
                    minetest.add_item(addinpos,name.."_item")--(addinpos,"assets_warehouse:"..name.."_item")
                else 
                    minetest.add_item(addinpos,name.."_item")--(addinpos,"assets_warehouse:"..name.."_item")
                end
                return itemstack
            end,
            
            
            on_place = def.custom_function or function(itemstack, placer, pointed_thing)
                assets_warehouse_put_cloth({
                    player = placer,
                    name = name,
                    itemstack = itemstack,
                    cloth_type = def.cloth_type,
                    texture_mask = def.texture_mask
                    }
                )
                if def.cloth_type ~= "wielded" then
                    return itemstack
                end
                
            end,
            on_secondary_use = def.custom_function or function(itemstack, user, pointed_thing)
                assets_warehouse_put_cloth({
                    player = user,
                    name = name,
                    itemstack = itemstack,
                    cloth_type = def.cloth_type,
                    texture_mask = def.texture_mask
                    }
                )
                if def.cloth_type ~= "wielded" then
                    return itemstack
                end
               
            end,
            sunlight_propagates=true,
            use_texture_alpha=false,
            walkable=true,
            pointable=true,
            backface_culling = true,
        })
    end
end

function asset_warehouse_wielded_item_function(def)
    local use = def.use or 1
    local player = def.player
    for _, childrens in pairs(player:get_children()) do
        if  childrens:get_luaentity().cloth_type  then
            if  childrens:get_luaentity().cloth_type == cloth_type  then
                --minetest.log("none","Se ha encontrado ropa del mismo tipo,cancelando el poner ropa "..childrens:get_luaentity().name)
                return
            end
            if childrens:get_luaentity().cloth_type == "wielded" then
                wielding = true
            end
        end
    end

end

--Funcion que le equipa o quita la ropa al jugador

function aw_character_put_cloth(def)
    --Obteniendo datos de el archivo players_cloths
    local world_path = minetest.get_worldpath()
    local ropas = Settings(world_path.."/players_cloths.conf")
    
    local player_hat = ropas:get("assets_warehouse_player_hat") or ""
    local player_shirt = ropas:get("assets_warehouse_player_shirt") or ""
    local player_pants = ropas:get("assets_warehouse_player_plants") or ""
    local player_gloves = ropas:get("assets_warehouse_player_gloves") or ""
    --Obteniendo datos del jugador
    local player = def.player
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local itemstack = def.itemstack
    local cloth_type = def.cloth_type
    local texture_mask = def.texture_mask or "default_mask.png"
    --Estableciendo las texturas de la ropa
    local default_texture_hat = "default_mask_hat.png"
    local default_texture_shirt = "default_mask_shirt.png"
    local default_texture_pants = "default_mask_pants.png"
    local default_texture_gloves = "default_mask_gloves.png"
    --Estableciendo las mascaras de texturas 
    local default_mask_hat = "default_mask_hat.png"
    local default_mask_shirt = "default_mask_shirt.png"
    local default_mask_pants = "default_mask_pants.png"
    local default_mask_gloves = "default_mask_gloves.png"
    local maskforpants = def.maskforpants or "default_maskforpants.png"
    
    local body = nil
    local torso = nil
    local cabeza = nil
    --Obteniendo el cuerpo del jugador
    for _, childrens in pairs(player:get_children()) do
        if  childrens:get_luaentity().cloth_type  then
            if childrens:get_luaentity().cloth_type == "body" then
                body = childrens
            end
        end
    end
    --Obteniendo el torso del jugador
    if body ~= nil  then
        for _, childrens in pairs(body:get_children()) do
            if  childrens:get_luaentity().cloth_type  then
                if childrens:get_luaentity().cloth_type == "torso" then
                    torso = childrens
                end
            end
        end
    end
    --Obteniendo la cabeza del jugador
    if torso ~= nil then
        for _, childrens in pairs(torso:get_children()) do
            if  childrens:get_luaentity().cloth_type  then
                if childrens:get_luaentity().cloth_type == "cabeza" then
                    cabeza = childrens
                end
            end
        end
    end
    
    local cloth_action = def.cloth_action or "equip"
    --Obteniendo mascaras de texturas de la ropa que el jugador lleva puesta 
    --y comprobando si el jugador esta intentando ponerse una ropa del mismo tipo que ya lleva puesta
    for _, childrens in pairs(player:get_children()) do
        if  childrens:get_luaentity().cloth_type  then
            --minetest.log("none","Se ha encontrado ropa "..childrens:get_luaentity().name)
            if  childrens:get_luaentity().cloth_type == cloth_type and cloth_action == "equip"  then
                --minetest.log("none","Se ha encontrado ropa del mismo tipo,cancelando el poner ropa "..childrens:get_luaentity().name)
                return
            end
            
        end
    end
    --for _, childrens in pairs(cabeza:get_children()) do
    --    if  childrens:get_luaentity().cloth_type  then
    --        --minetest.log("none","Se ha encontrado ropa "..childrens:get_luaentity().name)
    --        if  childrens:get_luaentity().cloth_type == cloth_type and cloth_action == "equip"  then
    --            --minetest.log("none","Se ha encontrado ropa del mismo tipo,cancelando el poner ropa "..childrens:get_luaentity().name)
    --            return
    --        end
    --        
    --    end
    --end
    -----------------------
    
    local bodypart = ""
    local bodysection = player
    if cloth_action == "equip" then
        --Obteniendo que tipo de ropa el jugador se ha puesto
        --minetest.log("none",cloth_type)
        if cloth_type == "hat" then
            player_hat = def.name
            default_mask_hat = texture_mask
            bodypart = "head"
            bodysection = cabeza
        elseif cloth_type == "shirt" then
            player_shirt = def.name
            default_mask_shirt = def.texture_mask
        elseif cloth_type == "pants" then
            player_pants = def.name
            default_mask_pants = texture_mask
        elseif cloth_type == "gloves" then
            player_gloves = def.name
            default_mask_gloves = texture_mask
        end
        --Creando ropa y pegandola al jugador
        equip = minetest.add_entity(pos,def.name.."_cloth")--(pos,"assets_warehouse:"..def.name.."_cloth")
        equip:set_attach(bodysection,bodypart,{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
        
        
        --Removiendo el objeto del inventario
        itemstack.clear(itemstack)
    end
    
    if cloth_action == "unequip" then
        --minetest.log("none","unequip")
        for _, childrens in pairs(player:get_children()) do
         --minetest.log("none",childrens:get_luaentity().name)
            --minetest.log("none",childrens:get_entity_name())
            
            if  childrens:get_luaentity().cloth_type  then
                if  childrens:get_luaentity().cloth_type == cloth_type  then
                    local name = childrens:get_luaentity().name
                    local basename = childrens:get_luaentity().basename--Habia un problema que era causado por poner una coma al final cuando no debia
                    --minetest.log("none",childrens:get_luaentity().name)
                    --obj = minetest.add_entity(addinpos,name)
                    --minetest.log("none","asset_warehouse:"..basename.."_item")
                    minetest.add_item(addinpos,basename.."_item")--(addinpos,"assets_warehouse:"..basename.."_item")
                    --assets_warehouse:"..name..'_item
                    childrens:remove(childrens:get_luaentity())
                    if cloth_type == "hat" then
                        player_hat = ""
                    end    
                    if cloth_type == "shirt" then
                        player_shirt = ""
                        for _, childrens in pairs(body:get_children()) do
                            --minetest.log("none",childrens:get_luaentity().name)    
                            if  childrens:get_luaentity().cloth_type  then
                                if  childrens:get_luaentity().cloth_type == "pants"  then
                                    local name = childrens:get_luaentity().name
                                    local basename = childrens:get_luaentity().basename
                                    local pantstexture = childrens:get_luaentity().textures[1]
                                    local maskforpants = equip:get_luaentity().maskforpants
                                    childrens:set_properties({
                                        textures = {pantstexture},        
                                    })
                                end
                            
                            end
                        end
                    end
                    if cloth_type == "pants" then
                        player_pants = ""
                    end
                    if cloth_type == "gloves" then
                        player_gloves = ""
                    end
                end
                
            end
        end
    end
    if cloth_action == "recover" then
        if player_hat ~= "" then
            equip = minetest.add_entity(pos,player_hat.."_cloth")--(pos,"assets_warehouse:"..player_hat.."_cloth")
            equip:set_attach(cabeza,"head",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
        end    
        if player_shirt ~= "" then
            equip = minetest.add_entity(pos,player_shirt.."_cloth")
            equip:set_attach(player,"",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
        end
        if player_pants ~= "" then
            equip = minetest.add_entity(pos,player_pants.."_cloth")
            equip:set_attach(player,"",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
            for _, childrens in pairs(body:get_children()) do
                --minetest.log("none",childrens:get_luaentity().name)
                if  childrens:get_luaentity().cloth_type  then
                    if  childrens:get_luaentity().cloth_type == "shirt"  then
                        local name = childrens:get_luaentity().name
                        local basename = childrens:get_luaentity().basename
                        local pantstexture = equip:get_luaentity().textures[1]
                        local masktextureforpants = childrens:get_luaentity().maskforpants
                        equip:set_properties({
                            textures = {pantstexture.."^"..masktextureforpants.."^[makealpha:0.0, 0.0, 0.0]"},        
                        })
                    end
                end
            end
        end
        if player_gloves ~= "" then
            equip = minetest.add_entity(pos,player_gloves.."_cloth")
            equip:set_attach(player,"",{x=0, y=0, z=0}, {x=0, y=0, z=0},true)
        end
    end
    
    --Guardando datos sobre que ropa lleva el jugador 
    local content = "assets_warehouse_player_hat = "..player_hat .."\n".."assets_warehouse_player_shirt = "..player_shirt.."\n".."assets_warehouse_player_plants = "..player_pants.."\n".."assets_warehouse_player_gloves = "..player_gloves
    
    minetest.safe_file_write(world_path.."/players_cloths.conf", content)
    
    --Aplicando mascara de textura en caso de haberla
    for _, childrens in pairs(player:get_children()) do
        if  childrens:get_luaentity().cloth_type  then
            --minetest.log("none","Se ha encontrado ropa "..childrens:get_luaentity().name)
           
            if childrens:get_luaentity().cloth_type == "hat" then
                default_mask_hat = childrens:get_luaentity().texture_mask
                default_texture_hat = childrens:get_luaentity().texturecloth
            elseif childrens:get_luaentity().cloth_type == "shirt" then
                default_mask_shirt = childrens:get_luaentity().texture_mask
                default_texture_shirt = childrens:get_luaentity().texturecloth
            elseif childrens:get_luaentity().cloth_type == "pants" then
                default_mask_pants = childrens:get_luaentity().texture_mask
                default_texture_pants = childrens:get_luaentity().texturecloth
            elseif childrens:get_luaentity().cloth_type == "gloves" then
                default_mask_gloves = childrens:get_luaentity().texture_mask
                default_texture_gloves = childrens:get_luaentity().texturecloth
            end
        end
    end
    
    body:set_properties({
            textures = {"("..playerskin.."^"..default_texture_hat.."^"..default_texture_shirt.."^"..default_texture_pants.."^"..default_texture_gloves.."^"..default_mask_hat.."^"..default_mask_shirt.."^"..default_mask_pants.."^"..default_mask_gloves..")^[makealpha:0.0, 0.0, 0.0]"},        
        })
    torso:set_properties({
            textures = {"("..playerskin.."^"..default_texture_hat.."^"..default_texture_shirt.."^"..default_texture_pants.."^"..default_texture_gloves.."^"..default_mask_hat.."^"..default_mask_shirt.."^"..default_mask_pants.."^"..default_mask_gloves..")^[makealpha:0.0, 0.0, 0.0]"},        
        })
        
    
    
    return itemstack
end

aw_personaje_anthro.cloth("aw_personaje_anthro:player_eyes",{
    mesh ='eyes.obj',
    texture = {'eyes.png'},
    wield = "",
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "eyes",
    cloth_type = "eyes",
    --texture_mask = "minint_uniform_mask.png"--"minint_uniform_texture_mask.png"
    
})



minetest.register_on_joinplayer(function(player)
    local name = player:get_player_name()
    local pos = player:get_pos()
    
    
    ---------------------------------------
    --Dandole propiedades al jugador
    --------------------------------------
    local meta = player:get_meta()
    
    if meta:get("aw_personaje_fisico_masa") == nil then
        meta:set_int("aw_personaje_fisico_masa",1)
    end 
    if meta:get("aw_personaje_fisico_musculatura") == nil then
        meta:set_int("aw_personaje_fisico_musculatura",1)
    end 
    if meta:get("aw_personaje_cambiar_masa") == nil then
        meta:set_float("aw_personaje_cambiar_masa",4)
    end 
    if meta:get("aw_personaje_cambiar_musculatura") == nil then
        meta:set_float("aw_personaje_cambiar_musculatura",4)
    end 
    if meta:get("aw_personaje_fisico_sexo") == nil then
        meta:set_string("aw_personaje_fisico_sexo","hombre")
    end 
    if meta:get("aw_personaje_fisico_cuerpo") == nil then
        meta:set_string("aw_personaje_fisico_cuerpo","anthro")
    end
    if meta:get("aw_personaje_fisico_cuerpo") == "anthro" then
        minetest.after(1,function()
            player:set_properties(
            {textures = {"invisible.png"},
            eye_height = 0,
            collisionbox = { -0.4, 0, -0.4, 0.4, 1.5, 0.4 },
            selectionbox = { -0.4, 0, -0.4, 0.4, 1.5, 0.4, rotate = false },}
            )
            
        
            for _, childrens in pairs(player:get_children()) do
                childrens:set_detach()
            end
            
            local x = meta:get_int("aw_personaje_fisico_masa") or 1
            local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
            local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
            
            if x <1 or x >2 then
                x = 1
            end
            if y <1 or y >2 then
                y = 1
            end
            
            if sexo == "hombre" then
                player:set_eye_offset({x=0,y=16,z=3},{x=1,y=16,z=200})
            else
                player:set_eye_offset({x=0,y=14,z=2.5},{x=1,y=16,z=200})
            end
             
            local cuerpo = minetest.add_entity(pos, 'aw_personaje_anthro:entitybody'..sexo..'piernasmasa'..x..'musculos'..y)  
            local piernas = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."piernasmasa"..x.."musculos"..y)  
            local torso = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."torsomasa"..x.."musculos"..y)  
            local cabeza = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."cabezamasa"..x.."musculos"..y)  
            
            cuerpo:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            piernas:set_attach(cuerpo,"", {x=0, y=0, z=0}, {x=0, y=0, z=0},true)
            torso:set_attach(piernas,"torso", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            cabeza:set_attach(torso,"cabeza", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            
            cuerpo:get_luaentity().piernas = piernas
            cuerpo:get_luaentity().torso = torso
            cuerpo:get_luaentity().cabeza = cabeza
            
       end)     
    end
 
    
    --minetest.debug("none","aw_personaje_fisico_masa"..aw_personaje_fisico_masa)
    
    
    --if name and pos then
    --    minetest.log("none","Paso2")
    --    pos.y = pos.y + 0.5
    --    local piernas = minetest.add_entity(pos, "aw_personaje_anthro:piernas_cloth")  
    --    local torso = minetest.add_entity(pos, "aw_personaje_anthro:torso_cloth")  
    --    local cabeza = minetest.add_entity(pos, "aw_personaje_anthro:cabeza_cloth")  
        --local eyes = minetest.add_entity(pos, "assets_warehouse:player_eyes_cloth") 
    --    if player then
    --        piernas:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
    --        torso:set_attach(piernas,"torso", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
    --        cabeza:set_attach(torso,"cabeza", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            --eyes:set_attach(torso,"cabeza", {x=0, y=0, z=0}, {x=0, y=0, z=0},true)
            
    --        player:set_eye_offset({x=0, y=0, z=0.5},{x=0, y=0, z=0})
    --    end        
    --end
    
    --aw_character_put_cloth({player = player,cloth_action = "recover"})
    
      
end)

minetest.register_on_player_receive_fields(function(player, formname, fields)
    local name = player:get_player_name()
    if formname ~= "" then--por alguna extrana razon al usar sfinv para crear la seccion de los botones el formspec no tiene nombre
        minetest.log("none","Cloth")
        return
    end

    if fields.AWUnequip_hat then
        aw_character_put_cloth({
            player = player,
            cloth_type = "hat",
            cloth_action = "unequip"
        })
    elseif fields.AWUnequip_shirt then
        aw_character_put_cloth({
            player = player,
            cloth_type = "shirt",
            cloth_action = "unequip"
        })
    elseif fields.AWUnequip_pants then
        aw_character_put_cloth({
            player = player,
            cloth_type = "pants",
            cloth_action = "unequip"
        })
    elseif fields.AWUnequip_shirt then
        aw_character_put_cloth({
            player = player,
            cloth_type = "gloves",
            cloth_action = "unequip"
        })
    elseif fields.postal_menu then
        minetest.show_formspec(playername, "assets_warehouse:",formspec_postal_stuff) 
    end
end)

minetest.register_tool('aw_personaje_anthro:code_test', {
    selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
    collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
    description = "code_test",
    groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
    range=5.0,
    
    on_use = function(itemstack, user, pointed_thing)
        local player = user
        local pos = player:get_pos()
        local dir = player:get_look_dir()
        local yaw = player:get_look_horizontal()
        local power = 50
        local controls = player:get_player_control()
        local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
        local addinpos = {x=pos.x,y=pos.y,z=pos.z}
        
        user:set_properties({textures = {"invisible.png"},})
        local piernas = minetest.add_entity(pos, "aw_personaje_anthro:piernas_cloth")  
        piernas:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
        
        --obj = minetest.add_entity(addinpos,"assets_warehouse:bodytest")
        --obj:set_bone_position("head",{x=0,y=1.5102427005767822,z=-0.11746767908334732},{x=0,y=0,z=0})
        --0.006902-0.04148,-0.117468 m Vector((3.473289922339973e-08, -0.11746767908334732, 1.5102427005767822))
        --obj:set_bone_position("upperleg01.R",{x=0.101224,y=-0.07598638534545898,z=-0.030770733952522278},{x=0,y=0,z=0})
        
        --((-0., 0., -0.07598638534545898))
    end,
    
})

local function establecerpropiedades(player,sexo,masa,musculatura)
    -------------------------------------------------------
    --Estableciendo las propiedades del jugador
    meta = player:get_meta()
    
    
    meta:set_int("aw_personaje_fisico_masa",masa)
    meta:set_int("aw_personaje_fisico_musculatura",musculatura)
    meta:set_string("aw_personaje_fisico_sexo",sexo)
    
    --minetest.debug("none",masa..musculatura..sexo)
    meta:set_string("aw_personaje_fisico_cuerpo","anthro")
end



local function furry_neutral(sexo,x,y,offsetx,offsety)
    
    minetest.register_entity('aw_personaje_anthro:entitybody'..sexo..'piernasmasa'..x..'musculos'..y, {
        physical = false,
        visual_size =  {x=10,y=10,z=10} ,
        pointable = true,
        textures = {"invisible.png"},
        selectionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
        piernas = nil,
        torso = nil,
        cabeza = nil,
        on_step = function(self, dtime, moveresult)
            --if moveresult  then
            --    if moveresult.touching_ground == true then
            --        self.object:set_velocity({x=0.0, y=0.0, z=0.0})
            --    else
            --        self.object:set_acceleration({x = 0, y = -1, z = 0})
            --    end
            --end
            if self then
                if self.object then
                    --minetest.log("none","Test")
                    -- Comprueba que el personaje este emparentado al jugador
                    if self.object:get_attach() == nil then
                        self.object:remove()
                    else 
                        --Animaciones del personaje
                        --minetest.debug("none","Comprobacion")
                        local player = nil
                        if minetest.is_player(self.object:get_attach()) then
                            player = self.object:get_attach()
                        end
                        if player then
                            --minetest.debug("none","player")
                            local pos = player:get_pos()
                            local controls = player:get_player_control()
                            
                            -------------------------------------------------
                            --Piernas
                            local comprobacionpiernas = self.piernas
                            --minetest.debug("none",piernas:get_luaentity().name)
                            
                            if comprobacionpiernas ~= nil then
                                local piernas = comprobacionpiernas:get_luaentity()
                                --minetest.debug("none","Piernas")
                                if controls.up or controls.down or controls.left or controls.right then   
                                    aw_personaje_anthro.entity_anim(piernas,2,0,24)
                                    piernas.animation = 2
                                else
                                    aw_personaje_anthro.entity_anim(piernas,1,30,30)
                                    piernas.animation = 1
                                end
                            end
                            -------------------------------------------------
                            --Torso
                            local comprobaciontorso = self.torso
                            --minetest.debug("none",piernas:get_luaentity().name)
                            
                            if comprobaciontorso ~= nil then
                                local torso = comprobaciontorso:get_luaentity()
                                --minetest.debug("none","Piernas")
                                if controls.LMB or controls.RMB then   
                                --minetest.log("none","Caminar") 
                                    aw_personaje_anthro.entity_anim(torso,3,150,174,1,60)
                                    torso.animation = 2
                                elseif controls.up then   
                                    --minetest.log("none","Caminar") 
                                    aw_personaje_anthro.entity_anim(torso,2,0,24)
                                    torso.animation = 2
                                else
                                    aw_personaje_anthro.entity_anim(torso,1,30,30)
                                    torso.animation = 1
                                end
                            end
                        end
                    end
                end
            end
            
        end,
        
    })
     
     minetest.register_entity("aw_personaje_anthro:"..sexo.."piernasmasa"..x.."musculos"..y,{
        mesh =sexo.."piernasmasa"..x.."musculos"..y..'MD'..detalle_modelos..'.b3d',
        textures = {'aw_character_neutral_foxTQ'..calidad_texturas..'.png'},
        visual = "mesh",
        visual_size = {x = 10, y = 10, z = 10},
        wield = "",
        selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
        description = "body",
        cloth_type = "body",
        animacion = 0,
        on_step = function(self, dtime, moveresult)
            if self then
                if self.object then
                    --minetest.log("none","Test")
                    -- Comprueba que el personaje este emparentado al jugador
                    if self.object:get_attach() == nil then
                        self.object:remove()
                    end
                end
            end
        end
        
    })
     minetest.register_entity("aw_personaje_anthro:"..sexo.."torsomasa"..x.."musculos"..y,{
        mesh =sexo.."torsomasa"..x.."musculos"..y..'MD'..detalle_modelos..'.b3d',
        textures = {'aw_character_neutral_foxTQ'..calidad_texturas..'.png'},
        visual = "mesh",
        visual_size = {x = 1, y = 1, z = 1},
        wield = "",
        selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
        description = "body",
        cloth_type = "torso",
        animacion = 0,
        on_step = function(self, dtime, moveresult)
            if self then
                if self.object then
                    if self.object:get_attach() == nil then
                        self.object:remove()
                    end 
                end
            end
        end
        
    })
     minetest.register_entity("aw_personaje_anthro:"..sexo.."cabezamasa"..x.."musculos"..y,{
        mesh =sexo.."cabezamasa"..x.."musculos"..y..'MD'..detalle_modelos..'.b3d',
        textures = {'aw_character_neutral_foxTQ'..calidad_texturas..'.png'},
        visual = "mesh",
        wield = "",
        selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
        description = "body",
        cloth_type = "cabeza",
        animacion = 0,
        on_step = function(self, dtime, moveresult)
            if self then
                if self.object then
                    --minetest.log("none","Test")
                    -- Comprueba que el personaje este emparentado al jugador
                    if self.object:get_attach() == nil then
                        self.object:remove()
                    end
                end
            end
        end
    })
    
    minetest.register_entity('aw_personaje_anthro:entity'..sexo..'piernasmasa'..x..'musculos'..y, {
        physical = true,
        visual = "mesh",
        visual_size =  {x=1,y=2,z=2} ,
        mesh = sexo.."piernasmasa"..x.."musculos"..y..'MD'..detalle_modelos..'.b3d',
    --    textures = def.texture,
        pointable = true,
        selectionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
        
        
    })
    
    -------------------------------------------------------
    minetest.register_tool('aw_personaje_anthro:'..sexo..'piernasmasa'..x..'musculos'..y, {
        description = sexo..'masa'..x..'musculos'..y,
        groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
        range=5.0,
        inventory_image = "aw_makehuman_logo.png",
        
        on_use = function(itemstack, user, pointed_thing)
            local player = user
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local yaw = player:get_look_horizontal()
            local power = 50
            local controls = player:get_player_control()
            local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
            local addinpos = {x=pos.x,y=pos.y,z=pos.z}
            
            minetest.after(0.1,function()
                user:set_properties(
                {textures = {"invisible.png"},
                eye_height = 0,
                collisionbox = { -0.4, 0, -0.4, 0.4, 1.5, 0.4 },
                selectionbox = { -0.4, 0, -0.4, 0.4, 1.5, 0.4, rotate = false },}
                )
                end
            )
            
            if sexo == "hombre" then
                player:set_eye_offset({x=0,y=16,z=3},{x=1,y=16,z=200})
            else
                player:set_eye_offset({x=0,y=14,z=2.5},{x=1,y=16,z=200})
            end
            
            for _, childrens in pairs(player:get_children()) do
                childrens:set_detach()
            end
            
            local cuerpo = minetest.add_entity(pos, 'aw_personaje_anthro:entitybody'..sexo..'piernasmasa'..x..'musculos'..y)  
            local piernas = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."piernasmasa"..x.."musculos"..y)  
            local torso = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."torsomasa"..x.."musculos"..y)  
            local cabeza = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."cabezamasa"..x.."musculos"..y)  
            
            cuerpo:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            piernas:set_attach(cuerpo,"", {x=0, y=0, z=0}, {x=0, y=0, z=0},true)
            torso:set_attach(piernas,"torso", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            cabeza:set_attach(torso,"cabeza", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            
            cuerpo:get_luaentity().piernas = piernas
            cuerpo:get_luaentity().torso = torso
            cuerpo:get_luaentity().cabeza = cabeza
            
            ---------------------------------------------------
            establecerpropiedades(player,sexo,x,y)
        end,  
    })   
    ------------------------------------------------------------------------------
    if minetest.get_modpath("mobs") then
        mobs:register_mob('aw_personaje_anthro:furry_neutral'..sexo..'piernasmasa'..x..'musculos'..y, {
            type = "npc",
            visual = "mesh",
            visual_size = {x = 1.0, y = 1.0},
            mesh = sexo.."piernasmasa"..x.."musculos"..y..'MD'..detalle_modelos..'.b3d',
            collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.25, 0.4},
            --textures = {"invisible.png"},
            fear_height = 3,
            runaway = true,
            fly = false,
            walk_chance = 60,
            view_range = 5,
            passive = true,
            hp_min = 12,
            hp_max = 16,
            armor = 200,
            lava_damage = 5,
            fall_damage = 5,
            water_damage = 0,
            makes_footstep_sound = true,
            
            on_spawn = function(self,pos)
                minetest.debug("none","Test")
            
                
                self.piernas = nil
                self.torso = nil
                self.cabeza = nil 
                
                local objeto = self.object
                ----------------------------------------------------
                --Estableciendo propiedades Nota importante al principio intente poner las propiedades como si fueran metadatos pero daba error asi que use el metodo normal(ejemplo arriba)
                
                if self.aw_personaje_fisico_masa == nil then
                    self.aw_personaje_fisico_masa = x
                end 
                if self.aw_personaje_fisico_musculatura == nil then
                    self.aw_personaje_fisico_musculatura=y
                end 
                if self.aw_personaje_fisico_sexo == nil then
                    self.aw_personaje_fisico_sexo = sexo
                end 
                if self.aw_personaje_necesidades_energia == nil then
                    self.aw_personaje_necesidades_energia=100
                end 
                
                if self.aw_personaje_durmiendo == nil then
                    self.aw_personaje_durmiendo=0
                end 
                
                ----------------------------------------------------
                
                 
                local pos = objeto:get_pos()
                
                local piernas = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."piernasmasa"..x.."musculos"..y)  
                local torso = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."torsomasa"..x.."musculos"..y)  
                local cabeza = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."cabezamasa"..x.."musculos"..y)  
                
                piernas:set_attach(objeto,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                torso:set_attach(piernas,"torso", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                cabeza:set_attach(torso,"cabeza", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                
                self.piernas = piernas
                self.torso = torso
                self.cabeza = cabeza
                
                
                return true
            end,
            
            do_custom = function(self, dtime)
                if self then
                    if self.object then
                        
                        
                        energia = self.aw_personaje_necesidades_energia
                        durmiendo = self.aw_personaje_durmiendo
                        
                        local function animacionpiernas(self,idanimacion,comienzoanimacion,finanimacion)
                            local comprobacionpiernas = self.piernas
                            if comprobacionpiernas ~= nil then
                                local piernas = comprobacionpiernas:get_luaentity()
                                aw_personaje_anthro.entity_anim(piernas,idanimacion,comienzoanimacion,finanimacion)
                                piernas.animation = idanimacion
                            end
                        end
                        
                        local function animaciontorso(self,idanimacion,comienzoanimacion,finanimacion)
                            local comprobaciontorso = self.torso
                            if comprobaciontorso ~= nil then
                                local torso = comprobaciontorso:get_luaentity()
                                aw_personaje_anthro.entity_anim(torso,idanimacion,comienzoanimacion,finanimacion)
                                torso.animation = idanimacion
                            end
                        end
                        
                        if durmiendo == 0 then
                            minetest.debug("none","despierto")
                            minetest.debug("none",energia)
                            self.aw_personaje_necesidades_energia = energia-0.1
                            if self.state == "walk" then
                                minetest.debug("none","caminar")
                                animacionpiernas(self,3,0,24)
                                animaciontorso(self,3,0,24)
                                self.aw_personaje_necesidades_energia = energia-0.1
                            elseif self.state == "stand" then
                                animacionpiernas(self,2,30,30)
                                animaciontorso(self,2,30,30)
                            end
                        else
                            minetest.debug("none","durmiendo")
                            minetest.debug("none",energia)
                            animacionpiernas(self,1,144,144)
                            animaciontorso(self,1,144,144)
                            
                            self.aw_personaje_necesidades_energia = energia+1.0
                            if energia >90 then
                                self.aw_personaje_durmiendo=0
                            end
                        end 
                        
                        
                        if energia < 10 then
                            self.aw_personaje_durmiendo =1
                        end
                        
                        
                    end
                end
                


                return true
            end,

            --on_die = function(self, pos)
            --end,
            
        })
        
        
        ------------------------------------------------------------------
        mobs:spawn({
            name = 'aw_personaje_anthro:furry_neutral'..sexo..'piernasmasa'..x..'musculos'..y,
            nodes = {"default:dirt_with_grass", "ethereal:dry_dirt"},
            min_light = 14,
            interval = 60,
            chance = 1,
            min_height = 10,
            max_height = 31000,
            day_toggle = true
        })
        
        mobs:register_egg('aw_personaje_anthro:furry_neutral'..sexo..'piernasmasa'..x..'musculos'..y, 'aw_personaje_anthro:furry_neutral'..sexo..'piernasmasa'..x..'musculos'..y, "wool_brown.png", 1)
    
   end 
    
end

furry_neutral("mujer","1","1",{x=0,y=0.5,z=2.5},{x=0,y=0,z=0})
furry_neutral("mujer","2","1")
furry_neutral("mujer","2","0")
furry_neutral("mujer","1","2")
furry_neutral("mujer","2","2")

furry_neutral("hombre","1","1")
furry_neutral("hombre","2","1")
furry_neutral("hombre","2","0")
furry_neutral("hombre","1","2")
furry_neutral("hombre","2","2")
--------------------------------------------------------------
local function cuerpodurmiendo(sexo,x,y,offsetx,offsety)
    
    minetest.register_entity('aw_personaje_anthro:entitybody'..sexo..'piernasmasa'..x..'musculos'..y.."durmiendo", {
        physical = false,
        visual_size =  {x=10,y=10,z=10} ,
        pointable = true,
        textures = {"invisible.png"},
        selectionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,0.05,0.1},
        piernas = nil,
        torso = nil,
        cabeza = nil,
        on_step = function(self, dtime, moveresult)
            --if moveresult  then
            --    if moveresult.touching_ground == true then
            --        self.object:set_velocity({x=0.0, y=0.0, z=0.0})
            --    else
            --        self.object:set_acceleration({x = 0, y = -1, z = 0})
            --    end
            --end
            if self then
                if self.object then
                    --minetest.log("none","Test")
                    -- Comprueba que el personaje este emparentado al jugador
                    
                    --Animaciones del personaje
                    --minetest.debug("none","Comprobacion")
                    local player = nil
                    if minetest.is_player(self.object:get_attach()) then
                        player = self.object:get_attach()
                    end
                    if player then
                        --minetest.debug("none","player")
                        local pos = player:get_pos()
                        local controls = player:get_player_control()
                        
                        -------------------------------------------------
                        --Piernas
                        local comprobacionpiernas = self.piernas
                        --minetest.debug("none",piernas:get_luaentity().name)
                        
                        if comprobacionpiernas ~= nil then
                            local piernas = comprobacionpiernas:get_luaentity()
                            aw_personaje_anthro.entity_anim(piernas,1,144,144)
                            piernas.animation = 1
                        
                            --minetest.debug("none","Piernas")
                            
                        end
                        -------------------------------------------------
                        --Torso
                        local comprobaciontorso = self.torso
                        --minetest.debug("none",piernas:get_luaentity().name)
                        
                        if comprobaciontorso ~= nil then
                            local torso = comprobaciontorso:get_luaentity()
                            aw_personaje_anthro.entity_anim(torso,1,144,144)
                            torso.animation = 1
                        
                            
                        end
                        -------------------------------------------------
                        --Cabeza
                        local comprobacioncabeza = self.cabeza
                        --minetest.debug("none",piernas:get_luaentity().name)
                        
                        if comprobacioncabeza ~= nil then
                            local cabeza = comprobacioncabeza:get_luaentity()
                            aw_personaje_anthro.entity_anim(cabeza,1,144,144)
                            cabeza.animation = 1
                        
                            
                        end
                        -----------------
                        local tod = minetest.get_timeofday()
                        minetest.debug("none","tod"..tod)

                        if tod > 0  and tod < 0.5 then
                            
                            minetest.after(1,function()
                                minetest.debug("none","Durmiendo")
                                minetest.set_timeofday(0.6)
                                self.object:remove(self.object)
                                end
                            )
                            return
                        else
                            minetest.after(1,function()
                                minetest.debug("none","Durmiendo entre el mediodia y la medianoche")
                                minetest.set_timeofday(0)
                                self.object:remove(self.object)
                                end
                            )
                        end
                    end
                end
            end
        end,
        on_detach = function(self, parent)
            --minetest.debug("none","detach")
            
            if self then
                    
                if self.object then
                    -------------------------------------------------
                    --Piernas
                    local comprobacionpiernas = self.piernas
                        
                    --if comprobacionpiernas ~= nil then
                    --    local piernas = comprobacionpiernas:get_luaentity()
                    --    piernas:remove()
                    --end  
                    --------------------------------------------------
                    --Dando cuerpo normal  
                    local player = parent
                    local pos = player:get_pos()
                    
                    player:set_physics_override({
                    
                        speed = 1,
                        jump = 1,
                    
                    })
                    
                    local meta = parent:get_meta()
                    local x = meta:get_int("aw_personaje_fisico_masa") or 1
                    local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
                    local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
                    
                    local cuerpo = minetest.add_entity(pos, 'aw_personaje_anthro:entitybody'..sexo..'piernasmasa'..x..'musculos'..y)  
                    local piernas = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."piernasmasa"..x.."musculos"..y)  
                    local torso = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."torsomasa"..x.."musculos"..y)  
                    local cabeza = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."cabezamasa"..x.."musculos"..y)  
                    
                    
                    cuerpo:set_attach(parent,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                    piernas:set_attach(cuerpo,"", {x=0, y=0, z=0}, {x=0, y=0, z=0},true)
                    torso:set_attach(piernas,"torso", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                    cabeza:set_attach(torso,"cabeza", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
                    
                    cuerpo:get_luaentity().piernas = piernas
                    cuerpo:get_luaentity().torso = torso
                    cuerpo:get_luaentity().cabeza = cabeza
                end
            end
        end   
    })
     
     minetest.register_entity("aw_personaje_anthro:"..sexo.."piernasmasa"..x.."musculos"..y.."durmiendo",{
        mesh =sexo.."piernasmasa"..x.."musculos"..y..'MD'..detalle_modelos..'.b3d',
        textures = {'aw_character_neutral_foxTQ'..calidad_texturas..'.png'},
        visual = "mesh",
        visual_size = {x = 10, y = 10, z = 10},
        wield = "",
        selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
        description = "body",
        cloth_type = "body",
        animacion = 0,
        on_step = function(self, dtime, moveresult)
            if self then
                if self.object then
                    --minetest.log("none","Test")
                    -- Comprueba que el personaje este emparentado al jugador
                    if self.object:get_attach() == nil then
                        self.object:remove()
                    end
                end
            end
        end
        
    })
     minetest.register_entity("aw_personaje_anthro:"..sexo.."torsomasa"..x.."musculos"..y.."durmiendo",{
        mesh =sexo.."torsomasa"..x.."musculos"..y..'MD'..detalle_modelos..'.b3d',
        textures = {'aw_character_neutral_foxTQ'..calidad_texturas..'.png'},
        visual = "mesh",
        visual_size = {x = 1, y = 1, z = 1},
        wield = "",
        selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
        description = "body",
        cloth_type = "torso",
        animacion = 0,
        on_step = function(self, dtime, moveresult)
            if self then
                if self.object then
                    --minetest.log("none","Test")
                    -- Comprueba que el personaje este emparentado al jugador
                    if self.object:get_attach() == nil then
                        self.object:remove()
                    end
                end
            end
        end
        
    })
     minetest.register_entity("aw_personaje_anthro:"..sexo.."cabezamasa"..x.."musculos"..y.."durmiendo",{
        mesh =sexo.."cabezamasa"..x.."musculos"..y..'MD'..detalle_modelos..'.b3d',
        textures = {'aw_character_neutral_foxTQ'..calidad_texturas..'.png'},
        visual = "mesh",
        wield = "",
        selectionbox ={-0.1,-0.5,-0.1,0.1,1.0,0.1},
        collisionbox = {-0.1,-0.5,-0.1,0.1,1.0,0.1},
        description = "body",
        cloth_type = "cabeza",
        animacion = 0,
        on_step = function(self, dtime, moveresult)
            if self then
                if self.object then
                    --minetest.log("none","Test")
                    -- Comprueba que el personaje este emparentado al jugador
                    if self.object:get_attach() == nil then
                        self.object:remove()
                    end
                end
            end
        end
    })
    
    
    -------------------------------------------------------
    minetest.register_tool('aw_personaje_anthro:dormir',{--..sexo..'piernasmasa'..x..'musculos'..y.."durmiendo", {
        description = "durmiendo",
        groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3},
        range=5.0,
        inventory_image = "aw_makehuman_logo.png",
        
        on_use = function(itemstack, user, pointed_thing)
            local player = user
            local pos = player:get_pos()
            local dir = player:get_look_dir()
            local yaw = player:get_look_horizontal()
            local power = 50
            local controls = player:get_player_control()
            local aceleration = {x=dir.x*power, y=dir.y*power, z=dir.z*power}
            local addinpos = {x=pos.x,y=pos.y,z=pos.z}
            
            --player:set_eye_offset(offsetx,offsety)
            
            for _, childrens in pairs(player:get_children()) do
                childrens:set_detach()
            end
            
            player:set_physics_override({
            
                speed = 0,
                jump = 0,
            
            })
            
            
            --Dando cuerpo normal  
            local meta = player:get_meta()
            local x = meta:get_int("aw_personaje_fisico_masa") or 1
            local y = meta:get_int("aw_personaje_fisico_musculatura") or 1
            local sexo = meta:get_string("aw_personaje_fisico_sexo") or "hombre"
            
            local cuerpo = minetest.add_entity(pos, 'aw_personaje_anthro:entitybody'..sexo..'piernasmasa'..x..'musculos'..y..'durmiendo')  
            local piernas = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."piernasmasa"..x.."musculos"..y..'durmiendo')  
            local torso = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."torsomasa"..x.."musculos"..y..'durmiendo')  
            local cabeza = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."cabezamasa"..x.."musculos"..y..'durmiendo')  
        
              
            
            cuerpo:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            piernas:set_attach(cuerpo,"", {x=0, y=0, z=0}, {x=0, y=0, z=0},true)
            torso:set_attach(piernas,"torso", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            cabeza:set_attach(torso,"cabeza", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
            
            cuerpo:get_luaentity().piernas = piernas
            cuerpo:get_luaentity().torso = torso
            cuerpo:get_luaentity().cabeza = cabeza
            
            
            
        end,  
    })   
end

cuerpodurmiendo("mujer","1","1",{x=0,y=0.5,z=2.5},{x=0,y=0,z=0})
cuerpodurmiendo("mujer","2","1")
cuerpodurmiendo("mujer","2","0")
cuerpodurmiendo("mujer","1","2")
cuerpodurmiendo("mujer","2","2")

cuerpodurmiendo("hombre","1","1")
cuerpodurmiendo("hombre","2","1")
cuerpodurmiendo("hombre","2","0")
cuerpodurmiendo("hombre","1","2")
cuerpodurmiendo("hombre","2","2")

--------------------------------------------------------

local part1 = "textarea[0.5,10.5;90,14;;;I don't speak English. For the changes take effect you need to restart the game,Important for the hightes details you need the mod aw_personaje_anthrohigh ,Español Para que los cambios tengan efecto tiene que reiniciar el juego,Importante para los detalles mas altos necesita el mod aw character_neutralhig]"
local part2 = "textarea[0.5,21.5;90,4;;;Model Quality Calidad de modelos ]"
local part3 = "textarea[0.5,30.5;90,4;;;Texture Quality Calidad de texturas]"


local formspec_config = { 
        "formspec_version[4]",
        "size[100,100]",
        "anchor[0.5,0.5]",
        "padding[0.0,0.0]",
        "scrollbaroptions[min=0,max=50,smallstep=10,largestep=20,thumbsize=10,arrows=default]",
        "scrollbar[95,0;5,100;vertical;'testscroll';]",
        "scroll_container[1.10,0.0;90,150;'testscroll';vertical;0.1]",
        part1,
        part2,
        "button_exit[0.5,24;10,5;Low;1]",
        "button_exit[30,24;10,5;Medium;2]",
        "button_exit[60,24;10,5;High;3]",
        part3,
        "button_exit[0.5,43;10,5;TextureLow;1]",
        "button_exit[30,43;10,5;TextureMediun;2]",
        "button_exit[60,43;10,5;TextureHigh;3]",
        
        "textarea[0.5,50.5;90,40;;;I don't speak English. This mod is for try to sponsor the Makehuman and give the player a more realistic model using this(mpfb),the low version have less than 1000 vertex(775 aporx),the mediun detail have betwen 1000 and 2000 vertex,the high quality have 7000 vertex aprox,i use custom topologies instead of the original because these have 13 000 vertex what is like to much even for the more potent machines,and the high custom topology have half of this and the models look very similar,also i decide to made diferent mods with the diferent model qualities for don't made then to big (all togheter is like 50 mb) and made this more easy to download and upload,is you like this mod maybe will like the Makehuman software or their plugin for Blender,Este mod es para tratar de promover Makehuman y darle al jugador un modelo mas realista usando este,la version baja tiene menos de 1000 vertices(775 aproximado),la de detalle medio tiene entre 1000 vertices,los de alta calidad tienen 7000 vertices aproximado,e usado unas topologias customizada en vez de la original porque esta tiene unos 13 000 vertices aproximados lo que es mucho incluso para las maquinas mas potentes,y la topologia de alta calidad que he creado tiene la mitad y los modelos lucen muy similares,tambien decidi hacer diferentes mods para las diferentes calidades de modelos para asi no hacerlo muy grande(todo junto tiene como 50 mb) y hacerlo mas facil de descargar y subir,si te gusta este mod tal vez te guste Makehuman o su plugin para Blender ]",
        "textarea[0.5,90.5;90,40;;;I don't speak English.This mod was created by Jaldmic using the Makehuman plugin for Blender(mpfb),the code is published under CC-BY-SA and the models are under the same license even if the Makehuman model is originally CC0 because i use the targets what i create for give a furry aspect to the model,i have a account in Ko fi,Mastodon,Makehuman and E621.  Español Este mod fue creado por Jaldmic usando el plugin de Makehuman para Blender(mpfb),el codigo es publicado en CC-BY-SA y los modelos estan bajo la misma licencia incluso si el Modelo original del Makehuman es CC0 porque e usado targets que he creado para darle a el modelo un aspecto mas furry al modelo,tengo una cuenta en Ko Fi,Mastodon,Makehuman y E621   ]",
        
        
        "scroll_container_end[]",
}

formspec_config =  table.concat(formspec_config, "")

minetest.register_on_player_receive_fields(function(player, formname, fields)
    local name = player:get_player_name()
    
    local settings = Settings(world_path.."/assets_warehouse.conf")
    if formname ~= "aw_personaje_anthro:config_menu" then
        return
    end

    if fields.Low then
        detalle_modelos = 1
    elseif fields.Medium then
        detalle_modelos = 2
    elseif fields.High then
        detalle_modelos = 3
    elseif fields.TextureLow then
        calidad_texturas = 1
    elseif fields.TextureMediun then
        calidad_texturas = 2
    elseif fields.TextureHigh then
        calidad_texturas = 3
    
    end
    
    local content = "aw_personaje_anthro_model_quality = "..detalle_modelos .."\n".."aw_personaje_anthro_texture_quality = "..calidad_texturas
    
    minetest.safe_file_write(world_path.."/aw_personaje_anthro.conf", content)
    
end)

minetest.register_tool("aw_personaje_anthro:aw_personaje_anthro_config_menu", {
    description = "aw_personaje_anthro_config_menu",
    --tiles = "configuration_menu.png",
    inventory_image = "aw_makehuman_logo.png",
    --wield_image = "configuration_menu.png",
    groups = {cracky = 1},
    on_use = function(itemstack, player, pointed_thing)
        local playername = player:get_player_name()
        if pointed_thing.type == "node" then
            minetest.show_formspec(playername, "aw_personaje_anthro:config_menu",formspec_config) 
        else 
            minetest.show_formspec(playername, "aw_personaje_anthro:config_menu",formspec_config)    
        end
    end,
    on_receive_fields = function(pos, formname, fields, player)
        if fields.quit then
            return
        end

        print(fields.x)
    end
})

--minetest.register_on_item_eat(function(hp_change, replace_with_item, itemstack, user, pointed_thing))`
--    * Called when an item is eaten, by `minetest.item_eat`
--    * Return `itemstack` to cancel the default item eat response (i.e.: hp increase).

--Funcion que maneja la masa del personaje
minetest.register_on_item_eat(function(hp_change, replace_with_item, itemstack, user, pointed_thing)
    local player = user,
    minetest.debug("none","comprobacion")
    
    
    local meta = player:get_meta() 
        
    masa = tonumber(meta:get("aw_personaje_cambiar_masa"))
                        
    meta:set_float("aw_personaje_cambiar_masa",masa+50) 
        
        
    end
)





minetest.register_on_joinplayer(function(player)
    local name = player:get_player_name()
    local pos = player:get_pos()
    
    local meta = player:get_meta()
    
    
    minetest.debug("none","hud")
    --aw_personaje_anthro_hud[name]=player:hud_add({hud_elem_type="text",name= "textodemasa",text="texto"})
    aw_personaje_anthro_hud[name] = player:hud_add({
        hud_elem_type = "text",
        text = "Ma"..meta:get("aw_personaje_fisico_masa").."Mu"..meta:get("aw_personaje_fisico_musculatura").."CMa"..math.round(tonumber(meta:get("aw_personaje_cambiar_masa"))).."CMu"..meta:get("aw_personaje_cambiar_musculatura"),
        alignment = {x=1,y=1},
        offset = { x = 1, y =  1 },
        z_index = 100,
        scale={x=10,y=10},
        size ={x=5,y=5},
    })
    
end)



local function cambiarcuerpojugador(player,sexo,x,y)

    for _, childrens in pairs(player:get_children()) do
        childrens:set_detach()
    end
    
    if tonumber(x)==1 and tonumber(y)==0 then
        y = 1
    end
    
    local pos = player:get_pos()
    
    local cuerpo = minetest.add_entity(pos, 'aw_personaje_anthro:entitybody'..sexo..'piernasmasa'..x..'musculos'..y)  
    local piernas = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."piernasmasa"..x.."musculos"..y)  
    local torso = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."torsomasa"..x.."musculos"..y)  
    local cabeza = minetest.add_entity(pos, "aw_personaje_anthro:"..sexo.."cabezamasa"..x.."musculos"..y)  
    
    cuerpo:set_attach(player,"", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
    piernas:set_attach(cuerpo,"", {x=0, y=0, z=0}, {x=0, y=0, z=0},true)
    torso:set_attach(piernas,"torso", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
    cabeza:set_attach(torso,"cabeza", {x=0, y=0, z=0}, {x=0, y=180, z=0},true)
    
    cuerpo:get_luaentity().piernas = piernas
    cuerpo:get_luaentity().torso = torso
    cuerpo:get_luaentity().cabeza = cabeza
    
    ---------------------------------------------------
    establecerpropiedades(player,sexo,x,y)
end

minetest.register_globalstep(function(dtime)
    for _, player in pairs(minetest.get_connected_players()) do
        local name = player:get_player_name() 
        local hud = aw_personaje_anthro_hud[name]
        
        local meta = player:get_meta() 
        local controles = player:get_player_control()
        
        
        local masa = tonumber(meta:get("aw_personaje_cambiar_masa"))
                            
        meta:set_float("aw_personaje_cambiar_masa",masa-0.05) 
        
        local demora = settings:get("aw_personaje_anthro_demora") or 70--rapido 70,normal 140,lento 210
        ------------------------
        if tonumber(meta:get("aw_personaje_cambiar_masa"))<1 then
            meta:set_float("aw_personaje_cambiar_masa",demora)
            if tonumber(meta:get("aw_personaje_fisico_masa"))>1 then
                meta:set_int("aw_personaje_fisico_masa",tonumber(meta:get("aw_personaje_fisico_masa"))-1)
                cambiarcuerpojugador(player,meta:get("aw_personaje_fisico_sexo"),meta:get("aw_personaje_fisico_masa"),meta:get("aw_personaje_fisico_musculatura"))
            else
                if tonumber(meta:get("aw_personaje_fisico_musculatura"))>0 then
                    meta:set_int("aw_personaje_fisico_musculatura",tonumber(meta:get("aw_personaje_fisico_musculatura"))-1)
                    cambiarcuerpojugador(player,meta:get("aw_personaje_fisico_sexo"),meta:get("aw_personaje_fisico_masa"),meta:get("aw_personaje_fisico_musculatura"))
                end
            end
        end
        ----------------------------
        if tonumber(meta:get("aw_personaje_cambiar_masa"))>demora*2 then
            meta:set_float("aw_personaje_cambiar_masa",demora)
            if tonumber(meta:get("aw_personaje_fisico_masa"))<2 then
                meta:set_int("aw_personaje_fisico_masa",tonumber(meta:get("aw_personaje_fisico_masa"))+1)
                cambiarcuerpojugador(player,meta:get("aw_personaje_fisico_sexo"),meta:get("aw_personaje_fisico_masa"),meta:get("aw_personaje_fisico_musculatura"))
                
            end
        end
        ------------Musculatura
        if tonumber(meta:get("aw_personaje_cambiar_musculatura"))>demora*2 then
            meta:set_float("aw_personaje_cambiar_musculatura",demora)
            if tonumber(meta:get("aw_personaje_fisico_musculatura"))<2 then
                meta:set_int("aw_personaje_fisico_musculatura",tonumber(meta:get("aw_personaje_fisico_musculatura"))+1)
                cambiarcuerpojugador(player,meta:get("aw_personaje_fisico_sexo"),meta:get("aw_personaje_fisico_masa"),meta:get("aw_personaje_fisico_musculatura"))
            end
        end
        if controles.up or controles.down or controles.right or controles.left then
            meta:set_float("aw_personaje_cambiar_musculatura",tonumber(meta:get("aw_personaje_cambiar_musculatura"))+0.5)
        end
        
        ------------Evitando error--------------------------
        if tonumber(meta:get("aw_personaje_fisico_masa"))==1 and tonumber(meta:get("aw_personaje_fisico_musculatura"))==0 then
            meta:set_int("aw_personaje_fisico_musculatura",1)
        end
        player:hud_change(hud,"text","Ma"..meta:get("aw_personaje_fisico_masa").."Mu"..meta:get("aw_personaje_fisico_musculatura").."CMa"..math.round(tonumber(meta:get("aw_personaje_cambiar_masa"))).."CMu"..math.round(tonumber(meta:get("aw_personaje_cambiar_musculatura"))))
    end
end)
    
-----------------------------------------------------------
--Used by `ObjectRef:hud_add`. Returned by `ObjectRef:hud_get`.
--    {
--        hud_elem_type = "image",
        -- Type of element, can be "image", "text", "statbar", "inventory",
        -- "waypoint", "image_waypoint", "compass" or "minimap"
--        position = {x=0.5, y=0.5},
        -- Top left corner position of element
--        name = "<name>",
--        scale = {x = 1, y = 1},
--        text = "<text>",
--        text2 = "<text>",
--        number = 0,
--        item = 0,
--        direction = 0,
        -- Direction: 0: left-right, 1: right-left, 2: top-bottom, 3: bottom-top
--        alignment = {x=0, y=0},
--        offset = {x=0, y=0},
--        world_pos = {x=0, y=0, z=0},
--        size = {x=0, y=0},
--        z_index = 0,
        -- Z index: lower z-index HUDs are displayed behind higher z-index HUDs
--        style = 0,
--    }