-- sfinv/init.lua

dofile(minetest.get_modpath("sfinv") .. "/api.lua")

-- Load support for MT game translation.
local S = minetest.get_translator("sfinv")

sfinv.register_page("sfinv:crafting", {
	title = S("Crafting"),
	get = function(self, player, context)
		return sfinv.make_formspec(player, context, [[
				list[current_player;craft;1.75,0.5;3,3;]
				list[current_player;craftpreview;5.75,1.5;1,1;]
				image[4.75,1.5;1,1;sfinv_crafting_arrow.png]
				listring[current_player;main]
				listring[current_player;craft]
			]], true)
	end
})

sfinv.register_page("sfinv:quality", {
	title = S("Textures"),
	get = function(self, player, context)
		return sfinv.make_formspec(player, context, [[
            button_exit[0,1;2,1;pixel;pixel]
            button_exit[2,1;2,1;big;big]
            button_exit[4,1;2,1;medium;medium] 
            button_exit[6,1;2,1;little;little]
			]], true)
	end
})

minetest.register_on_player_receive_fields(function(player, formname, fields)
    name = player:get_player_name()
	if formname ~= "sfinv:quality" then
		return
	end
    if fields.pixel then
        minetest.settings:set("texturequality",1)
	elseif fields.big then
        minetest.settings:medium("texturequality",10)
	elseif fields.five then
        minetest.settings:set("texturequality",25)
    elseif fields.little then
        minetest.settings:set("texturequality",50)
	end
end)