minetest.register_on_joinplayer(function(player)
    local name = player:get_player_name()
    local meta = player:get_meta()
    player:hud_set_hotbar_itemcount(2)--`: sets number of items in builtin hotbar
    local days_text   = "Days pased: " .. meta:get_int("default:days_pased")
    local days = player:hud_add({
         hud_elem_type = "text",
         position      = {x = 0.5, y = 0.5},
         offset        = {x = 0,   y = 0},
         text          = days_text,
         alignment     = {x = 0, y = 6},  -- center aligned
         scale         = {x = 100, y = 100}, -- covered later
         size          = {x=5},
    })
    
    --player:hud_add({
    --    hud_elem_type = "image",
    --    position  = {x = 1, y = 0.5},
    --    offset    = {x = -215, y = 23},
    --    text      = "score_bar_empty.png",
    --    scale     = { x = 1, y = 1},
    --    alignment = { x = 1, y = 0 },
    --})
end)
score = {}
local saved_huds = {}

function score.update_hud(player)
    local player_name = player:get_player_name()
    local meta        = player:get_meta()
    local days_text   = "Days pased: " .. meta:get_int("default:days_pased")
    
    local ids = saved_huds[player_name]
    if ids then
        player:hud_change(ids["Days"], "text", days_text)
    else
        ids = {}
        saved_huds[player_name] = ids

        -- create HUD elements and set ids into `ids`
    end
end

minetest.register_on_joinplayer(score.update_hud)

minetest.register_on_leaveplayer(function(player)
    saved_huds[player:get_player_name()] = nil
end)


