local damage = tonumber(minetest.settings:get("difficulty")) or 4


mobs:register_mob("monsters:testmonster", {
	type = "monster",
    textures = {{"dirtQ1.png"}},
	passive = false,
	attack_type = "dogfight",
	pathfinding = true,
	reach = 2,
	damage = 1,
	hp_min = 3,
	hp_max = 27,
	armor = 100,
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	visual = "mesh",
	mesh = "1.obj",
	view_range = 10,
	walk_velocity = 1,
	run_velocity = 2,
	jump = true,
	
})


if not mobs.custom_spawn_monster then
mobs:spawn({
	name = "monsters:testmonster",
	nodes = {"default:dirtwithgrass1"},
	interval = 1,
	chance = 1,
	active_object_count = 20,
	min_height = 0,
})
end

mobs:register_egg("monsters:testmonster", "Monster", "dirtQ1.png", 1)
mobs:alias_mob("monsters:testmonster", "monsters:testmonster")