--
-- Aliases for map generators
--

-- All mapgens

minetest.register_alias("mapgen_stone", "default:stone")
minetest.register_alias("mapgen_water_source", "default:water_source")
minetest.register_alias("mapgen_river_water_source", "default:river_water_source")

--No borrar lo de los aliases
-- All mapgens except mgv6
minetest.register_biome({
	name = "jungle",
	node_top = 'default:dirtwithgrass1',
	depth_top = 1,
	node_filler = 'default:dirt',
	depth_filler = 3,
	node_riverbed = 'default:dirt',
	depth_riverbed = 2,
	node_dungeon = "default:cobble",
	node_dungeon_alt = "default:mossycobble",
	node_dungeon_stair = "stairs:stair_cobble",
	y_max = 31000,
	y_min = 1,
	heat_point = 60,
	humidity_point = 68,
})
--
-- Register decorations
--
-- All mapgens except mgv6

local function register_jungle_deco(length)
	minetest.register_decoration({
		name = "default:deco" .. length,
		deco_type = "simple",
		place_on = {"default:dirtwithgrass1"},
		sidelen = 16,
        fill_ratio = 0.05,
		--noise_params = {
		--	offset = 1,
		--	scale = 1,
		--	spread = {x = 200, y = 200, z = 200},
		--	seed = 329,
		--	octaves = 3,
		--	persist = 0.6
		--},
		biomes = {"jungle"},
		y_max = 31000,
		y_min = 1,
		decoration = "default:deco" .. length,
	})
end

minetest.register_decoration({
	name = "default:tree",
	deco_type = "schematic",
	place_on = {"default:dirtwithgrass1"},
	sidelen = 16,
	noise_params = {
		offset = 0.024,
		scale = 0.015,
		spread = {x = 250, y = 250, z = 250},
		seed = 2,
		octaves = 3,
		persist = 0.66
	},
	offset = 1,
	biomes = {"jungle"},
	y_max = 31000,
	y_min = 1,
	rotation = "random",
	flags = "place_center_x",
	--decoration = 'default:tree',
	--schematic = minetest.get_modpath("default") .. "/schematics/tree.mts",
	schematic = {
            size = {x = 1, y = 3, z = 1},
            data = {
                {name = "default:treebase", param1 = 255, param2 = 0},
                {name = "default:tree", param1 = 255, param2 = 0},
                {name = "default:tree_leaves", param1 = 255, param2 = 0},
                 ...
            },
            yslice_prob = {
                {ypos = 2, prob = 128},
                {ypos = 5, prob = 64},
                 ...
            },
        },
})

register_jungle_deco(4)
register_jungle_deco(3)
register_jungle_deco(2)
register_jungle_deco(1)

--