local damage = tonumber(minetest.settings:get("difficulty")) or 4


mobs:register_mob("monsters:testmonster", {
	type = "monster",
    textures = {{"dirtQ1.png"}},
	passive = false,
	attack_type = "dogfight",
	pathfinding = true,
	reach = 2,
	damage = 100,
	hp_min = 3,
	hp_max = 27,
	armor = 100,
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	visual = "mesh",
	mesh = "1.obj",
	view_range = 5,
	walk_velocity = 0.5,
	run_velocity = 1,
	jump = true,
    on_spawn = function(self, pos)
        for _ , player in pairs(minetest.get_connected_players()) do
            local player_name = player:get_player_name()
            local meta = player:get_meta()
            local m2 = minetest.get_day_count()
            if m2 < 0  then
                self.object:remove()
            end
        end
    end
	
})

mobs:register_mob("monsters:watertestmonster", {
	type = "monster",
    --textures = {{"dirtQ1.png"}},
	passive = false,
	attack_type = "dogfight",
	pathfinding = true,
	reach = 1.5,
	damage = 1,
	hp_min = 1,
	hp_max = 1,
	armor = 100,
	collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
	visual = "mesh",
	mesh = "2.obj",
	view_range = 20,
	walk_velocity = 2,
	run_velocity = 5,
	jump = false,
    stepheight = 0.1,
    fly = true,        
    fly_in ="default:water_source",
    air_damage = 0.1,
    on_spawn = function(self, pos)
        for _ , player in pairs(minetest.get_connected_players()) do
            local player_name = player:get_player_name()
            local meta = player:get_meta()
            local m2 = minetest.get_day_count()
            if m2 < 6  then
                self.object:remove()
            end
        end
    end
})

mobs:register_mob("monsters:rockmonster", {
	type = "monster",
    textures = {{"default_cobble.png"}},
	passive = false,
	attack_type = "dogfight",
	pathfinding = true,
	reach = 2,
	damage = 50,
	hp_min = 3,
	hp_max = 27,
	armor = 100,
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	visual = "mesh",
	mesh = "3.obj",
	view_range = 5,
	walk_velocity = 2.5,
	run_velocity = 3,
	jump = true,
    on_spawn = function(self, pos)
        for _ , player in pairs(minetest.get_connected_players()) do
            local player_name = player:get_player_name()
            local meta = player:get_meta()
            local m2 = minetest.get_day_count()
            if m2 < 3  then
                self.object:remove()
            end
        end
    end
	
})


if not mobs.custom_spawn_monster then
mobs:spawn({
	name = "monsters:testmonster",
	nodes = {"default:dirtwithgrass1"},
	interval = 1,
	chance = 1,
	active_object_count = 20,
	min_height = 0,
})
mobs:spawn({
	name = "monsters:watertestmonster",
	nodes = {"default:water_source"},
	interval = 1,
	chance = 1,
	active_object_count = 100,
	min_height = 0,
})
mobs:spawn({
	name = "monsters:rockmonster",
	nodes = {"default:dirtwithgrass1"},
	interval = 1,
	chance = 1,
	active_object_count = 10,
	min_height = 0,
})
end

mobs:register_egg("monsters:testmonster", "Monster", "dirtQ1.png", 1)
mobs:alias_mob("monsters:testmonster", "monsters:testmonster")