# unsafe_require

A Luanti mod that allows trusted Lua module imports without having to give full insecure privileges to a mod.

## Overview

By default, Luanti requires that your mod is added to `secure.trusted_mods` when it needs to use `require()`.
You then also have to implement various safety measurements correctly in order not to create a security risk.
This is quite complicated when a mod only needs to import specific modules.

**unsafe_require** provides a middle ground where you do not need to alter _G.require or apply custom hooks as seen in the insecure environment workaround.

## Features
* Allows (more or less) safe use of require() for specific Lua modules.
* Avoids adding every mod to `secure.trusted_mods`.
* Automatically handles the security precautions described in [luanti-org/luanti#10877](https://github.com/luanti-org/luanti/issues/10877#issuecomment-1060033815) (sandbox sealing, metatable cleanup, isolated loading).
* Easy per-mod configuration through settings.

## Usage in mods
In your mod’s `init.lua` code:

```lua
unsafe_require("lfs", function(lfs)
    -- use lfs here, do not store it where it could be accessible by other mods!
end)
```
Each mod must be explicitly granted permission to use `unsafe_require` for individual module names.

## Configuration
Add this module to `secure.trusted_mods` in minetest.conf:
```secure.trusted_mods = unsafe_require```

Add allowed modules for your mod in minetest.conf:

```unsafe_require.allowed_for.yourmodname = lfs, json```

Only the listed modules may be loaded via `unsafe_require` inside `yourmodname`.
Attempting to request a disallowed module will result in an error.

## Security notes
* This mod still uses Luanti’s insecure environment - but within controlled boundaries.
* It is not safe for untrusted mods – only enable it for mods you trust!
* It is not recommended to use this mod on a public server.
* The main purpose is to provide additional APIs for local development.

## License
SPDX-License-Identifier: MIT
