local S = core.get_translator(core.get_current_modname())

-- TODO: fix recipe for default and add sandbag sound
-- TODO: make model for sandbag?
local sandbag_sound
if core.get_modpath("default") then
	core.register_craft({
		output = "avantisavoia:sandbag",
		recipe = {
			{ "wool:brown", "farming:string", "wool:brown" },
			{ "wool:brown", "default:sand", "wool:brown" },
			{ "wool:brown", "wool:brown", "wool:brown" },
		},
	})
end

if core.get_modpath("mcl_core") then
	sandbag_sound = mcl_sounds.node_sound_sand_defaults()
	sandbag_recipe1 = {
		{ "mcl_mobitems:leather", "mcl_mobitems:string", "mcl_mobitems:leather" },
		{ "mcl_mobitems:leather", "mcl_core:sand", "mcl_mobitems:leather" },
		{ "mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather" },
	}
	sandbag_recipe2 = {
		{ "mcl_mobitems:leather", "mcl_mobitems:string", "mcl_mobitems:leather" },
		{ "mcl_mobitems:leather", "mcl_core:dirt", "mcl_mobitems:leather" },
		{ "mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather" },
	}
	core.register_craft({
		output = "avantisavoia:sandbag",
		recipe = sandbag_recipe1,
	})
	core.register_craft({
		output = "avantisavoia:sandbag",
		recipe = sandbag_recipe2,
	})

	awards.register_achievement("mcl:buildSandbag", {
		title = S("Trench Warfare"),
		description = S("Use a crafting table to craft a sandbag."),
		icon = "default_tool_woodpick.png",
		trigger = {
			type = "craft",
			item = "avantisavoia:sandbag",
			target = 1,
		},
		type = "Advancement",
		group = "Overworld",
	})
end

core.register_node("avantisavoia:sandbag", {
	description = "Sandbag",
	tiles = {
		"default_sand.png^[hsl:-15:-80:-20",
	},
	groups = { handy = 1, shovely = 1, building_block = 1, material_sand = 1 },
	sounds = sandbag_sound,
	_mcl_blast_resistance = 0.5,
	_mcl_hardness = 0.5,
})

core.register_node("avantisavoia:barbed_wire", {
	description = "Barbed Wire",
	_tt_help = S("Barricade") .. "\n" .. minetest.colorize(mcl_colors.YELLOW, "Damages on contact"),
	tiles = {
		"default_coal_block.png",
	},
	groups = {
		shovely = 1,
		attached_node = 1,
		-- sweet_berry_thorny = 1,
		-- stabby = 1,
		wire = 1,
	},
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = false,
	paramtype2 = "meshoptions",
	place_param2 = 3,
	liquid_viscosity = 7,
	liquid_alternative_flowing = "barbed_wire",
	liquid_alternative_source = "barbed_wire",
	liquid_renewable = false,
	liquid_range = 0,
	walkable = false,
	sounds = sandbag_sound,
	_mcl_blast_resistance = 0.5,
	_mcl_hardness = 0.5,
	selection_box = {
		type = "fixed",
		fixed = { -6 / 16, -0.5, -6 / 16, 6 / 16, (-0.30 + (3 * 0.25)), 6 / 16 },
	},
})

-- from Voxelibre sweet_berry code
local function wire_damage_check(obj)
	local p = obj:get_pos()
	if not p then
		return
	end
	if not minetest.find_node_near(p, 0.4, { "group:wire" }, true) then
		return
	end
	local v = obj:get_velocity()
	if math.abs(v.x) < 0.1 and math.abs(v.y) < 0.1 and math.abs(v.z) < 0.1 then
		return
	end
	mcl_util.deal_damage(obj, 2, { type = "wire" })
end

local etime = 0
minetest.register_globalstep(function(dtime)
	etime = dtime + etime
	if etime < 0.5 then
		return
	end
	etime = 0
	for _, pl in pairs(minetest.get_connected_players()) do
		wire_damage_check(pl)
	end
	for _, ent in pairs(minetest.luaentities) do
		if ent.is_mob then
			wire_damage_check(ent.object)
		end
	end
end)
