avantisavoia = {}

local modpath = core.get_modpath("avantisavoia")
local S = core.get_translator(core.get_current_modname())

mod_death_messages = {
	assist = {},
	messages = {
		wire = {
			_translator = S,
			plain = "@1 got stuck in barbed wire",
			assist = "@1 walked into barbed wire whilst fighting @2",
		},
	},
}

mod_damage = {
	modifiers = {},
	damage_callbacks = {},
	death_callbacks = {},
	types = {
		wire = { bypasses_armor = true },
	},
}

if core.get_modpath("mcl_core") then
	minetest.register_on_joinplayer(function(player)
		for k, v in pairs(mod_death_messages.messages) do
			mcl_death_messages.messages[k] = v
		end
		for k, v in pairs(mod_damage.types) do
			mcl_damage.types[k] = v
		end
	end)
end
dofile(modpath .. "/weapons.lua")
dofile(modpath .. "/structures.lua")
dofile(modpath .. "/tools.lua")
