local wield_scale = vector.new(1.8, 1.8, 1)

local S = core.get_translator(core.get_current_modname())

core.register_tool("avantisavoia:bandages", {
	description = S("Bandages"),
	_doc_items_longdesc = "",
	inventory_image = "default_paper.png",
	wield_scale = wield_scale / 2,
	groups = { tool = 1 },
	on_place = function(self, player)
		if core.get_modpath("mcl_core") then
			mcl_potions.healing_func(player, 1)
		else
			hp = player:get_hp()
			player:set_hp(hp + 1)
			-- print(hp)
		end
	end,
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level = 3,
		damage_groups = { fleshy = 3 },
		punch_attack_uses = 66,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "group:leather",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		handy = { speed = 1, level = 0, uses = 0 },
	},
})
