local S = core.get_translator(core.get_current_modname())

-- TODO: fix recipe for default and add sandbag sound
-- TODO: does minetest game have damage types? custom death messages?
local sandbag_sound
if core.get_modpath("default") then
	core.register_craft({
		output = "avantisavoia:sandbag",
		recipe = {
			{ "wool:brown", "farming:string", "wool:brown" },
			{ "wool:brown", "default:sand", "wool:brown" },
			{ "wool:brown", "wool:brown", "wool:brown" },
		},
	})
end

if core.get_modpath("mcl_core") then
	sandbag_sound = mcl_sounds.node_sound_sand_defaults()
	sandbag_recipe1 = {
		{ "mcl_mobitems:leather", "mcl_mobitems:string", "mcl_mobitems:leather" },
		{ "mcl_mobitems:leather", "mcl_core:sand", "mcl_mobitems:leather" },
		{ "mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather" },
	}
	sandbag_recipe2 = {
		{ "mcl_mobitems:leather", "mcl_mobitems:string", "mcl_mobitems:leather" },
		{ "mcl_mobitems:leather", "mcl_core:dirt", "mcl_mobitems:leather" },
		{ "mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather" },
	}
	core.register_craft({
		output = "avantisavoia:sandbag",
		recipe = sandbag_recipe1,
	})
	core.register_craft({
		output = "avantisavoia:sandbag",
		recipe = sandbag_recipe2,
	})

	awards.register_achievement("mcl:buildSandbag", {
		title = S("Trench Warfare"),
		description = S("Use a crafting table to craft a sandbag."),
		icon = "default_tool_woodpick.png",
		trigger = {
			type = "craft",
			item = "avantisavoia:sandbag",
			target = 1,
		},
		type = "Advancement",
		group = "Overworld",
	})
end

core.register_entity("avantisavoia:sandbag_entity", {
	initial_properties = {
		physical = true,
		collide_with_objects = true,
		collisionbox = { -0.5, 0, -0.5, 0.5, 1.5, 0.5 },
		visual = "mesh",
		mesh = "sandbags.obj",
		textures = { "default_sand.png^[hsl:-15:-80:-20" },
		visual_size = { x = 0.75, y = 0.75 },
	},

	on_activate = function(self, staticdata)
		self.object:set_armor_groups({})
	end,

	on_step = function(self, dtime) end,
})

core.register_node("avantisavoia:sandbag", {
	description = "Sandbag",
	drawtype = "mesh",
	mesh = "sandbags.obj",

	tiles = {
		"default_sand.png^[hsl:-15:-80:-20",
	},
	groups = { crumbly = 1 },
	-- groups = { handy = 1, shovely = 1, building_block = 1, material_sand = 1, sand = 1 },
	sounds = sandbag_sound,
	_mcl_blast_resistance = 0.5,
	_mcl_hardness = 0.5,
	on_destruct = function(pos)
		local objs = core.get_objects_inside_radius(pos, 1)
		for _, obj in ipairs(objs) do
			if obj:get_entity_name() == "avantisavoia:sandbag_entity" then
				obj:remove()
				break
			end
		end
	end,
})

core.register_node("avantisavoia:sandbag_bullet", {
	description = "Sandbag (shows bullet holes)",
	drawtype = "mesh",
	mesh = "sandbags_bullet.obj",

	tiles = {
		"default_sand.png^[hsl:-15:-80:-20",
	},
	groups = { crumbly = 1 },
	-- groups = { handy = 1, shovely = 1, building_block = 1, material_sand = 1, sand = 1 },
	sounds = sandbag_sound,
	_mcl_blast_resistance = 0.5,
	_mcl_hardness = 0.5,
	on_destruct = function(pos)
		local objs = core.get_objects_inside_radius(pos, 1)
		for _, obj in ipairs(objs) do
			if obj:get_entity_name() == "avantisavoia:sandbag_entity" then
				obj:remove()
				break
			end
		end
	end,
})

local color = nil
if core.get_modpath("mcl_core") then
	color = mcl_colors.YELLOW
else
	color = "yellow"
end

-- TODO: fix collision and slowness not working on edges
core.register_entity("avantisavoia:wire_entity", {
	initial_properties = {
		physical = true,
		collide_with_objects = true,
		-- collisionbox = { -0.5, 0, -0.5, 0.5, 1.5, 0.5 },
		collisionbox = {
			type = "fixed",
			fixed = { -2, -0.5, -6 / 16, 14 / 16, (-0.30 + (3 * 0.25)), 6 / 16 },
			-- fixed = { 0.7, -0.45, -0.43, 2, 0.45,0.47 },
		},
		visual = "mesh",
		mesh = "wire_entity.obj",
		textures = { "default_coal_block.png" },
		visual_size = { x = 0.75, y = 0.75 },
	},

	on_activate = function(self, staticdata)
		self.object:set_armor_groups({})
	end,

	on_step = function(self, dtime) end,
})

core.register_node("avantisavoia:barbed_wire", {
	description = "Barbed Wire",
	_tt_help = S("Barricade") .. "\n" .. minetest.colorize(color, "Damages on contact"),
	tiles = {
		"default_coal_block.png",
	},
	groups = {
		cracky = 1,
		attached_node = 1,
		wire = 1,
	},
	-- drawtype = "plantlike",
	drawtype = "mesh",
	mesh = "wire.obj",
	paramtype = "light",
	sunlight_propagates = false,
	paramtype2 = "facedir",
	-- paramtype2 = "meshoptions",
	-- place_param2 = 3,
	liquid_viscosity = 7,
	liquid_alternative_flowing = "barbed_wire",
	liquid_alternative_source = "barbed_wire",
	liquid_renewable = false,
	liquid_range = 1,
	walkable = false,
	sounds = sandbag_sound,
	_mcl_blast_resistance = 0.5,
	_mcl_hardness = 4,
	selection_box = {
		type = "fixed",
		fixed = { -2, -0.5, -6 / 16, 14 / 16, (-0.30 + (3 * 0.25)), 6 / 16 },
		-- fixed = { 0.7, -0.45, -0.43, 2, 0.45,0.47 },
	},
	on_rightclick = function(pos, node, clicker)
		if core.get_modpath("mcl_core") then
			mcl_util.deal_damage(clicker, 2, { type = "wire" })
		else
			hp = clicker:get_hp()
			clicker:set_hp(hp - 2)
		end
	end,
	on_leftclick = function(pos, node, clicker)
		if core.get_modpath("mcl_core") then
			mcl_util.deal_damage(clicker, 2, { type = "wire" })
		else
			hp = clicker:get_hp()
			clicker:set_hp(hp - 2)
		end
	end,
	on_destruct = function(pos)
		local objs = core.get_objects_inside_radius(pos, 1)
		for _, obj in ipairs(objs) do
			if obj:get_entity_name() == "avantisavoia:wire_entity" then
				obj:remove()
				break
			end
		end
	end,
	-- 	on_dig = function(self, clicker)
	-- 		print("dig")
	-- end,
})

-- TODO: swap entity?
core.register_node("avantisavoia:barbed_wire_small", {
	description = "Barbed Wire (Small)",
	_tt_help = S("Barricade") .. "\n" .. minetest.colorize(color, "Damages on contact"),
	tiles = {
		"default_coal_block.png",
	},
	groups = {
		cracky = 1,
		attached_node = 1,
		wire = 1,
	},
	-- drawtype = "plantlike",
	drawtype = "mesh",
	mesh = "wire_small.obj",
	paramtype = "light",
	sunlight_propagates = false,
	paramtype2 = "facedir",
	-- paramtype2 = "meshoptions",
	-- place_param2 = 3,
	liquid_viscosity = 7,
	liquid_alternative_flowing = "barbed_wire",
	liquid_alternative_source = "barbed_wire",
	liquid_renewable = false,
	liquid_range = 1,
	walkable = false,
	sounds = sandbag_sound,
	_mcl_blast_resistance = 0.5,
	_mcl_hardness = 4,
	selection_box = {
		type = "fixed",
		fixed = { -1, -0.5, -6 / 16, 8 / 16, (-0.30 + (3 * 0.25)), 6 / 16 },
		-- fixed = { 0.7, -0.45, -0.43, 2, 0.45,0.47 },
	},
	on_rightclick = function(pos, node, clicker)
		if core.get_modpath("mcl_core") then
			mcl_util.deal_damage(clicker, 2, { type = "wire" })
		else
			hp = clicker:get_hp()
			clicker:set_hp(hp - 2)
		end
	end,
	on_leftclick = function(pos, node, clicker)
		if core.get_modpath("mcl_core") then
			mcl_util.deal_damage(clicker, 2, { type = "wire" })
		else
			hp = clicker:get_hp()
			clicker:set_hp(hp - 2)
		end
	end,
	on_destruct = function(pos)
		local objs = core.get_objects_inside_radius(pos, 1)
		for _, obj in ipairs(objs) do
			if obj:get_entity_name() == "avantisavoia:wire_entity" then
				obj:remove()
				break
			end
		end
	end,
	-- 	on_dig = function(self, clicker)
	-- 		print("dig")
	-- end,
})

-- from Voxelibre sweet_berry code
local function wire_damage_check(obj)
	local p = obj:get_pos()
	if not p then
		return
	end
	if not minetest.find_node_near(p, 0.5, { "group:wire" }, true) then
		return
	end
	local v = obj:get_velocity()
	if math.abs(v.x) < 0.1 and math.abs(v.y) < 0.1 and math.abs(v.z) < 0.1 then
		return
	end
	-- mcl_util.deal_damage(obj, 2, { type = "wire" })
	if core.get_modpath("mcl_core") then
		mcl_util.deal_damage(obj, 2, { type = "wire" })
	else
		hp = obj:get_hp()
		obj:set_hp(hp - 2)
	end
end

local etime = 0
minetest.register_globalstep(function(dtime)
	etime = dtime + etime
	if etime < 0.5 then
		return
	end
	etime = 0
	for _, pl in pairs(minetest.get_connected_players()) do
		wire_damage_check(pl)
	end
	for _, ent in pairs(minetest.luaentities) do
		if ent.is_mob then
			wire_damage_check(ent.object)
		end
	end
end)
