# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Project Overview

Too Many Stones is a Minetest/Luanti mod that adds 89+ stone types with support for multiple subgames. The mod uses a modular architecture where different features are loaded conditionally based on available dependencies.

## Architecture

### Core Module Structure
- `init.lua` - Main entry point that loads all other modules via dofile()
- `nodes.lua` - Primary stone node definitions (89+ stone types with variants)
- `nodes_glowing.lua` - Glowing stone variants (7 types)
- `nodes_crystal.lua` - Crystal/budding stone variants
- `mapgen.lua` - World generation integration using climate-based ore registration
- `sounds.lua` - Custom sound definitions for different stone types
- `crafting.lua` - Crafting recipes (mostly placeholder/commented out)

### Optional Feature Modules
- `stairs.lua` - Stairs/slabs integration (requires stairs mod)
- `wall.lua` - Wall integration (requires walls mod)  
- `geodes.lua` / `geodes_lib.lua` - Geode integration (requires geodes/geodes_lib mods)
- `flowstones.lua` - Currently disabled (commented out in init.lua)

### Internationalization
- Translation files in `locale/` directory support 7 languages
- Uses Minetest's built-in translation system with `minetest.get_translator("too_many_stones")`

## Key Development Patterns

### Node Registration
Each stone type follows a consistent pattern with variants:
- Base stone (e.g., `too_many_stones:amazonite`)
- Block variant (`_block` suffix)
- Brick variant (`_brick` suffix) 
- Cracked brick variant (`_cracked_brick` suffix)
- Cobble variant (`_cobble` suffix) where applicable
- Crystal variants for certain stones (`_crystal`, `_budding` suffixes)

### Climate-Based Ore Generation
The mapgen system uses a sophisticated climate-based ore registration that queues ores and processes them after all mods load, allowing for dynamic biome and climate compatibility.

### Conditional Loading
Features are loaded based on mod dependencies using `minetest.get_modpath()` checks within individual modules rather than init.lua.

## Texture Organization
All textures follow the `tms_` prefix naming convention and are stored in the `textures/` directory with consistent naming patterns for variants.

## Sound System
Custom sound definitions in `sounds.lua` provide unique audio for different stone types, with fallbacks to appropriate Minetest game sounds.