-- Queue up ores for later registration after all mods are loaded
-- Kindly provided by EmptyStar
local oreq = {}
local function register_ore_by_climate(ore)
	-- Queue up ore for processing after all mods are loaded
	table.insert(oreq,ore)
end

-- Do actual ore registration based on provided climate data after all mods are loaded
minetest.register_on_mods_loaded(function()
	for _,ore in ipairs(oreq) do
		-- Initialize any missing biome or climate values
		ore.biomes = ore.biomes or {}

		local checksum = 0
		if not ore.heat_min then
			ore.heat_min = -100
			checksum = checksum + 1
		end

		if not ore.heat_max then
			ore.heat_max = 200
			checksum = checksum + 1
		end

		if not ore.humidity_min then
			ore.humidity_min = -100
			checksum = checksum + 1
		end

		if not ore.humidity_max then
			ore.humidity_max = 200
			checksum = checksum + 1
		end

		-- Add matching biomes to ore biome list if any climate data was specified
		if checksum ~= 4 then
			checksum = #ore.biomes
			for name,biome in pairs(minetest.registered_biomes) do
				-- Increment biome checksum
				checksum = checksum + 1

				-- Ensure climate values
				local heat = biome.heat_point or 50
				local humidity = biome.humidity_point or 50

				-- Add biome if climate values match
				if (
					heat >= ore.heat_min and
					heat <= ore.heat_max and
					humidity >= ore.humidity_min and
					humidity <= ore.humidity_max
				) then
					table.insert(ore.biomes,name)
				end
			end
		else
			checksum = #ore.biomes + 1
		end

		-- Don't use an empty biome list or a biome list that contains all biomes
		ore.biomes = #ore.biomes > 0 and #ore.biomes < checksum and ore.biomes or nil

		-- Register ore with Minetest one source node at a time due to an engine timing bug
		local sources = ore.wherein
		for i = 1, #sources do
			ore.wherein = sources[i]
			minetest.register_ore(ore)
		end
	end
end)

-- Generate unique seeds for each stone
local _seed = 12345
local function seed()
	_seed = _seed + 97
	return _seed
end

-- Replace some naturally generated lapis lazuli with pyrite
minetest.register_lbm({
	label = "Replace a fraction of lapis lazuli with pyrite",
	name = "too_many_stones:lapis2pyrite",
	nodenames = {"too_many_stones:lapis_lazuli"},
	run_at_every_load = true,
	action = function(pos,node)
		local coordinate_sum = pos.x ^ 2 + pos.y * 2 + pos.z
		local newnode = "too_many_stones:lapis_lazuli"
		if coordinate_sum % 17 == 4 and node.param2 == 1 then
			newnode = "too_many_stones:pyrite"
		end
		minetest.set_node(pos,{ name = newnode , param2 = 0 })
	end,
})

-- ==========================================
-- GAME DETECTION AND NODE MAPPING
-- ==========================================

-- Detect which game/modpack is running and set up node mappings
local game_nodes = {}
local game_detected = false

if minetest.get_modpath("default") then
	-- Minetest Game, Mesecraft, and others using default mod
	game_nodes = {
		desert_stone = "default:desert_stone",
		sandstone = "default:sandstone",
		desert_sandstone = "default:desert_sandstone", 
		silver_sandstone = "default:silver_sandstone",
		sand = "default:sand",
		silver_sand = "default:silver_sand",
		desert_sand = "default:desert_sand",
		gravel = "default:gravel",
		permafrost = "default:permafrost",
		water_source = "mapgen_water_source"
	}
	game_detected = true
elseif minetest.get_modpath("base_earth") then
	-- Minebase
	game_nodes = {
		desert_stone = "base_earth:desert_stone",
		sandstone = "base_earth:sandstone", 
		desert_sandstone = "base_earth:desert_sandstone",
		silver_sandstone = "base_earth:silver_sandstone",
		sand = "base_earth:sand",
		silver_sand = "base_earth:silver_sand",
		desert_sand = "base_earth:desert_sand",
		gravel = "base_earth:gravel",
		permafrost = "base_earth:permafrost",
		water_source = "mapgen_water_source"
	}
	game_detected = true
elseif minetest.get_modpath("farlands") then
	-- Farlands Reloaded
	game_nodes = {
		desert_stone = "fl_stone:silver_sandstone",
		sandstone = "fl_stone:silver_sandstone", 
		desert_sandstone = "fl_stone:silver_sandstone",
		silver_sandstone = "fl_stone:silver_sandstone",
		sand = "fl_stone:silver_sandstone",
		silver_sand = "fl_stone:silver_sandstone", 
		desert_sand = "fl_stone:silver_sandstone",
		gravel = "fl_stone:silver_sandstone",
		permafrost = "fl_stone:silver_sandstone",
		water_source = "mapgen_water_source"
	}
	game_detected = true
end

-- ==========================================
-- UNIVERSAL STONES (spawn in mapgen_stone only)
-- ==========================================

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:aegirine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 50,
		humidity_min	= 0,
		humidity_max	= 50,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})


	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_blue",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_gray",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_moss",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_orange",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_purple",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_red",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amazonite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite_grey",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 30,
		humidity_min	= 50,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chrysoprase",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chrysoprase",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:covellite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:fluorite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_blue",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 30,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 56,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:kyanite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:lepidolite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 30,
		humidity_min	= 40,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:moonstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:mudstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:rhodonite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:serpentine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:shale",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 40,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:shale",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_paraiba",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_pink",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:aegirine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 50,
		humidity_min	= 0,
		humidity_max	= 50,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})


	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_blue",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_gray",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_moss",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_orange",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_purple",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_red",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amazonite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite_grey",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 30,
		humidity_min	= 50,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chrysoprase",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chrysoprase",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:covellite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:fluorite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_blue",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 30,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 56,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:kyanite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:lepidolite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 30,
		humidity_min	= 40,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:moonstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:mudstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:rhodonite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:serpentine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_paraiba",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_pink",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:aegirine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 50,
		humidity_min	= 0,
		humidity_max	= 50,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})


	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_blue",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_gray",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_moss",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_orange",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_purple",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:agate_red",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amazonite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amber",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amber",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amethyst",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amethyst",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:ammolite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 50,
		heat_max		= 100,
		humidity_min	= 50,
		humidity_max	= 100,
		y_max           = -5,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:andesite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:basalt",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:basalt_columnar",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_moonstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_moonstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite_grey",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 30,
		humidity_min	= 50,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite_orange",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 70,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 50,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

		register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:carnotite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = -300,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:celestine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:citrine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chalcanthite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 80,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = -10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chalcanthite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 80,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = 100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chrysoprase",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chrysoprase",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:covellite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:crocoite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:diorite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 20,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:erythrite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:eudialite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:fluorite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:gabbro",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 20,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:galena",
		ore_param2 = 1,
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:galena",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:geyserite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 58 * 58 * 58,
		clust_size      = 12,
		heat_min		= 40,
		heat_max		= 100,
		humidity_min	= 70,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -200,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:gneiss",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 64 * 64 * 64,
		clust_size      = 8,
		heat_min		= 50,
		heat_max		= 90,
		humidity_min	= 40,
		humidity_max	= 80,
		y_max           = 31000,
		y_min           = -800,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_black",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_blue",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 30,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_gray",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_gray",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 56,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_pink",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_red",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 55,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_white",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_white",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_yellow",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:heliodor",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -30,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:heliodor",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = -30,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:howlite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:ilvaite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jade",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jade",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jasper_red",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 20,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:kyanite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:lapis_lazuli",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 80 * 48 * 80,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		ore_param2 = 1,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:lepidolite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 30,
		humidity_min	= 40,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:limestone_blue",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:limestone_white",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:marble",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:moonstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:morion_quartz",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:mudstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_opal",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:fire_opal",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:opal",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:picture_jasper",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:prasiolite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 50,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pumice",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pyrite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 48 * 48 * 48,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -40,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:quartz",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:quartz",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:rhodonite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:rose_quartz",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:scoria",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:serpentine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:shale",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 40,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:shale",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:slate",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:slate",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:smokey_quartz",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:soapstone",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 0,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sodalite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sugilite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 30,
		y_min           = -2000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sugilite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 30,
		y_min           = -2000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_green",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_paraiba",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tourmaline_pink",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 20,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine_yellow",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_beige",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_grey",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_red",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:turquoise",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 15,
		heat_min		= 20,
		heat_max		= 60,
		humidity_min	= 20,
		humidity_max	= 60,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 61,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:vivianite",
		wherein         = {"mapgen_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})


-- ==========================================
-- GAME-SPECIFIC STONES
-- ==========================================

-- Only register game-specific stones if a supported game is detected
if game_detected then

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amber",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amber",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amethyst",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amethyst",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:ammolite",
		wherein         = {"mapgen_stone", game_nodes.sand},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 50,
		heat_max		= 100,
		humidity_min	= 50,
		humidity_max	= 100,
		y_max           = -5,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:andesite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:basalt",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:basalt_columnar",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_moonstone",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_moonstone",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite",
		wherein         = {game_nodes.sand, game_nodes.silver_sand},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 0,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite_orange",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 70,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 50,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

		register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:carnotite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = -300,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:celestine",
		wherein         = {game_nodes.silver_sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:citrine",
		wherein         = {game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chalcanthite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 80,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = -10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chalcanthite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 80,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = 100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:crocoite",
		wherein         = {"mapgen_stone",game_nodes.desert_stone,game_nodes.sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:diorite",
		wherein         = {"mapgen_stone",game_nodes.desert_stone,game_nodes.sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 20,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:erythrite",
		wherein         = {"mapgen_stone",game_nodes.desert_stone,game_nodes.sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:eudialite",
		wherein         = {"mapgen_stone",game_nodes.desert_stone,game_nodes.sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:gabbro",
		wherein         = {"mapgen_stone",game_nodes.desert_stone,game_nodes.sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 20,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:galena",
		ore_param2 = 1,
		wherein         = {"mapgen_stone", game_nodes.sandstone, game_nodes.desert_sandstone, game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:galena",
		wherein         = {"mapgen_stone", game_nodes.sandstone, game_nodes.desert_sandstone, game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:geyserite",
		wherein         = {"mapgen_stone", game_nodes.silver_sand},
		clust_scarcity  = 58 * 58 * 58,
		clust_size      = 12,
		heat_min		= 40,
		heat_max		= 100,
		humidity_min	= 70,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -200,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:gneiss",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 64 * 64 * 64,
		clust_size      = 8,
		heat_min		= 50,
		heat_max		= 90,
		humidity_min	= 40,
		humidity_max	= 80,
		y_max           = 31000,
		y_min           = -800,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_black",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_gray",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_gray",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_pink",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_red",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 55,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_white",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_white",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_yellow",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:heliodor",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -30,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:heliodor",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = -30,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:howlite",
		wherein         = {"mapgen_stone", game_nodes.silver_sandstone, game_nodes.desert_sandstone, game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:ilvaite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone, game_nodes.permafrost},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jade",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jade",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jasper_red",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 20,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:kyanite",
		wherein         = {game_nodes.silver_sand},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:lapis_lazuli",
		wherein         = {game_nodes.sandstone, game_nodes.desert_stone, game_nodes.silver_sandstone},
		clust_scarcity  = 80 * 48 * 80,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		ore_param2 = 1,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:limestone_blue",
		wherein         = {"mapgen_stone", game_nodes.sand, game_nodes.desert_sand},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:limestone_white",
		wherein         = {"mapgen_stone", game_nodes.silver_sand},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:marble",
		wherein         = {"mapgen_stone", game_nodes.sandstone, game_nodes.silver_sandstone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:morion_quartz",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:morion_quartz",
		wherein         = {game_nodes.sand, game_nodes.silver_sand, game_nodes.desert_sand},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = -2,
		y_min           = -50,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_opal",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:fire_opal",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:opal",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:picture_jasper",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:prasiolite",
		wherein         = {"mapgen_stone", game_nodes.silver_sandstone, game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 50,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:prasiolite",
		wherein         = {game_nodes.sand, game_nodes.silver_sand, game_nodes.desert_sand},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = -2,
		y_min           = -50,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pumice",
		wherein         = {"mapgen_stone", game_nodes.gravel, game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pumice",
		wherein         = {game_nodes.water_source},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		y_max           = 31000,
		y_min           = -1,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pyrite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 48 * 48 * 48,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -40,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pyrite",
		wherein         = {game_nodes.sandstone, game_nodes.desert_stone, game_nodes.silver_sandstone},
		clust_scarcity  = 80 * 48 * 80,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:quartz",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:quartz",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:quartz",
		wherein         = {game_nodes.sand, game_nodes.silver_sand, game_nodes.desert_sand},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = -2,
		y_min           = -50,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:rose_quartz",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:rose_quartz",
		wherein         = {game_nodes.sand, game_nodes.silver_sand, game_nodes.desert_sand},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = -2,
		y_min           = -50,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:scoria",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:slate",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:slate",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:smokey_quartz",
		wherein         = {game_nodes.sandstone, game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:soapstone",
		wherein         = {game_nodes.sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:soapstone",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 0,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sodalite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sugilite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 30,
		y_min           = -2000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sugilite",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 30,
		y_min           = -2000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine",
		wherein         = {game_nodes.sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 30,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine_yellow",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_beige",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_grey",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_red",
		wherein         = {"mapgen_stone", game_nodes.desert_stone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sandstone_with_turquoise",
		wherein         = {game_nodes.sandstone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 15,
--		heat_min		= 20,
--		heat_max		= 60,
--		humidity_min	= 20,
--		humidity_max	= 60,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 61,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:desert_sandstone_with_turquoise",
		wherein         = {game_nodes.desert_sandstone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 15,
--		heat_min		= 20,
--		heat_max		= 60,
--		humidity_min	= 20,
--		humidity_max	= 60,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 61,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:silver_sandstone_with_turquoise",
		wherein         = {game_nodes.silver_sandstone},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 15,
--		heat_min		= 20,
--		heat_max		= 60,
--		humidity_min	= 20,
--		humidity_max	= 60,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 61,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:vivianite",
		wherein         = {"mapgen_stone", game_nodes.silver_sandstone},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amber",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amber",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amethyst",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:amethyst",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:ammolite",
		wherein         = {"mapgen_stone", "base_earth:sand"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 50,
		heat_max		= 100,
		humidity_min	= 50,
		humidity_max	= 100,
		y_max           = -5,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:andesite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:basalt",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:basalt_columnar",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_moonstone",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_moonstone",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite",
		wherein         = {"base_earth:sand", "base_earth:silver_sand"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 0,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:calcite_orange",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 10,
		heat_min		= 70,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 50,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

		register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:carnotite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = -300,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:celestine",
		wherein         = {"base_earth:silver_sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:citrine",
		wherein         = {"base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chalcanthite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 80,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = -10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:chalcanthite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 80,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = 100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:crocoite",
		wherein         = {"mapgen_stone","base_earth:desert_stone","base_earth:sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:diorite",
		wherein         = {"mapgen_stone","base_earth:desert_stone","base_earth:sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 20,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:erythrite",
		wherein         = {"mapgen_stone","base_earth:desert_stone","base_earth:sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:eudialite",
		wherein         = {"mapgen_stone","base_earth:desert_stone","base_earth:sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:gabbro",
		wherein         = {"mapgen_stone","base_earth:desert_stone","base_earth:sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 20,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:galena",
		ore_param2 = 1,
		wherein         = {"mapgen_stone", "base_earth:sandstone", "base_earth:desert_sandstone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:galena",
		wherein         = {"mapgen_stone", "base_earth:sandstone", "base_earth:desert_sandstone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:geyserite",
		wherein         = {"mapgen_stone", "base_earth:silver_sand"},
		clust_scarcity  = 58 * 58 * 58,
		clust_size      = 12,
		heat_min		= 40,
		heat_max		= 100,
		humidity_min	= 70,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -200,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:gneiss",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 64 * 64 * 64,
		clust_size      = 8,
		heat_min		= 50,
		heat_max		= 90,
		humidity_min	= 40,
		humidity_max	= 80,
		y_max           = 31000,
		y_min           = -800,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_black",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_gray",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_gray",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_pink",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_red",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 55,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_white",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_white",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:granite_yellow",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 10,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:heliodor",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -30,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:heliodor",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = -30,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:howlite",
		wherein         = {"mapgen_stone", "base_earth:silver_sandstone", "base_earth:desert_sandstone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:ilvaite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone", "base_earth:permafrost"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -100,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jade",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jade",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:jasper_red",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 20,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:kyanite",
		wherein         = {"base_earth:silver_sand"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:lapis_lazuli",
		wherein         = {"base_earth:sandstone", "base_earth:desert_stone", "base_earth:silver_sandstone"},
		clust_scarcity  = 80 * 48 * 80,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		ore_param2 = 1,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:limestone_blue",
		wherein         = {"mapgen_stone", "base_earth:sand", "base_earth:desert_sand"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:limestone_white",
		wherein         = {"mapgen_stone", "base_earth:silver_sand"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -300,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:marble",
		wherein         = {"mapgen_stone", "base_earth:sandstone", "base_earth:silver_sandstone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -500,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 50,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:morion_quartz",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:morion_quartz",
		wherein         = {"base_earth:sand", "base_earth:silver_sand", "base_earth:desert_sand"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = -2,
		y_min           = -50,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:black_opal",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:fire_opal",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:opal",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:picture_jasper",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 80 * 80 * 80,
		clust_size      = 4,
		y_max           = -1000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:prasiolite",
		wherein         = {"mapgen_stone", "base_earth:silver_sandstone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 50,
		y_min           = -1000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:prasiolite",
		wherein         = {"base_earth:sand", "base_earth:silver_sand", "base_earth:desert_sand"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = -2,
		y_min           = -50,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pumice",
		wherein         = {"mapgen_stone", "base_earth:gravel", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pumice",
		wherein         = {game_nodes.water_source},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		y_max           = 31000,
		y_min           = -1,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pyrite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 48 * 48 * 48,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -40,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pyrite",
		wherein         = {"base_earth:sandstone", "base_earth:desert_stone", "base_earth:silver_sandstone"},
		clust_scarcity  = 80 * 48 * 80,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:quartz",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:quartz",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:quartz",
		wherein         = {"base_earth:sand", "base_earth:silver_sand", "base_earth:desert_sand"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = -2,
		y_min           = -50,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:rose_quartz",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = -300,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:rose_quartz",
		wherein         = {"base_earth:sand", "base_earth:silver_sand", "base_earth:desert_sand"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = -2,
		y_min           = -50,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:scoria",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:slate",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:slate",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:smokey_quartz",
		wherein         = {"base_earth:sandstone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 40,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:soapstone",
		wherein         = {"base_earth:sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:soapstone",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 0,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sodalite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 40,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sugilite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 30,
		y_min           = -2000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sugilite",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 68 * 68 * 68,
		clust_size      = 7,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 30,
		y_min           = -2000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 70 * 70 * 70,
		clust_size      = 14,
		heat_min		= 41,
		heat_max		= 59,
		humidity_min	= 41,
		humidity_max	= 59,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine",
		wherein         = {"base_earth:sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 30,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:travertine_yellow",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_beige",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_grey",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:tuff_red",
		wherein         = {"mapgen_stone", "base_earth:desert_stone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 14,
		heat_min		= 60,
		heat_max		= 100,
		humidity_min	= 0,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:sandstone_with_turquoise",
		wherein         = {"base_earth:sandstone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 15,
--		heat_min		= 20,
--		heat_max		= 60,
--		humidity_min	= 20,
--		humidity_max	= 60,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 61,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:desert_sandstone_with_turquoise",
		wherein         = {"base_earth:desert_sandstone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 15,
--		heat_min		= 20,
--		heat_max		= 60,
--		humidity_min	= 20,
--		humidity_max	= 60,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 61,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:silver_sandstone_with_turquoise",
		wherein         = {"base_earth:silver_sandstone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 15,
--		heat_min		= 20,
--		heat_max		= 60,
--		humidity_min	= 20,
--		humidity_max	= 60,
		y_max           = 300,
		y_min           = -60,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = 61,
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:vivianite",
		wherein         = {"mapgen_stone", "base_earth:silver_sandstone"},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 7,
		heat_min		= 0,
		heat_max		= 100,
		humidity_min	= 60,
		humidity_max	= 100,
		y_max           = 31000,
		y_min           = -31000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})

	register_ore_by_climate({
		ore_type        = "blob",
		ore             = "too_many_stones:pumice",
		wherein         = {game_nodes.water_source},
		clust_scarcity  = 72 * 72 * 72,
		clust_size      = 10,
		y_max           = 31000,
		y_min           = -1,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			octaves = 1,
			persist = 0.0,
			seed = seed(),
		},
	})


end