# Nebula Combat

A knockback customizer mod for Luanti, intended for competative servers.

Additional features:
- Modify how far away players can be hit from
- Make the attack interval a constant rate
- Apply a damage multiplier

## Optional Dependencies

You can optionally affect the knockback based on if the attacker is sprinting. The mods below can be used for sprint detection:

[Stamina](https://content.minetest.net/packages/sofar/stamina/)\*  
[Stamina (Fork)](https://content.minetest.net/packages/TenPlus1/stamina/)  
[Hbsprint](https://content.minetest.net/packages/texmex/hbsprint/) with [Player Monoids](https://content.minetest.net/packages/Byakuren/player_monoids/)  
[Wadsprint](https://content.minetest.net/packages/drkwv/minetest_wadsprint/)  
[Stamina++](https://content.minetest.net/packages/swagtoy/real_stamina/)\*  
[Sprint Lite](https://content.minetest.net/packages/mt-mods/sprint_lite/)

\* Items marked with a star don't work with a speed or gravity multipler

The following mods can be used for more reliable knockback physics multipliers:

[Player Monoids](https://content.minetest.net/packages/Byakuren/player_monoids/)\*  
[Player Physics API](https://content.minetest.net/packages/Wuzzy/playerphysics/)  
[Player Physics API with Monoid Support](https://content.minetest.net/packages/TestificateMods/playerphysics/)

**INCOMPATIBLE:** Despite using [Pova](https://content.minetest.net/packages/TenPlus1/pova/)*'s API when available, multipliers don't work at all with support enabled, and gravity and speed don't work with support disabled

\* Items marked with a star require a config change and do not support changing air acceleration

## Developer API

```lua
nebula_combat.register_on_knockback(function(player, hitter, time_from_last_punch, tool_capabilities, dir, distance, damage)
    -- Values that are not provided, like the vertical values in this example, will be the default from the config (or what another mod gives)
    return {
        horizontal_momentum = 0.0,
        horizontal_force = 15.0,
        physics_duration = 3 -- How long to apply physics multipliers like speed, gravity, and air accel
        gravity_mult = 0.2
    }
end)
```

```lua
-- This API exists so sprint mods can add support if it isn't built-in
-- This API does not affect the player in any way, it simply marks them as sprinting for our detections
-- The id should be your mod id
nebula_combat.set_sprinting(player, sprinting, id)
```

```lua
nebula_combat.is_sprinting(player)
```
