-- Invector, License MIT, Author Jordach

local track_def = {
	grid_pos_offset = vector.new(4,8,4),
	
	track_data = {},
	
	music = "the_rush_of_eternity",
	crescendo_music = "the_ravers_of_eternity",
	
	track_icon_model = "default_kart.b3d",
	track_icon_materials = "blue_kart_neo.png,blue_skin.png,transparent.png,transparent.png",
	track_icon_rotation = "-15,0",
	track_icon_animation = "{0,0}",
	track_name = "Testing Track",
	track_button = "test_track",


	track_num_laps = 3,
	track_num_waypoints = 11,

	track_mapblocks_size_min = vector.new(1,1,1),
	track_mapblocks_size_max = vector.new(3,1,3)
}

track_def.track_data = minetest.deserialize([[return{{{{["nodes"]={{1,160},{2,96},{1,129},{3,5},{1,11},{2,111},{1,129},3,3,3,3,{1,12},{2,111},{1,129},3,3,3,{1,13},{2,111},{1,129},3,3,{1,14},2,2,2,4,{2,107},{1,129},3,3,{1,14},{2,6},4,{2,104},{1,129},3,3,{1,14},{5,12},{2,99},{1,129},3,3,{1,14},{5,12},{2,99},{1,129},3,3,{1,14},2,2,2,4,2,2,2,2,1,1,1,{2,100},{1,129},3,3,{1,14},{2,6},4,2,1,1,1,{2,100},{1,129},3,3,{1,14},{2,8},1,1,1,6,6,6,6,{2,96},{1,129},3,3,{1,14},{2,8},1,1,1,6,6,6,6,{2,96},{1,129},3,3,{1,14},2,2,2,4,2,2,2,2,1,{2,102},{1,129},3,3,{1,14},{2,6},4,2,1,{2,102},{1,129},3,3,{1,14},{2,8},1,{2,102},{1,129},3,3,{1,14},{2,8},1,{2,102}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","air","invector:eternity_grass","invector:starting_grid_marker","invector:waypoint_9","invector:waypoint_8"}},{["nodes"]={{1,129},2,2,{1,14},3,3,3,4,3,3,3,3,1,{3,102},{1,129},2,2,{1,14},{3,6},4,3,1,{3,102},{1,129},2,2,{1,14},{5,8},1,{3,102},{1,129},2,2,{1,14},{5,8},1,{3,102},{1,129},2,2,{1,14},3,3,3,4,3,3,3,3,1,{3,102},{1,129},2,2,{1,14},{3,6},4,3,1,{3,102},{1,129},2,2,{1,14},{3,8},1,{3,102},{1,129},2,2,{1,14},{3,8},1,6,6,1,1,6,6,{3,96},{1,129},2,2,{1,14},3,3,3,4,3,3,3,3,1,6,6,1,1,6,6,{3,96},{1,129},2,2,{1,14},{3,6},4,3,1,{3,102},{1,129},2,2,{1,14},{3,8},1,{3,102},{1,129},2,2,{1,14},{3,8},1,{3,102},{1,129},2,2,{1,14},{7,8},1,{3,102},{1,129},2,2,{1,14},{7,8},1,{3,102},{1,129},2,2,{1,14},{3,8},1,{8,6},{3,96},{1,129},2,2,{1,14},{9,8},1,{8,6},{3,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","invector:eternity_grass","air","invector:starting_grid_marker","invector:waypoint_10","invector:waypoint_7","invector:waypoint_11","invector:waypoint_6","invector:sector_marker"}},{["nodes"]={{1,129},2,2,{1,14},{3,8},1,{3,102},{1,129},2,2,{1,14},{3,8},1,{3,102},{1,129},2,2,{1,14},{3,8},1,{3,6},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},{1,129},2,2,{1,14},{3,8},1,{3,6},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},{1,129},2,2,{1,14},{3,8},1,{3,6},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},{1,129},2,2,{1,14},{4,8},1,{3,6},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},{1,129},2,2,{1,14},{4,8},{1,8},{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},{1,129},2,2,{1,14},{3,9},5,5,3,3,3,3,1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},{1,129},2,2,{1,14},{3,9},5,5,3,3,3,3,1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},1,{3,15},{1,129},2,2,{1,14},{3,9},5,5,{3,100},{1,129},2,2,{1,14},{3,9},5,5,{3,100},{1,129},2,2,{1,14},{3,9},5,5,{3,100},{1,129},2,2,2,{1,13},{3,9},5,5,{3,100},{1,129},{2,15},1,{3,9},5,5,{3,100},{1,129},{2,15},1,{3,9},5,5,{3,100},{1,160},{3,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","invector:eternity_grass","air","invector:waypoint_1","invector:waypoint_2"}}}},{{{["nodes"]={{1,160},{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","air"}},{["nodes"]={{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,145},{2,14},1,{2,96},{1,160},{2,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","air"}},{["nodes"]={{1,138},{2,5},1,1,1,{3,12},4,1,{3,96},{1,139},2,2,2,2,1,1,1,{3,11},4,4,1,{3,96},{1,140},2,2,2,1,5,5,{3,10},4,4,3,1,{3,96},{1,141},2,2,1,5,5,{3,9},4,4,3,3,1,{3,96},{1,141},2,2,1,5,5,{3,8},4,4,3,3,3,1,{3,96},{1,141},2,2,1,5,5,{3,7},4,4,3,3,3,3,1,{3,96},{1,141},2,2,{1,10},4,{3,5},1,{3,96},{1,141},2,2,1,{3,7},1,1,{3,6},1,{3,96},{1,141},2,2,1,{3,7},1,1,{3,6},1,{3,96},{1,141},2,2,1,{3,7},6,6,{3,6},1,{3,96},{1,141},2,2,1,{3,7},6,6,{3,6},1,{3,96},{1,141},2,2,1,{3,7},6,6,{3,6},1,{3,96},{1,140},2,2,2,1,{3,7},6,6,{3,6},1,{3,96},{1,128},{2,15},1,{3,7},6,6,{3,6},1,{3,96},{1,128},{2,15},1,{3,7},6,6,{3,6},1,{3,96},{1,160},{3,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","invector:eternity_grass","air","invector:waypoint_4","invector:waypoint_5","invector:waypoint_3"}}}},{{{["nodes"]={{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","air"}},{["nodes"]={{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","air"}},{["nodes"]={{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112},{1,144},{2,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"solarsail:wireframe","air"}}}}}]])

--invector.game.register_track("test_track", track_def)

local circ_demo = {
	grid_pos_offset = vector.new(21,9,18),
	
	track_data = {},
	
	music = "the_rush_of_eternity",
	crescendo_music = "the_rush_of_eternity",
	
	track_icon_model = "item_sand.b3d",
	track_icon_materials = "solarsail_wireframe.png",
	track_icon_rotation = "-15,0",
	track_icon_animation = "{0,0}",
	track_name = "Circuit 'l Demonstrata",
	track_button = "circ_demo",


	track_num_laps = 3,
	track_num_waypoints = 18,

	track_mapblocks_size_min = vector.new(1,1,1),
	track_mapblocks_size_max = vector.new(7,2,7)
}

circ_demo.track_data = minetest.deserialize([[return{{{{["nodes"]={{1,128},{2,16},{1,240},{2,5},{3,11},{1,11},{2,5},{1,11},{4,5},{1,11},{4,5},{1,11},{4,5},{1,11},{4,5},{1,11},{4,5},{1,11},{4,5},{1,128},{2,5},{3,11},{1,10},2,1,5,5,{1,12},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,133},{2,5},{3,11},{1,9},2,1,1,1,5,5,{1,10},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,134},{2,5},{3,11},{1,8},2,{1,5},5,5,{1,8},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,6},5,{1,8},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,7}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:waypoint_17"}},{["nodes"]={{1,128},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{5,7},{1,8},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{5,7},{1,8},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,7}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:waypoint_18"}},{["nodes"]={{1,128},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{5,7},{1,8},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{5,7},{1,8},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,135},{2,5},{3,11},{1,8},2,{6,7},{1,8},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,7}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:sector_marker","invector:waypoint_1"}},{["nodes"]={{1,128},{2,9},{3,7},{2,9},{4,7},{5,9},{1,7},{5,9},{1,7},{5,9},{1,7},{5,9},{1,7},{5,9},{1,7},{5,9},{1,135},2,{3,15},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,14},2,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,14},2,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,13},2,2,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,12},2,2,2,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,11},{2,5},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,9},{2,7},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,6},{2,10},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,5},{2,11},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,3,3,{2,12},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,3,{2,13},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,{2,14},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,{2,14},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,{2,14},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,{2,14},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:waypoint_1","invector:invisible_wall"}},{["nodes"]={{1,128},2,3,{2,15},{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,143},2,3,{2,15},{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,143},2,3,{2,15},{5,7},{1,8},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,143},2,3,{2,15},{5,8},{1,7},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,143},2,3,{2,8},{3,6},2,{1,7},5,5,5,{1,5},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,143},2,3,{2,7},{3,7},2,{1,8},5,5,5,1,1,1,1,4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,143},2,3,{2,7},{3,7},2,{1,10},5,5,1,1,1,4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,143},2,3,{2,7},3,3,3,{2,5},{1,11},2,2,2,2,4,{1,11},{4,5},{1,11},{4,5},{1,11},{4,5},{1,11},{4,5},{1,11},{4,5},{1,11},4,4,4,4,{1,128},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,{1,131},2,3,2,2,6,2,6,2,6,3,3,3,{2,5},{1,11},2,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,{1,131},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,{1,131},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,{1,131},2,3,2,6,2,6,2,6,2,3,3,3,{2,5},{1,11},2,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,{1,131},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,{1,131},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,{1,131},2,3,{2,7},3,3,3,{2,5},{7,11},2,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1,4,{1,11},4,1,1,1},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:waypoint_2","invector:item_pad_online","invector:waypoint_3"}},{["nodes"]={{1,128},2,3,{2,7},3,3,3,{2,5},{4,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,7},3,3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,2,6,6,2,2,6,6,2,3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{1,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{7,11},2,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,1,1,1,5,{1,11},5,{1,131},2,3,{2,8},3,3,{2,5},{7,11},2,2,2,2,5,{1,11},{5,5},{1,11},{5,5},{1,11},{5,5},{1,11},{5,5},{1,11},{5,5},{1,11},5,5,5,5,{1,128},2,3,{2,8},{3,6},2,{1,12},8,8,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:waypoint_3","invector:invisible_wall","invector:boost_pad","invector:waypoint_4","invector:waypoint_5"}},{["nodes"]={{1,128},2,3,{2,9},{3,5},2,{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,10},3,3,3,3,2,{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,15},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,15},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,15},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,15},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,15},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,15},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,15},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,{2,15},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,{2,14},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,{2,14},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,3,3,3,3,{2,12},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,6},{2,5},3,3,3,3,2,{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},2,{3,15},2,{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},{2,32},{5,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:waypoint_5","invector:invisible_wall"}}},{{["nodes"]={{1,267},{2,5},{1,11},{2,5},{1,11},{2,5},{1,11},{2,5},{1,11},{2,5},{1,186},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,183}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,8},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,183}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,8},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,183}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,9},{2,7},{1,9},{2,7},{1,9},{2,7},{1,9},{2,7},{1,9},{2,183},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"invector:invisible_wall","air"}},{["nodes"]={1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,11},{1,5},{2,11},{1,5},{2,11},{1,5},{2,11},{1,5},{2,11},1,1,1,1,{2,176},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"invector:invisible_wall","air"}},{["nodes"]={1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,2,2,2,1,{2,11},1,{2,179},1,{2,11},{1,5},{2,11},{1,5},{2,11},{1,5},{2,11},{1,5},{2,11},1,1,1,1,{2,176},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"invector:invisible_wall","air"}},{["nodes"]={1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},{1,80},{2,176}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"invector:invisible_wall","air"}}}},{{{["nodes"]={{1,128},{2,16},{1,240},{3,16},{2,16},{4,96},{1,128},{3,16},{1,240},{3,16},{1,240},{3,16},{1,240},{3,16},5,{1,239},{3,8},{2,8},5,5,{1,238},{3,6},{2,10},1,5,5,{1,237},3,3,3,3,{2,12},1,1,5,5,{1,236},3,3,3,{2,13},1,1,1,5,5,{1,235},3,3,{2,14},1,1,1,1,5,5,{1,234},3,3,{2,14},{1,5},5,5,{1,233},3,{2,15},{1,6},5,5,{1,232},3,{2,15},{1,7},5,5,{1,231},{2,16},{1,8},5,5,{1,230},{2,16},{1,9},5,5,{1,101}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:waypoint_17"}},{["nodes"]={{1,128},{2,16},{1,10},3,3,{1,228},{2,15},4,{1,11},3,3,{1,227},{2,13},4,4,4,{1,5},5,{1,6},3,3,{1,226},{2,13},4,4,4,{1,8},5,1,1,1,1,3,3,{1,225},{2,12},4,4,4,4,{1,14},3,3,{1,224},{2,12},4,4,4,4,{1,15},3,{1,224},{2,12},4,4,4,4,{1,5},5,{1,234},{2,12},4,4,4,4,{1,8},5,{1,231},{2,12},4,4,4,4,{1,240},{2,12},4,4,4,4,{1,240},{2,12},4,4,4,4,{1,5},5,{1,234},{2,12},4,4,4,4,{1,8},5,{1,231},{2,12},4,4,4,4,{6,16},{1,224},{2,12},4,4,4,4,{6,16},{1,224},{2,12},4,4,4,4,{1,5},5,{1,234},{2,13},4,4,4,{1,8},5,{1,103}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:waypoint_17","invector:eternity_grass","invector:starting_grid_marker","invector:waypoint_18"}},{["nodes"]={{1,128},{2,13},3,3,3,{1,240},{2,13},3,3,3,{1,240},{2,14},3,3,{1,5},4,{1,234},{2,14},3,3,{1,8},4,{1,231},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,14},3,3,{1,5},4,{1,234},{2,14},3,3,{1,8},4,{1,231},{2,14},3,3,{5,16},{1,224},{2,14},3,3,{5,16},{1,224},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,14},3,3,{6,16},{1,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:starting_grid_marker","invector:sector_marker","invector:waypoint_1"}},{["nodes"]={{1,128},{2,14},3,3,{4,16},{1,224},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,14},3,3,{1,240},{2,13},3,3,3,{1,240},{2,13},3,3,3,{1,240},{2,13},3,3,3,{1,240},{2,12},3,3,3,3,{1,240},{2,12},3,3,3,3,{1,240},{2,12},3,3,3,3,{1,240},{2,12},3,3,3,3,{1,240},{2,11},{3,5},{1,240},{2,10},{3,6},{1,240},{2,9},{3,7},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:waypoint_1"}},{["nodes"]={{1,128},{2,8},{3,8},{1,240},{2,7},{3,9},{1,240},2,2,2,{3,13},{1,240},{3,16},{1,240},{3,16},{1,240},{3,16},{1,240},{3,16},{1,240},{2,32},{4,96},{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,32},{3,96},{1,128},{4,16},{1,15},5,{1,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:invisible_wall","invector:eternity_grass","invector:waypoint_6"}},{["nodes"]={{1,128},{2,16},{1,15},3,{1,224},2,2,2,{4,13},{1,15},3,{1,224},{4,11},1,1,1,4,4,{1,15},3,{1,224},4,4,5,{4,8},1,6,1,4,4,{1,15},3,{1,224},{4,11},1,1,1,4,4,{1,15},3,{1,224},4,4,5,{4,13},{1,15},3,{1,224},{4,16},{1,15},4,{1,224},4,4,5,{4,13},{1,15},4,{1,224},{4,16},{1,15},4,{1,224},4,4,5,{4,13},{1,15},3,{1,224},{4,11},1,1,1,4,4,{1,15},3,{1,224},4,4,5,{4,8},1,6,1,4,4,{1,15},3,{1,224},{4,11},1,1,1,4,4,{1,15},3,{1,224},2,2,2,{4,13},{1,15},3,{1,224},{2,16},{1,15},3,{1,224},{4,32},{7,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:eternity_grass","invector:waypoint_6","solarsail:wireframe","invector:item_pad_online","invector:boost_pad_mega","invector:invisible_wall"}}},{{["nodes"]={{1,256},{2,80},{1,3760}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,1792},{2,80},{1,2224}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,3584},{2,80},{1,432}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,3840},{2,80},{1,176}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}}}},{{{["nodes"]={{1,128},{2,16},{1,240},{3,16},{2,16},{4,96},{1,128},{3,16},1,1,1,1,5,5,{1,7},6,6,{1,225},{3,16},1,1,1,1,5,5,{1,7},6,6,{1,225},{3,16},1,1,1,1,5,5,{1,7},6,6,{1,225},{3,16},1,1,1,1,5,5,{1,7},6,6,{1,225},{2,16},1,1,1,1,5,5,{1,7},6,6,{1,225},{2,11},7,2,2,2,2,1,1,1,1,5,5,{1,7},6,6,{1,225},{2,11},7,2,2,2,2,1,1,1,1,5,5,{1,7},6,6,{1,225},{2,16},1,1,1,1,5,5,{1,7},6,6,{1,225},{2,11},8,2,2,2,2,1,1,1,1,5,5,{1,7},6,6,{1,225},{2,11},8,2,2,2,2,1,1,1,1,5,5,{1,7},6,6,{1,225},{2,16},1,1,1,1,5,5,{1,7},6,6,{1,225},{2,11},7,2,2,2,2,1,1,1,1,5,5,{1,7},6,6,{1,225},{2,11},7,2,2,2,2,1,1,1,1,5,5,{1,7},6,6,{1,225},2,2,2,3,3,3,3,{2,9},1,1,1,1,5,5,{1,7},6,6,{1,97}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:waypoint_16","invector:waypoint_15","invector:boost_pad","invector:item_pad_online"}},{["nodes"]={{1,128},2,{3,8},{2,7},1,1,1,1,4,4,{1,7},5,5,{1,225},{3,16},1,1,1,1,4,4,{1,7},5,5,{1,225},{3,16},1,1,1,1,4,4,{1,7},5,5,{1,225},{3,16},1,1,1,1,4,4,{1,7},5,5,{1,225},{3,16},1,1,1,1,4,4,{1,7},5,5,{1,225},{2,15},3,{2,15},6,{7,15},1,{7,15},1,{7,15},1,{7,15},1,{7,15},1,{7,15},{1,129},{2,15},3,2,{1,13},2,6,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,{1,129},{2,15},3,2,{1,13},2,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1,7,{1,13},7,1},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:waypoint_16","invector:waypoint_15","invector:waypoint_14","invector:invisible_wall"}},{["nodes"]={{1,128},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},3,2,{1,13},2,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,1,4,{1,13},4,{1,129},{2,15},5,2,{1,13},2,2,4,{1,13},4,4,4,{1,13},4,4,4,{1,13},4,4,4,{1,13},4,4,4,{1,13},4,4,4,{1,13},4,4},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:starting_grid_marker"}},{["nodes"]={{1,128},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:invisible_wall"}},{["nodes"]={{1,128},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,17},{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,143},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:invisible_wall"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,32},{3,96},{1,128},{4,16},5,{1,111}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:invisible_wall","invector:eternity_grass","invector:waypoint_6"}},{["nodes"]={{1,128},{2,16},3,{1,239},{4,16},3,{1,239},{4,16},3,{1,239},{4,16},3,{1,239},{4,16},3,{1,239},{4,16},3,{1,239},{4,17},{1,239},{4,17},{1,239},{4,17},{1,239},{4,16},3,{1,239},{4,16},3,{1,239},{4,16},3,{1,239},{4,16},3,{1,239},{4,16},3,{1,239},{2,16},3,{1,239},{4,32},{5,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:eternity_grass","invector:waypoint_6","solarsail:wireframe","invector:invisible_wall"}}},{{["nodes"]={{1,256},{2,80},{1,3760}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,1280},{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,15},{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177},2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,1,2,{1,13},2,{1,177}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,2,1,{2,13},1,{2,177},1,{2,13},1,1,1,{2,13},1,1,1,{2,13},1,1,1,{2,13},1,1,1,{2,13},1,1,{2,176}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"invector:invisible_wall","air"}},{["nodes"]={1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"invector:invisible_wall","air"}},{["nodes"]={1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,191},1,{2,15},1,{2,15},1,{2,15},1,{2,15},1,{2,2239}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"invector:invisible_wall","air"}},{["nodes"]={{1,3584},{2,80},{1,432}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,3840},{2,80},{1,176}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}}}},{{{["nodes"]={{1,128},{2,16},{1,240},{3,16},{2,16},{4,96},{1,128},{3,16},{1,240},{3,16},{1,240},{3,16},{1,240},{3,16},{1,240},2,2,2,2,{3,12},{1,240},{2,6},{3,10},{1,240},{2,8},{3,8},{1,240},{2,10},{3,6},{1,240},{2,11},{3,5},{1,240},{2,11},{3,5},{1,240},{2,12},3,3,3,3,{1,240},{2,12},3,3,3,3,{1,240},{2,13},3,3,3,{1,240},{2,13},3,3,3,{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall"}},{["nodes"]={{1,128},{2,14},3,3,{1,240},{2,14},3,3,{1,240},3,{2,13},3,3,{1,240},3,3,{2,13},3,{1,240},3,3,3,{2,12},3,{1,240},3,3,3,{2,12},3,{4,16},{1,224},3,3,3,3,{2,11},3,{4,16},{1,224},3,3,3,3,{2,11},3,{1,240},3,3,3,3,{2,12},{1,240},{3,5},{2,11},{1,240},{3,5},{2,11},{1,240},{3,5},{2,11},{1,240},{3,5},{2,11},{1,240},{3,6},{2,10},{1,240},{3,6},{2,10},{1,240},{3,6},{2,10},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:waypoint_14"}},{["nodes"]={{1,128},{2,7},{3,9},{1,240},{2,7},{3,9},{1,240},{2,7},{3,9},{1,240},{2,7},{3,9},{1,240},{2,8},{3,8},{1,240},{2,8},{3,8},{1,15},4,{1,224},{2,8},{3,8},{1,14},4,4,{1,224},{2,8},{3,8},{1,13},4,4,{1,225},{2,8},{3,8},{1,12},4,4,{1,226},{2,9},{3,7},{1,11},4,4,{1,227},{2,9},{3,7},{1,10},4,4,{1,228},{2,10},{3,6},{1,9},4,4,{1,229},{2,12},3,3,3,3,{1,8},4,4,{1,230},{2,16},{1,7},4,4,{1,231},{2,16},{1,6},4,4,{1,232},5,{3,31},{6,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:eternity_grass","solarsail:wireframe","invector:waypoint_13","invector:starting_grid_marker","invector:invisible_wall"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,32},{3,96},{1,128},{4,16},{1,7},5,5,{1,103}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:invisible_wall","invector:eternity_grass","invector:waypoint_7"}},{["nodes"]={{1,128},{2,16},{1,7},3,3,{1,231},{4,16},{1,7},4,4,{1,231},{4,16},{1,7},4,4,{1,231},{4,16},{1,7},4,4,{1,231},{4,16},{1,7},3,3,{1,231},{4,16},{1,7},3,3,{1,231},4,4,4,1,1,1,{4,10},{1,7},3,3,{1,231},4,4,4,1,5,1,{4,10},{1,7},3,3,{1,231},4,4,4,1,1,1,{4,10},{1,7},3,3,{1,231},{4,16},{1,7},3,3,{1,231},{4,16},{1,7},3,3,{1,231},{4,16},{1,7},4,4,{1,231},{4,16},{1,7},4,4,{1,231},{4,16},{1,7},4,4,{1,231},{2,16},{1,7},3,3,{1,231},{4,32},{6,96}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:eternity_grass","invector:waypoint_7","solarsail:wireframe","invector:boost_pad_mega","invector:invisible_wall"}}},{{["nodes"]={{1,256},{2,80},{1,3760}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,3840},{2,80},{1,176}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,3584},{2,80},{1,432}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,3840},{2,80},{1,176}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}}}},{{{["nodes"]={{1,128},{2,16},{1,240},{3,11},{2,9},{1,12},4,4,4,4,{1,12},4,4,4,4,{1,12},4,4,4,4,{1,12},4,4,4,4,{1,12},4,4,4,4,{1,12},4,4,4,4,{1,140},{3,11},{2,5},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},{3,11},{2,5},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},{3,11},{2,5},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},{3,11},{2,5},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,12}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall"}},{["nodes"]={{1,128},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},5,5,5,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},5,5,5,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,2,2,{3,13},1,1,1,3,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,12}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:eternity_grass","solarsail:wireframe","invector:invisible_wall","invector:waypoint_14"}},{["nodes"]={{1,128},2,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},2,3,3,{2,13},1,1,5,{2,13},1,1,1,{4,13},1,1,1,{4,13},1,1,1,{4,13},1,1,1,{4,13},1,1,1,{4,13},1,1,1,{4,13},{1,128},2,2,{3,14},1,5,5,{1,7},6,6,{1,228},2,2,2,{3,13},5,5,{1,8},6,6,{1,228},{2,16},5,{1,9},6,6,{1,228},{2,7},7,{2,8},{1,10},6,6,{1,228},2,2,2,2,7,{2,11},{1,10},6,6,{1,228},{2,7},7,{2,8},{1,10},6,6,{1,228},2,2,2,2,7,{2,11},{1,10},6,6,{1,228},{2,7},7,{2,8},{1,10},6,6,{1,228},2,2,2,2,7,{2,11},{1,10},6,6,{1,228},{2,16},{1,10},6,6,{1,228},{3,12},2,2,2,2,{1,10},6,6,{1,228},{3,15},2,{1,10},6,6,{1,228},{2,12},3,3,3,3,{2,12},1,1,1,1,{4,12},1,1,1,1,{4,12},1,1,1,1,{4,12},1,1,1,1,{4,12},1,1,1,1,{4,12},1,1,1,1,{4,12},1,1,1,1},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:waypoint_13","invector:waypoint_12","invector:item_pad_online"}},{["nodes"]={{1,128},{2,14},3,3,{1,12},2,2,{1,14},4,4,{1,14},4,4,{1,14},4,4,{1,14},4,4,{1,14},4,4,{1,14},4,4,{1,130},{2,15},3,{1,14},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,129},{2,15},3,{1,15},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,15},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,128},{2,15},4,{1,14},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,129},{2,14},4,4,{1,13},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,130},{2,13},4,4,4,{1,12},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,131},{2,12},4,4,4,2,{1,11},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,132},{2,11},4,4,4,2,2,{1,10},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,133},{2,10},4,4,4,2,2,2,{1,9},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,134},{2,9},4,4,4,2,5,5,2,{1,8},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,135},{2,8},4,4,4,2,2,2,5,2,{1,7},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,136},{2,7},4,4,4,{2,6},{1,6},2,6,6,{1,13},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,137},{2,6},4,4,4,4,{2,6},{1,5},2,1,1,6,6,{1,11},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},{2,5},{4,5},{2,11},1,1,1,1,6,6,{1,5},{3,5},{1,11},{3,5},{1,11},{3,5},{1,11},{3,5},{1,11},{3,5},{1,11},{3,5},{1,139},{4,7},{2,9},{1,10},6,6,{1,100}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:invisible_wall","invector:eternity_grass","invector:boost_pad","invector:waypoint_8"}},{["nodes"]={{1,128},{2,6},{3,10},{1,11},4,4,{1,227},{3,16},{1,12},4,4,{1,226},{3,16},{1,13},4,4,{1,225},3,5,{3,14},{1,14},4,4,{1,224},{3,15},2,{1,15},4,{1,224},3,5,{3,13},2,{1,240},{3,15},2,{1,240},3,5,{3,12},2,2,{1,240},{3,13},2,2,2,{1,240},3,5,{3,10},2,2,2,2,{1,240},{3,11},2,2,2,2,3,{1,15},3,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,128},3,5,{3,8},2,2,2,2,3,3,{1,14},3,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,129},{3,9},2,2,2,2,3,3,3,{1,13},3,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,130},{3,8},2,2,2,2,3,3,3,3,{1,12},3,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,131},{2,11},{3,5},{1,11},3,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,15},6,{1,132},{3,32},{6,11},{1,5},{6,11},{1,5},{6,11},{1,5},{6,11},{1,5},{6,11},{1,5},{6,11},{1,5}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:eternity_grass","solarsail:wireframe","invector:waypoint_8","invector:item_pad_online","invector:invisible_wall"}}},{{["nodes"]={{1,256},2,2,2,2,{1,12},2,2,2,2,{1,12},2,2,2,2,{1,12},2,2,2,2,{1,12},2,2,2,2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,188}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={1,1,1,2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,188}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={1,1,1,2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},{2,13},1,1,1,{2,13},1,1,1,{2,13},1,1,1,{2,13},1,1,1,{2,13},{1,3248},{2,12},1,1,1,1,{2,12},1,1,1,1,{2,12},1,1,1,1,{2,12},1,1,1,1,{2,12},{1,180}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,12},2,2,{1,14},2,2,{1,14},2,2,{1,14},2,2,{1,14},2,2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,3504}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,783},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,186},{2,5},{1,11},{2,5},{1,11},{2,5},{1,11},{2,5},{1,11},{2,5},{1,443}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,2575},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,180},{2,11},{1,5},{2,11},{1,5},{2,11},{1,5},{2,11},{1,5},{2,11},{1,181}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}}}},{{{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,32},{3,96},{1,128},{4,16},{1,240},{4,16},{1,240},{2,6},{4,10},{1,240},{2,8},{4,8},{1,240},{2,10},{4,6},{1,240},{2,12},4,4,4,4,{1,240},{2,14},4,4,{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},4,{2,15},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:invisible_wall","invector:eternity_grass"}},{["nodes"]={{1,128},2,2,{3,14},{1,240},2,2,2,{3,13},{1,15},4,{1,224},2,2,2,2,{3,12},{1,14},4,4,{1,224},3,2,2,2,2,{3,12},{1,12},4,4,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},3,3,2,2,2,2,{3,10},1,3,{1,10},4,4,1,1,1,5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,142},3,3,3,2,2,2,2,{3,9},1,1,3,{1,8},4,4,{1,5},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,141},3,3,3,3,2,2,2,2,{3,8},1,1,1,3,{1,6},4,4,{1,7},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,140},{3,5},2,2,2,2,{3,7},1,1,1,1,3,1,1,1,1,4,4,{1,9},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,139},{3,6},2,2,2,2,{3,6},{1,5},3,1,1,4,4,{1,11},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},{3,7},2,2,2,{3,6},{1,6},3,4,4,{1,13},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,137},{3,8},2,2,{3,6},{1,7},3,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,136},{3,8},2,2,{3,6},{1,7},3,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,136},{3,8},2,2,{3,6},{1,7},3,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,136},{3,8},2,2,{3,6},{1,7},3,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,136},{3,8},2,2,{3,6},{1,7},3,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,136},{3,8},2,2,{3,6},{1,7},3,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,8}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:eternity_grass","solarsail:wireframe","invector:waypoint_11","invector:invisible_wall"}},{["nodes"]={{1,128},{2,8},3,3,{2,6},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,{2,6},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,{2,6},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,{2,6},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,{2,6},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,{2,6},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,3,{2,5},{1,7},2,{5,8},{1,7},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,3,{2,5},{1,7},2,{5,8},{1,7},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,3,{2,5},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,{2,6},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,3,{2,6},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,8},3,{2,7},{1,7},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,136},{2,7},3,3,{2,7},{1,6},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,137},{2,6},3,3,3,{2,7},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},{2,5},3,3,3,{2,8},1,1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,139},2,2,2,2,3,3,3,{2,9},1,1,1,2,6,6,{1,13},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,12}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:waypoint_10","invector:waypoint_9"}},{["nodes"]={{1,128},2,2,2,3,3,3,3,{2,9},1,1,2,1,1,4,4,{1,11},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,141},2,2,{3,5},{2,9},1,2,1,1,1,1,4,4,{1,9},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,142},2,3,3,3,{2,13},{1,6},4,4,{1,7},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},3,3,3,{2,13},{1,8},4,4,{1,230},3,3,{2,14},{1,9},4,4,{1,229},3,{2,15},{1,10},4,4,{1,228},{2,15},3,{1,11},4,4,{1,227},{2,12},3,3,3,3,{1,12},4,4,{1,226},{2,12},3,3,3,3,{1,13},4,4,{1,225},{2,12},3,3,3,3,{1,14},4,4,{1,224},{2,11},3,3,3,3,2,{1,15},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,128},{2,10},3,3,3,3,2,2,{1,14},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,129},{2,9},3,3,3,3,2,2,2,{1,13},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,130},{2,8},3,3,3,3,2,2,2,2,{1,12},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,131},{2,7},3,3,3,3,{2,5},{1,11},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,132},2,2,6,6,2,2,3,3,3,3,{2,6},{1,10},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,5}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:waypoint_9","invector:invisible_wall","invector:boost_pad"}},{["nodes"]={{1,128},2,2,2,3,2,4,4,4,4,{2,7},{1,9},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,134},2,2,2,2,4,4,4,4,{2,8},{1,8},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,135},2,2,2,4,4,4,4,{2,9},{1,7},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,136},2,2,4,4,4,4,{2,10},{1,6},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,137},{4,5},{2,11},6,1,1,1,1,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},4,4,4,4,{2,12},6,6,1,1,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,139},4,4,4,{2,13},1,6,6,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,140},4,4,{2,14},1,1,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,141},4,{2,15},1,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,142},{2,17},{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,143},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,23},{1,105}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:boost_pad","invector:eternity_grass","invector:invisible_wall","invector:waypoint_8"}}},{{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,512},{2,80},{1,3504}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,768},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,192},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,184}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,7},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,188}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={1,1,2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,1998},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,181}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,9},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,1727}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}}}},{{{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,22},{1,10},{3,6},{1,10},{3,6},{1,10},{3,6},{1,10},{3,6},{1,10},{3,6},{1,10},{3,6},{1,138},{4,5},{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},{4,5},{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},{4,5},{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},{4,5},{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},{4,5},{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},{4,5},{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},{4,5},{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},{4,5},{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},2,4,4,4,4,{2,11},{1,5},2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},2,4,4,4,4,{2,11},1,1,1,1,5,2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},2,2,4,4,4,{2,11},1,1,1,5,5,2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},2,2,4,4,4,{2,11},1,1,5,5,1,2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,138},2,2,2,4,4,{2,11},1,5,5,1,1,2,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,15},3,{1,10}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:invisible_wall","invector:eternity_grass","invector:waypoint_11"}},{["nodes"]={{1,128},2,2,2,3,3,{2,11},4,4,1,1,1,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},4,1,1,1,1,2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,15},5,{1,10}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:waypoint_11","invector:invisible_wall"}},{["nodes"]={{1,128},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,3,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,3,3,{2,11},{5,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,3,3,{2,11},{5,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,3,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,2,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,3,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,10}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall","invector:waypoint_10"}},{["nodes"]={{1,128},2,2,2,3,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,3,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,2,3,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,2,3,3,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},2,3,3,3,3,{2,11},{1,5},2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,138},3,3,3,3,{2,12},1,1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,139},3,3,3,{2,13},1,1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,140},3,3,{2,14},1,1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,141},3,{2,15},1,2,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,142},{2,17},{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,15},4,{1,143},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe","invector:eternity_grass","invector:invisible_wall"}},{["nodes"]={{1,128},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,240},{2,16},{1,112}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","solarsail:wireframe"}}},{{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}},{["nodes"]={{1,512},{2,6},{1,10},{2,6},{1,10},{2,6},{1,10},{2,6},{1,10},{2,6},{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,186}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,5},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,186}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,5},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,186}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,5},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,191},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,190},2,{1,15},2,{1,15},2,{1,15},2,{1,15},2,{1,1727}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air","invector:invisible_wall"}},{["nodes"]={{1,4096}},["size"]={["y"]=15,["x"]=15,["z"]=15},["nodenames"]={"air"}}}}}]])

invector.game.register_track("circ_demo", circ_demo)