function interactive_item.register_action(id, def)
    -- Default-Fill
    -- Forms
    def.forms = def.forms or {}
    def.forms.main = def.forms.main or function() return end
    -- Logic
    def.logics = def.logics or {}
    def.logics.main = def.logics.main or function() return end
    def.logics.start = def.logics.start or function() return true end
    def.logics.sanity = def.logics.sanity or function() return true end
    -- Inventory
    def.inventories = def.inventories or {}
    -- Options
    def.options = def.options or {}
    
    interactive_item.actions[id] = def
end

function interactive_item.open_action(id, item, player)
    if not interactive_item.actions[id] then return end
    
    local form = ""
    local actiondata = interactive_item.actions[id]
    local s = actiondata.size
    
    -- Create a clone
    local clitem = ItemStack(item)
    local clmeta = clitem:get_meta()
    
    -- Assure data exist
    local meta = item:get_meta()
    if meta:get_string("action_data") == "" then
        meta:set_string("action_data", minetest.serialize({}))
    end
    
    -- Storeable
    if not actiondata.options.storeable then
        meta:set_string("storeable", "false")
    end
    
    -- Make data accessible
    local data = interactive_item.get_data(item)
    
    -- Page exist?
    if not data.page then
        data.page = "main"
    end
    
    -- Add ID
    if not data.id then
        data.id = interactive_item.generate_id("iit_id")
    end
    
    -- Give ID to player
    local pmeta = player:get_meta()
    if pmeta:get_string("iit_id") == "" then
        pmeta:set_string("iit_id", data.id)
    end
    
    -- Start the action
    actiondata.logics.start(item, nil, player, data)
    
    if not actiondata.logics.sanity(item, player, data) then
        data.started = false
    
        actiondata.logics.start(item, nil, player, data)
    end
    if not actiondata.logics.sanity(item, player, data) then
        data.started = false
        
        interactive_item.set_data(item, player, data)
        return
    end -- sanity wasn't fixed, abort
    
    -- Compare player's wielded item to the item (before modifications) to ensure it is the same item and not a bug due to lag.
    local pimeta = player:get_wielded_item():get_meta()
	if not pimeta:get_string("action_data") == clmeta:get_string("action_data") then return end -- Not the same
	
    if not actiondata.forms then return end
    
    -- Making the formspec
    
    -- Now we make
    if not actiondata.forms[data.page] then
        data.page = "main"
    end
    
    -- Second check
    if not actiondata.forms[data.page] then
        data.page = "main"
        interactive_item.set_data(item, player, data)
        return
    end
    
    -- Create the formpart
    local formpart = actiondata.forms[data.page](item, player, data)
    if not formpart then
        interactive_item.set_data(item, player, data)
        return
    end
    
    -- Create the formspec
    form = form .. formpart
    
    -- Save
    interactive_item.set_data(item, player, data)
    player:set_wielded_item(item)
    
    -- Open up!
    minetest.show_formspec(player:get_player_name(), "interactive_item:action", form)
end

-- Fields
minetest.register_on_player_receive_fields(function(player, formname, fields)
	if formname ~= "interactive_item:action" then return end
	if fields.none then return end
	
	local item = player:get_wielded_item()
	local meta = item:get_meta()
	local id = meta:get_string("action")
	
	if id == "" then return end 
	
	local action = interactive_item.actions[id]
	
	if not action then return end
	if not action.logics then return end
	
	-- Get data
	local data = interactive_item.get_data(item)
	
	if not action.logics.sanity(item, player, data) then
        interactive_item.set_data(item, player, "started", "false")
        return
    end
	
	action.logics.main(item, fields, player, data)
	
	-- Save data
	interactive_item.set_data(item, player, data)
	player:set_wielded_item(item)
	
	-- Update
	if not fields.quit then
	    interactive_item.open_action(id, item, player)
	else
	    interactive_item.delete_inventories(player)
	    player:get_meta():set_string("iit_dynamic_viewing", "")
	    player:get_meta():set_string("iit_id", "")
	end
end)
