local storage = minetest.get_mod_storage()

do
    interactive_item.counters = minetest.deserialize(storage:get_string("iit_counters")) or {}
end

-- Create
interactive_item.generate_id = function(counter)
    -- If it doesn't exist, create it
    if not interactive_item.counters[counter] then
        interactive_item.counters[counter] = 0
    end
    
    -- Now to try to make a unique id
	local id_pieces = {}
	for i=1, 2 do
    	table.insert(id_pieces, tostring(math.random(100, 999)))
	end
	local random_id = table.concat(id_pieces, "-")
    interactive_item.counters[counter] = interactive_item.counters[counter] + 1
    
    -- Update
    storage:set_string("iit_counters", minetest.serialize(interactive_item.counters))
    
    -- Return
	return random_id.."-"..interactive_item.counters[counter]
end