-- Register Interactive Item
function interactive_item.register_item(id, def)
    -- Interactive usage.
    local old_def = table.copy(def)
	def.on_use = function(itemstack, user, pointed_thing)
	    -- Execute whatever on_use there was first
	    old_def.on_use(itemstack, user, pointed_thing)
	
	    -- Now execute interactive on_use if not skipped by previous function
	    local meta = itemstack:get_meta()
	    if meta:get_string("skip") == "true" then
	        meta:set_string("skip", "false")
	        return
	    else
	        local aid = meta:get_string("action")
	
	        if aid == "" then return end
	        interactive_item.open_action(aid, itemstack, user)
	    end
	end
	-- Group
	if def.groups then
	    def.groups.iit_interactive = 1
	else
	    def.groups = {iit_interactive = 1}
	end
	
	-- Register as tool.
	minetest.register_tool(":"..id, def)
end