local function inventory_to_table(inv, listname)
    local list = inv:get_list(listname)
    local result = {}

    for _, stack in ipairs(list) do
        if not stack:is_empty() then
            table.insert(result, stack:to_string())
        else
            table.insert(result, "")
        end
    end

    return result
end

-- -- -- -- --

function interactive_item.get_inventory_list(inv, data)
    local store = data.inventory
    
    if not store then return end
    if not store[inv] then return end
    if not store[inv].items then return end

    return store[inv].items
end

function interactive_item.set_inventory_list(inv, list, data)
    local store = data.inventory
    
    if not store then return end
    if not store[inv] then return end
    if not store[inv].items then return end
    
    store[inv].items = list
end

function interactive_item.get_inventory_item(inv, index, data)
    local store = data.inventory
    
    if not store then return end
    if not store[inv] then return end
    if not store[inv].items then return end

    return store[inv].items[index]
end
function interactive_item.set_inventory_item(inv, index, stack, data)
    local store = data.inventory
    
    if not store then return end
    if not store[inv] then return end
    if not store[inv].items then return end
    
    store[inv].items[index] = stack:to_string()
end

-- -- -- -- --

function interactive_item.update_inventory_meta(player, data)
    local inv = player:get_inventory()
    if not inv then return end
    
    for i in pairs(inv:get_lists()) do
        local iitem = i:split("-")
        
        if iitem[1] and iitem[2] then
            if iitem[1] == "iit_inventory" then
                local stringtable = inventory_to_table(inv, i)
                interactive_item.set_inventory_list(iitem[2], stringtable, data)
            end
        end
    end
end
function interactive_item.update_inventory_list(player, data)
    local inv = player:get_inventory()
    if not inv then return end
    
    for i in pairs(inv:get_lists()) do
        local iitem= i:split("-")
        
        if iitem[1] and iitem[2] then
            if iitem[1] == "iit_inventory" then
                inv:set_list(i, interactive_item.get_inventory_list(iitem[2], data))
            end
        end
    end
end
function interactive_item.delete_inventories(player)
    local inv = player:get_inventory()
    if not inv then return end
    
    for i in pairs(inv:get_lists()) do
        local iitem = i:split("-")
        
        if iitem[1] and iitem[2] then
            if iitem[1] == "iit_inventory" then
                -- Delete
                inv:set_list(i, {})
                inv:set_size(i, 0)
            end
        end
    end
end

-- -- -- -- --
function interactive_item.lock_inventory(item, inv, reason, data)
    data.inventory[inv].locked = reason
end
function interactive_item.lock_inventories(item, reason, data)
    for i in pairs(data.inventory) do
        data.inventory[i].locked = reason
    end
end

function interactive_item.unlock_inventory(item, inv, data)
    data.inventory[inv].locked = nil
end
function interactive_item.unlock_inventories(item, data)
    for i in pairs(data.inventory) do
        data.inventory[i].locked = nil
    end
end

-- -- -- -- --

function interactive_item.has_inventory(item, inventory, data)
    local meta = item:get_meta()
    local actiondata = interactive_item.actions[meta:get_string("action")]
    
    if not actiondata then return false, "no_data" end
    if not actiondata.inventories then return false, "no_definition" end
    if not actiondata.inventories[inventory] then return false, "no_inventory" end
    
    return true
end

function interactive_item.open_inventory(item, player, inventory, data)
    -- Item
    local meta = item:get_meta()
    local actiondata = interactive_item.actions[meta:get_string("action")]
    if not interactive_item.has_inventory(item, inventory, data) then return end
    if not actiondata.inventories[inventory].size then return end
    -- Callbacks are optional
    
    -- Player inv
    local inv = player:get_inventory()
    if not inv then return end
    
    -- Verify data existence
    for i in pairs(actiondata.inventories) do
        if not data.inventory then
            data.inventory = {}
        end
        if not data.inventory[i] then
            data.inventory[i] = {}
        end
        if not data.inventory[i].items then
            data.inventory[i].items = {}
        end
    end
    
    -- Data
    local idata = interactive_item.get_inventory_list(inventory, data)
    if not idata then return end
    
    -- Adjust size, load
    inv:set_size("iit_inventory-"..inventory, actiondata.inventories[inventory].size)
    interactive_item.update_inventory_list(player, data)
    
    -- Sanity for new lists
    for i in pairs(data.inventory) do
        if not data.inventory[i][1] then
            interactive_item.update_inventory_meta(player, data)
        end
    end
end

-- -- -- -- --

-- Is the player allowed to do this?
minetest.register_allow_player_inventory_action(function(player, action, inv, invi)
    -- Turn the names into 2 strings.
    local listname = invi.listname or "none-none"
    local to_list = invi.to_list or "none-none"
    local from_list = invi.from_list or "none-none"
    
    local rlistname = listname
    listname = listname:split("-")
    local rto_list = to_list
    to_list = to_list:split("-")
    local rfrom_list = from_list
    from_list = from_list:split("-")
    
    -- Is the iit inventory involved?
    if listname[1] == "iit_inventory" then return 0 end -- Only allow direct change
    
    if to_list[1] == "iit_inventory" or from_list[1] == "iit_inventory" then
        local stack = inv:get_stack(invi.from_list, invi.from_index)
        local smeta = stack:get_meta()
        local item = player:get_wielded_item()
        local meta = item:get_meta()
        local actiondata = interactive_item.actions[meta:get_string("action")]
        
        if not actiondata then return 0 end -- Main not found.
        local data = interactive_item.get_data(item)
        
        -- Putting
        if to_list[1] == "iit_inventory" and to_list[2] then  
            -- Sanity
            if not data.inventory then return 0 end
            if not data.inventory[to_list[2]] then return 0 end
            if data.inventory[to_list[2]].locked then minetest.chat_send_player(player:get_player_name(), (data.inventory[to_list[2]].locked or "This inventory is locked")) return 0 end
            if not data.inventory[to_list[2]].items then return 0 end
            if not data.inventory[to_list[2]].items[invi.to_index] then return 0 end
            -- Check if same inventory
            if minetest.serialize(inventory_to_table(inv, rto_list)) ~= minetest.serialize(data.inventory[to_list[2]].items) then return 0 end
        
            -- First of all, you can't put interactive items with storage inside the interactive item, exceptions can be made through options.
            -- Items that have yet to be executed can also be stored as they're empty in metadata.
            if smeta:get_string("storeable") == "false" then minetest.chat_send_player(player:get_player_name(), "You can't put this item inside!") return 0 end
        
            -- You can't put the same item as the wielditem
            if stack == item then minetest.chat_send_player(player:get_player_name(), "You can't store this item.") return 0 end
        
            -- Finally, the item's own filters
            if actiondata.inventories[to_list[2]] then
                if actiondata.inventories[to_list[2]].allow_put then
                    return actiondata.inventories[to_list[2]].allow_put(item, player, stack, invi, data)
                end
            end
        -- Taking
        elseif from_list[1] == "iit_inventory" and from_list[2] then
            -- Sanity
            if not data.inventory then return 0 end
            if not data.inventory[from_list[2]] then return 0 end
            if data.inventory[from_list[2]].locked then minetest.chat_send_player(player:get_player_name(), (data.inventory[from_list[2]].locked or "This inventory is locked")) return 0 end
            if not data.inventory[from_list[2]].items then return 0 end
            if not data.inventory[from_list[2]].items[invi.from_index] then return 0 end
            -- Check if same inventory
            if minetest.serialize(inventory_to_table(inv, rfrom_list)) ~= minetest.serialize(data.inventory[from_list[2]].items) then return 0 end
            
        	-- The item's own filters
            if actiondata.inventories[from_list[2]] then
                if actiondata.inventories[from_list[2]].allow_take then
                    return actiondata.inventories[from_list[2]].allow_take(item, player, stack, invi, data)
                end
            end
            interactive_item.set_data(item, player, data)
        end
    end
end)

minetest.register_on_player_inventory_action(function(player, action, inv, invi)
    -- Turn the names into 2 strings.
    local listname = invi.listname or "none-none"
    local to_list = invi.to_list or "none-none"
    local from_list = invi.from_list or "none-none"
    
    listname = listname:split("-")
    to_list = to_list:split("-")
    from_list = from_list:split("-")
    
    -- Is the iit inventory involved?
    if listname[1] == "iit_inventory" then return 0 end -- Only allow direct change
    
    if to_list[1] == "iit_inventory" or from_list[1] == "iit_inventory" then
        local stack = inv:get_stack(invi.from_list, invi.from_index)
        local smeta = stack:get_meta()
        local item = player:get_wielded_item()
        local meta = item:get_meta()
        local actiondata = interactive_item.actions[meta:get_string("action")]
        
        if not actiondata then return 0 end -- Main not found.
        local data = interactive_item.get_data(item)
        
        -- Update
        interactive_item.update_inventory_meta(player, data)
        interactive_item.set_data(item, player, data)
        -- Putting
        if to_list[1] == "iit_inventory" and to_list[2] then
            -- The item's own actions
            if actiondata.inventories[to_list[2]] then
                if actiondata.inventories[to_list[2]].on_put then
                    return actiondata.inventories[to_list[2]].on_put(item, player, stack, invi, data)
                end
            end
        -- Taking
        elseif from_list[1] == "iit_inventory" and from_list[2] then
        	-- The item's own actions
            if actiondata.inventories[from_list[2]] then
                if actiondata.inventories[from_list[2]].on_take then
                    return actiondata.inventories[from_list[2]].on_take(item, player, stack, invi, data)
                end
            end
        end
        interactive_item.set_data(item, player, data)
    end
end)
