-- Helpers
local invcheck = function(inv, data)
    local store = data.inventory
    
    if not store then return false end
    if not store[inv] then return false end
    if not store[inv].items then return false end
    
    return true
end
local makestack = function(stack, amt)
    local nstack = ItemStack(stack)
    
    nstack:set_count(amt or 1)
    
    return nstack
end
local leftin = function(items, taking)
    local result = items - taking
    
    if 0 > result then result = 0 end
    
    return result
end

-- Inventory functions
function interactive_item.inv_has(inv, stack, data)
    if not invcheck(inv, data) then return false end
    local invi = data.inventory[inv].items
    
    -- Makestack
    local stacki = makestack(stack)
    
    -- Countdowns
    local cc = ItemStack(stack):get_count()
    
    -- Indexes
    local idx = {}
    
	for i = 1, #invi do
		if stacki then
		    local istacki = makestack(invi[i])
		    if istacki then
	        	if istacki:equals(stacki) then
	                local ncc = leftin(cc, ItemStack(invi[i]):get_count())
	                local st = cc - ncc
                    cc = ncc
                    
                    idx[#idx+1] = {i, st}
            
                    if cc == 0 then
                        break
                    end
                end
            end
        end
	end
	
	if cc == 0 then
	    return idx
	else
    	return false
    end
end

function interactive_item.inv_fit(inv, stack, data)
    if not invcheck(inv, data) then return false end
    local invi = data.inventory[inv].items
    
    -- Makestack
    local stacki = makestack(stack)
    
    -- Countdowns
    local cc = ItemStack(stack):get_count()
    
    -- Indexes
    local idx = {}
    
	for i = 1, #invi do
		if stacki then
		    local istacki = makestack(invi[i])
		    if istacki then
	        	if istacki:equals(stacki) then
					local fr = ItemStack(invi[i]):get_free_space()
					local ncc = cc - fr
					local st = fr
					if 0 > ncc then
					    st = cc
					    ncc = 0
					end
					cc = ncc
					
					idx[#idx + 1] = {i, st}
					
					if cc == 0 then
					    break
                    end
                elseif istacki:to_string() == "" then
                    local fr = ItemStack(stack):get_stack_max()
                    local ncc = cc - fr
					local st = fr
					if 0 > ncc then
					    st = cc
					    ncc = 0
					end
					cc = ncc
					
					idx[#idx + 1] = {i, st}
					
					if cc == 0 then
					    break
                    end
                end
            end
        end
	end
	
	if cc == 0 then
	    return idx
	else
    	return false
    end
end

function interactive_item.inv_add(inv, stack, data)
    if not invcheck(inv, data) then return false end
    
    local idxs = interactive_item.inv_fit(inv, stack, data)
    
    if idxs then
        local invi = data.inventory[inv].items
        local stacki = makestack(stack)
        
        for i = 1, #idxs do
			-- Get Stacks
			local s1 = ItemStack(invi[idxs[i][1]]):get_count()
			local s2 = idxs[i][2]
			-- Fuse
			local rs = s1 + s2
			
			invi[idxs[i][1]] = makestack(stacki, rs):to_string()
		end
		return true
    else
        return false
    end
end

function interactive_item.inv_take(inv, stack, data)
    if not invcheck(inv, data) then return false end
    
    local idxs = interactive_item.inv_has(inv, stack, data)
    
    if idxs then
        local invi = data.inventory[inv].items
        
        for i = 1, #idxs do
			-- Get Stacks
			local s1 = ItemStack(invi[idxs[i][1]]):get_count()
			local s2 = idxs[i][2]
			-- Fuse
			local rs = s1 - s2
			
			if rs == 0 then
			    invi[idxs[i][1]] = ""
			else 
		    	invi[idxs[i][1]] = makestack(invi[idxs[i][1]], rs):to_string()
		    end
		end
		return true
    else
        return false
    end
end

-- Function for dealing with tables of items.
function interactive_item.inv_mass(name, lstacks, data)
	if interactive_item["inv_"..name] then
	    local cdata = table.copy(data)
	    local save = true
		
		for i in pairs(lstacks) do
		    if invcheck(i, cdata) then
		        for i2 in ipairs(lstacks[i]) do
		            local stack = lstacks[i][i2]
	            	save = interactive_item["inv_"..name](i, stack, cdata)
	
	                -- Something is wrong
	                if not save then break end
	            end
	            if not save then break end
	        else
	            minetest.log("warning", "Inventory '" .. i .. "' doesn't exist in this lootbox.")
	            save = false
	            break
	        end
	    end
		
		if save then
		    data.inventory = cdata.inventory
		    return true
		else
		    return false
		end
	end
end

--[[
function interactive_item.inv_swap(inv, index, stack, data)
    if not invcheck(inv, data) then return end
    
end

function interactive_item.inv_remove(inv, index, data)
    if not invcheck(inv, data) then return end
    
end
end
]]--