-- Choosing
function interactive_item.choose(list, cname)
	local num = 0
	local value = "iit_empty"
	for i in pairs(list) do
	    if not list[i].iit_weight then
	        minetest.log("warning", i .. " in " .. (cname or "a given list (no cname provided)") .. " has no 'iit_weight', removing.")
	        list[i] = nil
	    else
	    	num = num + list[i].iit_weight
	    end
	end
	--
	local random = math.random(1, num)
	--
	local min = 0
	local max = 0
	for i in pairs(list) do
	    local change = list[i].iit_weight
	    max = max + change
	    if max >= random and random > min then
			value = i
			break
	    end
	    min = min + change
	end
	return value
end

-- Filter
function interactive_item.filter(list, ttype, clist)
    local torem = table.copy(list)
    
    for i in pairs(list) do
        local rem = false
    	if ttype == "remove" then
			if clist[i] then
			    if type(list[i]) == type(clist[i]) then
			    	if type(clist[i]) == "table" then
					    if minetest.serialize(clist[i]) == minetest.serialize(list[i]) then
						    rem = true
				    	end
			    	else
				    	if clist[i] == list[i] then
						    rem = true
					    end
					end
				end
			end
    	elseif ttype == "keep" then
            rem = true
			if clist[i] then
			    if type(list[i]) == type(clist[i]) then
			    	if type(clist[i]) == "table" then
					    if minetest.serialize(clist[i]) == minetest.serialize(list[i]) then
						    rem = false
				    	end
			    	else
				    	if clist[i] == list[i] then
						    rem = false
					    end
					end
				end
			end
    	end
        
        if rem then
            torem[i] = nil
        end
    end
    
    return torem
end