-- Dynamic formspecs update frequently, update timers or conditions can be set if needed.

minetest.register_globalstep(function(dtime)
    for _, player in pairs(minetest.get_connected_players()) do
        -- There is a check to ensure the item in the player hand is respective to the formspec it is being shown.
        local item = player:get_wielded_item()
        -- Sanity
        local meta = item:get_meta()
        local pmeta = player:get_meta()
        
        -- Can't have no action_data while having a id
        if not interactive_item.actions[meta:get_string("action")] then
        	if pmeta:get_string("iit_id") ~= "" then
                minetest.close_formspec(player:get_player_name(), "interactive_item:action")
                pmeta:set_string("iit_dynamic_viewing", "")
                pmeta:set_string("iit_id", "")
            end
            return
        end
        
        if meta:get_string("action_data") == "" then return end
        
        local action = interactive_item.actions[meta:get_string("action")]
        local data = interactive_item.get_data(item)
        
        -- Can't be different id, however try to open the other formspec
        if pmeta:get_string("iit_id") ~= (data.id or "dnone") then
            if pmeta:get_string("iit_id") == "" then return end
            minetest.close_formspec(player:get_player_name(), "interactive_item:action")
            pmeta:set_string("iit_dynamic_viewing", "")
            pmeta:set_string("iit_id", "")
            if data.id and meta:get_string("action") ~= "" then
                interactive_item.open_action(meta:get_string("action"), item, player)
            end
            return
        end
        
        -- -- -- -- --
        -- The Real Dynamism system is in WIP, use at your own discretion
        
        -- Actual dynamism checks
        if not pmeta:get_string("iit_dynamic_viewing") == "true" then return end -- Player is not viewing a dynamic formspec of this mod.
        
        if not action.dynamic_logic then return end -- This function has no dynamic logic.
        if not data.dynamic == "true" then return end -- Item is not dynamic.
        
        action.dynamic_logic(item, player, dtime)
	end
end)