-- Makes it easy to call other logics inside the logic
interactive_item.call = function(item, command, player, vars, logic)
    local meta = item:get_meta()
    
    -- Quick sanity check
    if meta:get_string("action") == "" then
        minetest.chat_send_player(player:get_player_name(), "Item has no interactivity set.")
        return
    elseif not interactive_item.actions[meta:get_string("action")] then
        minetest.chat_send_player(player:get_player_name(), "This Action ("..meta:get_string("action")..") doesn't exist.")
        return
    end
    
    -- Verify the logic
    local actiondata = interactive_item.actions[meta:get_string("action")]
    
    if not actiondata.logics then
        minetest.chat_send_player(player:get_player_name(), "Action has no logics.")
        return
    elseif not actiondata.logics[logic] then
        minetest.chat_send_player(player:get_player_name(), "This logic doesn't exist in the current action's base data.")
        return
    else
        return actiondata.logics[logic](item, command, player, vars)
    end
end