local esc = minetest.formspec_escape

local bodyparts = {
	{"Head", "Head", "head"},
	{"Body", "Body", "body"},
	{"Arm_Left", "Left Arm", "left_arm"},
	{"Arm_Right", "Right Arm", "right_arm"},
	{"Leg_Left", "Left Leg", "left_leg"},
	{"Leg_Right", "Right Leg", "right_leg"}
}

-- Mannequin

item_holders.register_holder("item_holders:mannequin", {
	description = "Mannequin",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, 7/16, 0.5, 0.5, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.4375, -0.25, 0.25, 0.5, 0.25},
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.4375, -0.25, 0.25, 1.4, 0.25},
		},
	},
	tiles = {"blank.png"},
	inventory_image = "item_holders_mannequin.png",
	wield_image = "item_holders_mannequin.png",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	itemcase = "armors",
	groups = {choppy = 3, oddly_breakable_by_hand = 1, itemcases = 1},
	pre_entity_mod = function(ent, pos)
	    local meta = minetest.get_meta(pos)
	    local chartex = "character.png"
	
	    if meta:get_string("character") == "" then
	        meta:set_string("character", chartex)
	    end
	    chartex = meta:get_string("character")
	
	    ent:set_properties({visual_size = {x=1,y=1,z=1}, visual = "mesh", mesh = "3d_armor_character.b3d", textures = {chartex, "blank.png", "blank.png"}})
	    -- Set a emote
	    item_holders.use_emote(ent, meta)
	end,
	pos_entity_mod = function(ent, pos)
		meta = minetest.get_meta(pos)
		
	    -- Set yaw
	    local yawi = item_holders.ypos(tonumber(meta:get_string("yaw")))
	    ent:set_yaw(((yawi / 2) * math.pi))
	end,
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		local node = minetest.get_node(pos)
		meta:set_string("owner", "")
		local inv = meta:get_inventory()
		inv:set_size("itemcase", 8)
		
		local rot = node.param2 % 4
	    local yaw = 0
	
        if rot == 1 then
			yaw = 1
		elseif rot == 2 then
			yaw = 4
		elseif rot == 3 then
			yaw = 3
		elseif rot == 0 then
			yaw = 2
		end
		
		meta:set_string("formspec", item_holders.mannequin_formspec(yaw))
		meta:set_string("yaw", yaw)
		
		item_holders.process_emote(item_holders.default_emote, meta)
	end,
	on_receive_fields = function(pos, formname, fields, player)
	    local meta = minetest.get_meta(pos)
		local name = player:get_player_name()
		local owner = meta:get_string("owner")
		if owner == name then
		    local dsave = false
		    -- Verify
		    if meta:get_string("page") == "" then
				meta:set_string("page", "inv")
		    end
		    -- Page Change
		    if fields.page_inv then
				meta:set_string("page", "inv")
			    dsave = true
			elseif fields.page_mod then
				meta:set_string("page", "mod")
		        dsave = true
		    elseif fields.body_full then
		        meta:set_string("page", "body")
		        meta:set_string("viewbody", "full")
		        dsave = true
		    end
		    -- Body Modification
		    for i in ipairs(bodyparts) do
		        if fields["bodycc_"..bodyparts[i][1]] then
		            meta:set_string("page", "body")
		            meta:set_string("viewbody", bodyparts[i][1])
		            dsave = true
		        end
		    end
		    -- Saving
	    	if fields.save or dsave then
	            if fields.yawi then
		        	meta:set_string("yaw", item_holders.ypos(tonumber(fields.yawi or 0)))
		        end
		        -- Build tables based on bones output
		        if fields.xrot then
		            local adi = meta:get_string("viewbody")
					meta:set_string(adi.."_x-pos", item_holders.tpos(tonumber(fields.xpos or 0)))
					meta:set_string(adi.."_y-pos", item_holders.typos(tonumber(fields.ypos or 0)))
					meta:set_string(adi.."_z-pos", item_holders.tpos(tonumber(fields.zpos or 0)))
					meta:set_string(adi.."_x-scale", item_holders.spos(tonumber(fields.xscale or 0)))
					meta:set_string(adi.."_y-scale", item_holders.spos(tonumber(fields.yscale or 0)))
					meta:set_string(adi.."_z-scale", item_holders.spos(tonumber(fields.zscale or 0)))
					meta:set_string(adi.."_x-rot", item_holders.ypos(tonumber(fields.xrot or 0)))
					meta:set_string(adi.."_y-rot", item_holders.ypos(tonumber(fields.yrot or 0)))
					meta:set_string(adi.."_z-rot", item_holders.ypos(tonumber(fields.zrot or 0)))
		        end
    		end
            -- Loading pages
            if meta:get_string("page") == "inv" then
                meta:set_string("formspec", "size[8,8]" ..
	                "list[current_name;itemcase;3,0.5;4,2;]" ..
	                "list[current_player;main;0,3;8,1;]" ..
	                "list[current_player;main;0,4.25;8,3;8]" ..
	                -- Save
	                "button[0,7.3;3,1;save;Save]"..
	                "button[5,7.3;3,1;page_mod;Editor]")
            elseif meta:get_string("page") == "mod" then
                local bp = ""
		    	for i in ipairs(bodyparts) do
		    	    local bone = bodyparts[i]
		
		            local bx = (i%2)*5
		
		            local by = 1.4 + (math.floor((i-1)/2) * 2)
		            -- We have to make 6 text areas.
					bp = bp .. "label["..bx..",".. by - -0.1 ..";"..bone[2].."]" ..
					-- Now!
					"textarea[".. bx + 0.2 ..",".. by + 0.7 ..";1,0.7;"..bone[1].."_xpos;X Pos;".. esc(meta:get_string(bone[1].."_xpos")) .."]"..
					"textarea[".. bx + 1.2 ..",".. by + 0.7 ..";1,0.7;"..bone[1].."_ypos;Y Pos;".. esc(meta:get_string(bone[1].."_ypos")) .."]"..
		    	    "textarea[".. bx + 2.2 ..",".. by + 0.7 ..";1,0.7;"..bone[1].."_zpos;Z Pos;".. esc(meta:get_string(bone[1].."_zpos")) .."]"..
		
		    	    "textarea[".. bx + 0.2 ..",".. by + 1.7 ..";1,0.7;"..bone[1].."_xrot;X Rot;".. esc(meta:get_string(bone[1].."_xrot")) .."]"..
		    	    "textarea[".. bx + 1.2 ..",".. by + 1.7 ..";1,0.7;"..bone[1].."_yrot;Y Rot;".. esc(meta:get_string(bone[1].."_yrot")) .."]"..
		    	    "textarea[".. bx + 2.2 ..",".. by + 1.7 ..";1,0.7;"..bone[1].."_zrot;Z Rot;".. esc(meta:get_string(bone[1].."_zrot")) .."]"	
		    	end
		
                meta:set_string("formspec", "size[12,8]" ..
                    "no_prepend[]"..
                    -- Properties
                    "button[4.5,0;3,1;body_full;Full Body]"..
                    -- Bones
                    "button[0,1;1.5,1;bodycc_Head;Head]"..
                    "button[10.5,1;1.5,1;bodycc_Body;Body]"..
                    "button[0,2;1.5,1;bodycc_Arm_Left;Left Arm]"..
                    "button[10.5,2;1.5,1;bodycc_Arm_Right;Right Arm]"..
                    "button[0,3;1.5,1;bodycc_Leg_Left;Left Leg]"..
                    "button[10.5,3;1.5,1;bodycc_Leg_Right;Right Leg]"..
                    -- Nice View
                    "bgcolor[#80808040]"..
	                -- Save
	                "button[0,7.3;3,1;save;Save]"..
	                "button[9,7.3;3,1;page_inv;Inventory]")
	        elseif meta:get_string("page") == "body" then
	            local fp = "size[12,8]" .. "no_prepend[]"
	            if meta:get_string("viewbody") == "full" then
			    	fp = fp .. "label[0,-0.1;Full Body]"..
			
		                "image[10.7,1.2;1,1;ihm_rot.png]"..
		            	"textarea[10.4,2.7;2,1;yawi;Yaw;".. esc(meta:get_string("yaw")) .."]"..
		                "image[5.5,0.2;1,1;ihm_full.png]"
	            end
	            -- It's a bone?
	            for i in ipairs(bodyparts) do
	                local bd = bodyparts[i]
	                if meta:get_string("viewbody") == bd[1] then
					    fp = fp .. "label[0,-0.1;".. bd[2] .."]"..
					    	"image[0,1.2;1,1;ihm_move.png]"..
		                	"textarea[0.2,2.7;1,1;xpos;X;".. esc(meta:get_string(bd[1].."_x-pos")) .."]"..
		                	"textarea[0.2,4.0;1,1;ypos;Y;".. esc(meta:get_string(bd[1].."_y-pos")) .."]"..
		                	"textarea[0.2,5.3;1,1;zpos;Z;".. esc(meta:get_string(bd[1].."_z-pos")) .."]"..
		
		                    "image[1,1.2;1,1;(ihm_scale.png^[colorize:#80808080)]"..
		                    "textarea[1.2,2.7;1,1;xscale;X;".. esc(meta:get_string(bd[1].."_x-scale")) .."]"..
		                	"textarea[1.2,4.0;1,1;yscale;Y;".. esc(meta:get_string(bd[1].."_y-scale")) .."]"..
		                	"textarea[1.2,5.3;1,1;zscale;Z;".. esc(meta:get_string(bd[1].."_z-scale")) .."]"..
		
		                    "image[11,1.2;1,1;(ihm_rot.png^[colorize:#80808080)]"..
		                	"textarea[11.4,2.7;1,1;xrot;X;".. esc(meta:get_string(bd[1].."_x-rot")) .."]"..
		                    "textarea[11.4,4.0;1,1;yrot;Y;".. esc(meta:get_string(bd[1].."_y-rot")) .."]"..
		                    "textarea[11.4,5.3;1,1;zrot;Z;".. esc(meta:get_string(bd[1].."_z-rot")) .."]"..
		                    "image[5.5,0.2;1,1;ihm_"..bd[3]..".png]"
		
		                break
					end
	            end
	            -- Always
				meta:set_string("formspec", fp..
				    -- Nice View
				    "bgcolor[#80808040]"..
				    -- Save
	                "button[0,7.3;3,1;save;Save]"..
	                "button[9,7.3;3,1;page_mod;Editor]")
            end
	    end
	end
})
