item_holders.register_holder("item_holders:stone_pedestal", {
	description = "Stone Pedestal",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
            {-0.5, -0.5, -0.5, 0.5, -0.3, 0.5},
		}
	},
	tiles = {"default_stone.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	delete_unused = true,
	itemcase = "items",
	moveitem = {
		[0] = {x=0,y=0.25,z=0},
		[1] = {x=0,y=0.25,z=0},
		[2] = {x=0,y=0.25,z=0},
		[3] = {x=0,y=0.25,z=0},
	},
	ic_mods = {
	    "blank.png",
	    "[transformFYR180",
	    "[transformFYR270",
	    "[transformFYR360",
        "[transformR270",
        "[transformR180",
        "[transformR90",
        "blank.png"
	},
	groups = {cracky = 3, itemcases = 1},
	pre_entity_mod = function(ent, pos)
	    ent:set_properties({automatic_rotate = 0.5})
	end,
})

--=====
-- Futuristic
--=====

local futuristic_particle = function(color, pos)
    minetest.add_particlespawner({
		amount = math.random(1, 6),
		pos = pos,
		minvel = {x = -2, y = -2, z = -2},
		maxvel = {x = 2, y = 2, z = 2},
		expirationtime = 10,
		minsize = min_size,
		maxsize = max_size,
		texture = "item_holders_energy.png^[colorize:"..color
	})
end

local fptable = {
	{"Red", "red", "#FF0000"},
	{"Orange", "orange", "#FF8000"},
	{"Yellow", "yellow", "#FFFF00"},
	{"Green", "green", "#00FF00"},
	{"Blue", "blue", "#0000FF"},
	{"Cyan", "cyan", "#00FFFF"},
	{"Violet", "violet", "#8000FF"},
	
	{"White", "white", "#FFFFFF"},
	{"Black", "black", "#000000"}
}

for i in ipairs(fptable) do

local ido = fptable[i][2]
local namo = fptable[i][1]
local imgo = "item_holders_fpedestal.png"
local colo = "default_steel_block.png^(" .. imgo .. "^[colorize:" .. fptable[i][3] .. ")"
local coloro = fptable[i][3]

item_holders.register_holder("item_holders:"..ido.."_futuristic_pedestal", {
	description = namo.." Futuristic Pedestal",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
            {-0.5, -0.50, -0.5, 0.5, -0.45, 0.5},
            {-0.4, -0.45, -0.4, 0.4, -0.40, 0.4},
            {-0.3, -0.40, -0.3, 0.3, -0.35, 0.3},
            {-0.2, -0.35, -0.2, 0.2, -0.30, 0.2},
            {-0.1, -0.30, -0.1, 0.1, -0.25, 0.1},
            
            {-0.1,  0.25, -0.1, 0.1,  0.30, 0.1},
            {-0.2,  0.30, -0.2, 0.2,  0.35, 0.2},
            {-0.3,  0.35, -0.3, 0.3,  0.40, 0.3},
            {-0.4,  0.40, -0.4, 0.4,  0.45, 0.4},
            {-0.5,  0.45, -0.5, 0.5,  0.50, 0.5},
		}
	},
	light_source = 16,
	tiles = {colo, colo, "default_steel_block.png", "default_steel_block.png", "default_steel_block.png", "default_steel_block.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	delete_unused = true,
	itemcase = "items",
	moveitem = {
		[0] = {x=0,y=0,z=0},
		[1] = {x=0,y=0,z=0},
		[2] = {x=0,y=0,z=0},
		[3] = {x=0,y=0,z=0},
	},
	ic_mods = {
	    "blank.png",
	    "[transformFYR180",
	    "[transformFYR270",
	    "[transformFYR360",
        "[transformR270",
        "[transformR180",
        "[transformR90",
        "blank.png"
	},
	groups = {cracky = 1, futuristic_pedestal = 1, itemcases = 1},
	pre_entity_mod = function(ent, pos)
	    ent:set_properties({visual_size = {x = 0.5, y = 0.5, z = 0.01}, automatic_rotate = 0.5})
	end,
})

end