local wlist = {
	{"Apple", "wood", "wood"},
	{"Aspen", "aspen", "aspen_wood"},
	{"Pine", "pine", "pine_wood"},
	{"Jungle Wood", "junglewood", "junglewood"},
	{"Acacia", "acacia", "acacia_wood"},
}

for i in ipairs(wlist) do
local wname = wlist[i][1]
local wid = wlist[i][2]
local wii = wlist[i][3]

item_holders.register_holder("item_holders:"..wid.."_plant_pot", {
	description = wname.." Plant Pot",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
            {-0.25, -0.5, -0.25, 0.25, -0.2, 0.25},
        },
	},
	tiles = {"default_dirt.png", "default_"..wii..".png", "default_"..wii..".png", "default_"..wii..".png", "default_"..wii..".png", "default_"..wii..".png"},
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	itemplacehold = "blank.png",
	delete_unused = true,
	is_itemcase = true,
	moveitem = {
		[0] = {x= 0,y=0.235,z= 0},
		[1] = {x= 0,y=0.235,z= 0},
		[2] = {x= 0,y=0.235,z= 0},
		[3] = {x= 0,y=0.235,z= 0},
	},
	itemcase = "items",
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos, img, aimg)
	    ent:set_properties({visual_size = {x=5,y=8.5,z=5}, visual = "mesh", mesh = "item_holders_plantlike.obj", textures = {img, img, img, img}})
	end,
})

item_holders.register_holder("item_holders:tall_"..wid.."_plant_pot", {
	description = "Tall "..wname.." Plant Pot",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
            {-0.35, -0.5, -0.35, 0.35, -0.05, 0.35},
        },
	},
	tiles = {"default_dirt.png", "default_"..wii..".png", "default_"..wii..".png", "default_"..wii..".png", "default_"..wii..".png", "default_"..wii..".png"},
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	itemplacehold = "blank.png",
	delete_unused = true,
	is_itemcase = true,
	moveitem = {
		[0] = {x= 0,y=0.37,z= 0},
		[1] = {x= 0,y=0.37,z= 0},
		[2] = {x= 0,y=0.37,z= 0},
		[3] = {x= 0,y=0.37,z= 0},
	},
	itemcase = "items",
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos, img, aimg)
	    ent:set_properties({visual_size = {x=7,y=8.5,z=7}, visual = "mesh", mesh = "item_holders_high_plantlike.obj", textures = {img, img, img, img}})
	end
})

end