-- Helper function for item_holders.iemotes.
item_holders = {}
item_holders.iemotes = {}
item_holders.niemotes = {}
item_holders.register_emote = function(id, func)
    -- Function
    item_holders.iemotes[id] = func
    -- Numerical Table
    table.insert(item_holders.niemotes, id)
end

local modpath = minetest.get_modpath("item_holders")

dofile(modpath.."/emotes.lua")
dofile(modpath.."/helpers.lua")

local esc = minetest.formspec_escape

item_holders.pose_selector = function()
	local formpart = "label[8,1.2;Poses]"
			
    formpart = formpart .. "tablecolumns[text]"
    formpart = formpart .. "table[8,1.7;4.5,6.3;emote;"
    formpart = formpart .. "Pose"
			
     for i in ipairs(item_holders.niemotes) do
         local id = item_holders.niemotes[i]
         formpart = formpart .. "," .. id
     end
			
     formpart = formpart .. "]"
     
     return formpart
end

item_holders.tpos = function(num)
if not num then return 0 end

if num >= 2 then
num = 2
elseif -2 >= num then
num = -2
end

return math.floor(num*100)/100
end
item_holders.typos = function(num)
if not num then return 0 end

if num >= 12 then
num = 12
elseif -12 >= num then
num = -12
end

return math.floor(num*100)/100
end

item_holders.spos = function(num)
if not num then return 0 end

if num >= 2.5 then
num = 2.5
elseif -2.5 >= num then
num = -2.5
end

return math.floor(num*100)/100
end

item_holders.ypos = function(num)
if not num then return 0 end

if num >= 4 then
num = 4
elseif 0 >= num then
num = 0
end

return math.floor(num*100)/100
end

item_holders.rypos = function(num)
if not num then return 0 end

if num >= 4 then
num = 4
elseif -4 >= num then
num = -4
end

return math.floor(num*100)/100
end

--=====
-- Done
--=====

-- Item Frames
item_holders.itemframe_formspec = "size[8,7]" ..
	"list[current_name;itemcase;3,0.5;4,2;]" ..
	"list[current_player;main;0,3;8,1;]" ..
	"list[current_player;main;0,4.25;8,3;8]"
-- Mannequin
item_holders.mannequin_formspec = function(yaw)
     if not yaw then yaw = 0 end

    return "size[8,8]" ..
	    "list[current_name;itemcase;3,0.5;4,2;]" ..
	    "list[current_player;main;0,3;8,1;]" ..
	    "list[current_player;main;0,4.25;8,3;8]" ..
	    -- Save
	    "button[0,7.3;3,1;save;Save]"..
	    "button[5,7.3;3,1;page_mod;Editor]"
end

local escape_image = function(img)
    img = string.gsub(img, ":", "\\:")
    return img
end

local facedir = {}

facedir[0] = {x = 0, y = 0, z = 0.49}
facedir[1] = {x = 0.49, y = 0, z = 0}
facedir[2] = {x = 0, y = 0, z = -0.49}
facedir[3] = {x = -0.49, y = 0, z = 0}

get_itemcase = function(pos, nodef)
	local object = nil
	local objects = minetest.get_objects_inside_radius(pos, 0.5) or {}
	for _, obj in pairs(objects) do
		local e = obj:get_luaentity()
		if e then
			if e.name == "item_holders:itemcase_entity" then
				-- If object already exists, remove it, it's duplicated
				if object then
					obj:remove()
				else
					object = obj
				end
			end
		end
	end
	return object
end
--
update_itemcase = function(pos)
    local node = minetest.get_node(pos)
    if not node then return end
    local nodef = minetest.registered_nodes[node.name]
    if not nodef then return end
    
    local epos = {x = pos.x, y = pos.y, z = pos.z}
    
    local metii = minetest.get_meta(pos)
    local invii = metii:get_inventory()
	if nodef.delete_unused and invii:is_empty("itemcase") then
	    local object = get_itemcase(epos)
	    if object then
	        object:remove()
	    end
	
        return
    end
    
    if nodef.itemcase == "items" then
        local posad = {x = 0, y = 0, z = 0}
        if nodef.moveitem and nodef.moveitem[node.param2] then
        posad = nodef.moveitem[node.param2]
        else
		posad = facedir[node.param2]
		end
		
		if not posad then return end
		epos.x = epos.x + posad.x
		epos.y = epos.y + posad.y
		epos.z = epos.z + posad.z
	end
	
	local object = get_itemcase(epos, nodef)
	if object then
	-- Apply entity mod
	if nodef.pre_entity_mod then
	nodef.pre_entity_mod(object, epos)
	end
		if not nodef.is_itemcase == true then
			object:remove()
			return
		end
		if nodef.delete_unused and invii:is_empty("itemcase") then
		    object:remove()
		    return
		end
	else
		object = minetest.add_entity(epos, "item_holders:itemcase_entity")
	end
	
	if object then
	-- Textures
	local meta = minetest.get_meta(epos)
	local inv = meta:get_inventory()
	local texture = ""
	
	if nodef.itemcase == "items" then
	    texture = nodef.itemplacehold or "item_holders_itemframe.png"
	else
    	texture = "blank.png"
	end
	
	local atexture = "blank.png"
	
	local tt = "blank.png^[resize:".. (nodef.bsize or "256x256")
	local tile = {tt, tt, tt, tt, tt, tt}
	local itextures = {}
	local textures = {}
	local atextures = {}
	
	local pit = nodef.preitem or function(itemi) return "" end
	local pet = nodef.positem or function(itemk) return "" end
	
	if inv then
		for i = 1, inv:get_size("itemcase") do
			local stack = inv:get_stack("itemcase", i)
			if stack:get_count() >= 1 then
			local item = stack:get_name() or ""
			local meta = stack:get_meta() or ""
			local def = stack:get_definition() or {}
			local groups = def.groups or {}
    	    --====
		    -- Items
	        --====
			if nodef.itemcase == "items" then
			
			    -- Inventory Image With Rotation
			    if nodef.ic_mods and def.inventory_image and not (def.tiles and def.tiles[2]) then
			        local img = def.inventory_image
			        if meta:get_string("inventory_image") ~= "" then
                        img = meta:get_string("inventory_image")
                    end
			        table.insert(textures, pit(i) .. "("..escape_image(img, nodef.escape_item).."^[resize\\:256x256^"..nodef.ic_mods[i]..")".. pet(i))
			    -- Inventory Image
				elseif def.inventory_image and not (def.tiles and def.tiles[2]) then
				    local img = def.inventory_image
			        if meta:get_string("inventory_image") ~= "" then
                        img = meta:get_string("inventory_image")
                    end
					table.insert(textures, pit(i) .. "("..escape_image(img, nodef.escape_item).."^[resize\\:256x256)".. pet(i))
				-- Tiles
				elseif def.tiles then
				
				    local dt = def.tiles
				    for i = 1, 6 do
				        -- No animated support
				        if dt[i] and not dt[i].name then
				            if dt[i] then
				                tile[i] = "(".. dt[i] ..")^[resize:".. (nodef.bsize or "256x256")
				            else
				                tile[i] = "(".. dt[1] ..")^[resize:".. (nodef.bsize or "256x256")
				            end
				        end
				    end
		
				end
				--=======
				-- Armors
				--=======
				elseif nodef.itemcase == "armors" then
				    -- First verify if item is NOT a armor item
				    local is_armor = false
				
				    local elements = {"head", "torso", "legs", "feet", "shield"}
					
					for _, element in pairs(elements) do
					if is_armor == true then break end
				    	if groups['armor_' .. element] then
					        is_armor = true
				    	end
					end
				
				    -- IT IS ARMOR
				    if is_armor == true then
				        table.insert(atextures, "(".. item:gsub("%:", "_") ..".png^[resize:256x128)")
				
				    -- IT ISN'T ARMOR
				    else
			            if nodef.ic_mods and def.inventory_image and not (def.tiles and def.tiles[2]) then
			                local img = def.inventory_image
			                if meta:get_string("inventory_image") ~= "" then
                                img = meta:get_string("inventory_image")
                            end
			                table.insert(textures, pit(i) .. "("..escape_image(img, nodef.escape_item).."^[resize\\:256x256^"..nodef.ic_mods[i]..")".. pet(i))
			             -- Inventory Image
			        	elseif def.inventory_image and not (def.tiles and def.tiles[2]) then
				            local img = def.inventory_image
			                if meta:get_string("inventory_image") ~= "" then
                                img = meta:get_string("inventory_image")
                            end
				        	table.insert(textures, pit(i) .. "("..escape_image(img, nodef.escape_item).."^[resize\\:256x256)".. pet(i))
			        	-- Tiles
			        	elseif def.tiles then
				            local dt = def.tiles
				            for i = 1, 6 do
				                -- No animated support
				                if dt[i] and not dt[i].name then
				                    if dt[i] then
				                        tile[i] = "(".. dt[i] ..")^[resize:".. (nodef.bsize or "256x256")
				                    else
				                        tile[i] = "(".. dt[1] ..")^[resize:".. (nodef.bsize or "256x256")
				                    end
				                end
				            end
				         end
					end
				    
				end
			end
		end
	end
	if #textures > 0 then
		texture = (nodef.background or "") .. table.concat(textures, "^")
	end
	if #textures > 0 then
	    for i in ipairs(textures) do
	        itextures[i] = (nodef.background or "") .. textures[i]
	    end
	end
	if #atextures > 0 then
	    atexture = table.concat(atextures, "^")
	end
	-- Item Stuff
	if nodef.itemcase == "items" then
		local yaw = math.pi * 2 - node.param2 * math.pi / 2
		object:set_yaw(yaw)
		
		if not nodef.itemcase2 or nodef.itemcase2 == 1 then -- Place only behind and forward
		object:set_properties({textures={tile[1], tile[2], tile[3], tile[4], tile[5].."^"..texture, tile[6].."^"..texture.."^[transformFYR180"}})
		elseif nodef.itemcase2 == 2 then -- Place only above and below
	    object:set_properties({textures={tile[1] .."^".. texture .. "^[transformFYR180", tile[2] .."^".. texture .. "^[transformR180", tile[3], tile[4], tile[5], tile[6]}})
	    end
		
	end
	if nodef.itemcase == "armors" then
	    local rot = node.param2 % 4
	    local yaw = 0
	
        if rot == 1 then
			yaw = 1 * math.pi / 2
		elseif rot == 2 then
			yaw = 2 * math.pi
		elseif rot == 3 then
			yaw = 3 * math.pi / 2
		elseif rot == 0 then
			yaw = 3 * math.pi
		end
		
		local chartex = meta:get_string("character")
		
		if chartex == "" then
		    chartex = "character.png"
		end
		
		object:set_yaw(yaw)
		object:set_properties({textures={chartex.."^[resize:256x128", atexture, texture}})
	end
	-- Apply last entity mod, this one provides the texture and atextures
	if nodef.pos_entity_mod then
	nodef.pos_entity_mod(object, pos, texture, atexture, itextures)
	end
	end
end

--

local ent_timer = 0
minetest.register_entity("item_holders:itemcase_entity", {
	physical = false,
	visual = "cube",
	visual_size = {x=1, y=1, z=0.01},
	collisionbox = {0,0,0,0,0,0},
	glow = 0,
	textures = {
		"blank.png",
		"blank.png",
        "blank.png",
        "blank.png",
        "item_holders_itemframe.png",
        "item_holders_itemframe.png"
    },
    parent_pos = nil,
	timer = 0,
	on_activate = function(self)
		local pos = self.object:get_pos()
	end,
	on_step = function(self, dtime)
	    ent_timer = ent_timer + dtime
	    if ent_timer >= 3 then
	    ent_timer = 0
	    local pos = vector.round(self.object:get_pos())
	    if #minetest.find_nodes_in_area(
				{x = pos.x, y = pos.y, z = pos.z},
				{x = pos.x, y = pos.y, z = pos.z},
				{"group:itemcases"}) < 0 then
			self.object:remove()
		else
		    update_itemcase(pos)
		end
		end
	end
})

--====
-- Stuff
--====
-- Armor
if minetest.get_modpath("3d_armor") then
    dofile(modpath.."/comps/armor_display.lua")
end
-- Items
dofile(modpath.."/comps/item_display/itemframes.lua")
dofile(modpath.."/comps/item_display/pots.lua")
dofile(modpath.."/comps/item_display/pedestals.lua")
dofile(modpath.."/comps/item_display/shelves.lua")

--==========
-- Mannequins
--==========

--=====
-- Plates
--=====

minetest.register_node("item_holders:meal_plate", {
	description = "Meal Plate",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
            {-0.5, -7/16, -0.5, 0.5, -0.5, 0.5},
        },
	},
	tiles = {"default_wood.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	itemplacehold = "blank.png",
	delete_unused = true,
	is_itemcase = true,
	moveitem = {
		[0] = {x= 0,y=0.37,z= 0},
		[1] = {x= 0,y=0.37,z= 0},
		[2] = {x= 0,y=0.37,z= 0},
		[3] = {x= 0,y=0.37,z= 0},
	},
	itemcase = "items",
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos, img, aimg, iimg)
	    local bl = "blank.png"
	    ent:set_properties({visual_size = {x=10,y=10,z=0.01}, visual = "mesh", mesh = "item_holders_meal_plate.obj", textures = {iimg[1] or bl, iimg[2] or bl, iimg[3] or bl, iimg[4] or bl}})
	end,
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", item_holders.itemframe_formspec)
		meta:set_string("owner", "")
		local inv = meta:get_inventory()
		inv:set_size("itemcase", 8)
	end,
	can_dig = function(pos, player)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		local name = player:get_player_name()
		local owner = meta:get_string("owner")
		if owner == name then
			return inv:is_empty("itemcase")
		end
		return false
	end,
	after_place_node = function(pos, placer)
		local meta = minetest.get_meta(pos)
		meta:set_string("owner", placer:get_player_name() or "")
		meta:set_string("infotext", "Flower Pot (owned by "..meta:get_string("owner")..")")
	    local timer = minetest.get_node_timer(pos)
		timer:start(1)
	end,
	on_timer = function(pos)
	    local timer = minetest.get_node_timer(pos)
	    update_itemcase(pos)
	    timer:start(1)
	end,
	allow_metadata_inventory_put = function(pos, listname, index, stack, player)
		local meta = minetest.get_meta(pos)
		local name = player:get_player_name()
		local owner = meta:get_string("owner")
		if owner == name then
			return stack:get_count()
		end
		return 0
	end,
	allow_metadata_inventory_take = function(pos, listname, index, stack, player)
		local meta = minetest.get_meta(pos)
		local name = player:get_player_name()
		local owner = meta:get_string("owner")
		if owner == name then
			return stack:get_count()
		end
		return 0
	end,
	allow_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
		local meta = minetest.get_meta(pos)
		local name = player:get_player_name()
		local owner = meta:get_string("owner")
		if owner == name then
			return count
		end
		return 0
	end,
	on_metadata_inventory_put = function(pos)
		update_itemcase(pos)
	end,
	on_metadata_inventory_take = function(pos)
		update_itemcase(pos)
	end,
	after_destruct = function(pos)
		update_itemcase(pos)
	end,
})

-- Recipes

dofile(modpath.."/recipes.lua")