local esc = minetest.formspec_escape

local MSN = function(string, msize)
    msize = msize or 200
    
    string = string:sub(1, msize)
    string = string:gsub("\r\n", "\n"):gsub("\r", "\n")
    string = string:gsub("[%z\1-\8\11-\31\127]", "")
    
    return string
end

local bodyparts = {
	{"Head", "Head", "head"},
	{"Body", "Body", "body"},
	{"Arm_Left", "Left Arm", "left_arm"},
	{"Arm_Right", "Right Arm", "right_arm"},
	{"Leg_Left", "Left Leg", "left_leg"},
	{"Leg_Right", "Right Leg", "right_leg"}
}

-- Helper Funcs

local shoot_particles = function(tex, pos, beh)
    beh = beh or "upfall"
    
    if beh == "upfall" then
        minetest.add_particlespawner({
        	amount = math.random(6, 12),
        	time = 0.30,
        	minpos = {x=pos.x-1, y=pos.y, z=pos.z-1},
        	maxpos = {x=pos.x+1, y=pos.y, z=pos.z+1},
        	minvel = {x = 0, y = 1, z = 0},
        	maxvel = {x = 0, y = 3, z = 0},
        	minacc = {x = 0, y = 0.5, z = 0},
        	maxacc = {x = 0, y = 1, z = 0},
        	minexptime = 0.5,
        	maxexptime = 1,
        	minsize = 0.5,
        	maxsize = 1.0,
        	texture = tex,
	        glow = 3
        })
    end
end

-- Mannequin

item_holders.register_holder("item_holders:mannequin", {
	description = "Mannequin",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, 7/16, 0.5, 0.5, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.4375, -0.25, 0.25, 0.5, 0.25},
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.4375, -0.25, 0.25, 1.4, 0.25},
		},
	},
	tiles = {"blank.png"},
	inventory_image = "item_holders_mannequin.png",
	wield_image = "item_holders_mannequin.png",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	itemcase = "armors",
	groups = {choppy = 3, oddly_breakable_by_hand = 1, itemcases = 1},
	pre_entity_mod = function(ent, pos)
	    local meta = minetest.get_meta(pos)
	    local chartex = "character.png"
	
	    if meta:get_string("character") == "" then
	        meta:set_string("character", chartex)
	    end
	    chartex = meta:get_string("character")
	
	    ent:set_properties({visual_size = {x=1,y=1,z=1}, visual = "mesh", mesh = "3d_armor_character.b3d", textures = {chartex, "blank.png", "blank.png"}})
	    -- Set a emote
	    item_holders.use_emote(ent, meta)
	end,
	pos_entity_mod = function(ent, pos)
		meta = minetest.get_meta(pos)
		
	    -- Set yaw
	    local yawi = item_holders.ypos(tonumber(meta:get_string("yaw")))
	    ent:set_yaw(((yawi / 2) * math.pi))
	
	    -- Particles
	    if meta:get_string("particle_tex") ~= "" then
	        local ppos = {
		        x = pos.x + (tonumber(meta:get_string("p_x")) or 0),
		        y = pos.y + (tonumber(meta:get_string("p_y")) or 0),
		        z = pos.z + (tonumber(meta:get_string("p_z")) or 0)
		    }
	
	        shoot_particles(meta:get_string("particle_tex"), ppos)
	    end
	end,
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		local node = minetest.get_node(pos)
		meta:set_string("owner", "")
		local inv = meta:get_inventory()
		inv:set_size("itemcase", 8)
		
		local rot = node.param2 % 4
	    local yaw = 0
	
        if rot == 1 then
			yaw = 1
		elseif rot == 2 then
			yaw = 4
		elseif rot == 3 then
			yaw = 3
		elseif rot == 0 then
			yaw = 2
		end
		
		meta:set_string("formspec", item_holders.mannequin_formspec(yaw))
		meta:set_string("yaw", yaw)
		
		item_holders.process_emote(item_holders.default_emote, meta)
	end,
	on_receive_fields = function(pos, formname, fields, player)
	    local meta = minetest.get_meta(pos)
		local name = player:get_player_name()
		local owner = meta:get_string("owner")
		if owner == name then
		    local dsave = false
		    -- Verify
		    if meta:get_string("page") == "" then
				meta:set_string("page", "inv")
		    end
		    -- Page Change
		    if fields.page_inv then
				meta:set_string("page", "inv")
			    dsave = true
			elseif fields.page_mod then
				meta:set_string("page", "mod")
		        dsave = true
		    elseif fields.body_full then
		        meta:set_string("page", "body")
		        meta:set_string("viewbody", "full")
		        dsave = true
		    elseif fields.page_particles then
		        meta:set_string("page", "body")
		        meta:set_string("viewbody", "particles")
		        dsave = true
		    elseif fields.page_special then
		        meta:set_string("page", "body")
		        meta:set_string("viewbody", "special")
		        dsave = true
		    end
		    -- Body Modification
		    for i in ipairs(bodyparts) do
		        if fields["bodycc_"..bodyparts[i][1]] then
		            meta:set_string("page", "body")
		            meta:set_string("viewbody", bodyparts[i][1])
		            dsave = true
		        end
		    end
		    -- Saving
	    	if fields.save or fields.key_enter or dsave then
	            if fields.yawi then
		        	meta:set_string("yaw", item_holders.ypos(tonumber(fields.yawi or 0)))
		        end
		        -- Build tables based on bones output
		        if fields.xrot then
		            local adi = meta:get_string("viewbody")
		            if meta:get_string("viewbody") == "Body" then
				    	meta:set_string(adi.."_x-pos", item_holders.typos(tonumber(fields.xpos or 0)))
				    	meta:set_string(adi.."_y-pos", item_holders.typos(tonumber(fields.ypos or 0)))
				    	meta:set_string(adi.."_z-pos", item_holders.typos(tonumber(fields.zpos or 0)))
				    else
			        	meta:set_string(adi.."_x-pos", item_holders.tpos(tonumber(fields.xpos or 0)))
				    	meta:set_string(adi.."_y-pos", item_holders.tpos(tonumber(fields.ypos or 0)))
				    	meta:set_string(adi.."_z-pos", item_holders.tpos(tonumber(fields.zpos or 0)))
				    end
					meta:set_string(adi.."_x-scale", item_holders.spos(tonumber(fields.xscale or 0)))
					meta:set_string(adi.."_y-scale", item_holders.spos(tonumber(fields.yscale or 0)))
					meta:set_string(adi.."_z-scale", item_holders.spos(tonumber(fields.zscale or 0)))
					meta:set_string(adi.."_x-rot", item_holders.rypos(tonumber(fields.xrot or 0)))
					meta:set_string(adi.."_y-rot", item_holders.rypos(tonumber(fields.yrot or 0)))
					meta:set_string(adi.."_z-rot", item_holders.rypos(tonumber(fields.zrot or 0)))
		        end
		        -- Particle generation
				if fields.particle_tex then
				    meta:set_string("particle_tex", minetest.formspec_escape(MSN(fields.particle_tex, 100)))
				
				    meta:set_string("p_x", item_holders.tpos(tonumber(fields.p_x or 0)))
					meta:set_string("p_y", item_holders.tpos(tonumber(fields.p_y or 0)))
					meta:set_string("p_z", item_holders.tpos(tonumber(fields.p_z or 0)))
				end
				-- Special
				if fields.character then
				    meta:set_string("character", MSN(fields.character, 100))
				end
    		end
            -- Loading pages
            if meta:get_string("page") == "inv" then
                meta:set_string("formspec", "size[8,8]" ..
	                "list[current_name;itemcase;3,0.5;4,2;]" ..
	                "list[current_player;main;0,3;8,1;]" ..
	                "list[current_player;main;0,4.25;8,3;8]" ..
	                -- Save
	                "button[0,7.3;3,1;save;Save]"..
	                "button[5,7.3;3,1;page_mod;Editor]")
            elseif meta:get_string("page") == "mod" then
                local bp = ""
		    	for i in ipairs(bodyparts) do
		    	    local bone = bodyparts[i]
		
		            local bx = (i%2)*5
		
		            local by = 1.4 + (math.floor((i-1)/2) * 2)
		            -- We have to make 6 text areas.
					bp = bp .. "label["..bx..",".. by - -0.1 ..";"..bone[2].."]" ..
					-- Now!
					"textarea[".. bx + 0.2 ..",".. by + 0.7 ..";1,0.7;"..bone[1].."_xpos;X Pos;".. esc(meta:get_string(bone[1].."_xpos")) .."]"..
					"textarea[".. bx + 1.2 ..",".. by + 0.7 ..";1,0.7;"..bone[1].."_ypos;Y Pos;".. esc(meta:get_string(bone[1].."_ypos")) .."]"..
		    	    "textarea[".. bx + 2.2 ..",".. by + 0.7 ..";1,0.7;"..bone[1].."_zpos;Z Pos;".. esc(meta:get_string(bone[1].."_zpos")) .."]"..
		
		    	    "textarea[".. bx + 0.2 ..",".. by + 1.7 ..";1,0.7;"..bone[1].."_xrot;X Rot;".. esc(meta:get_string(bone[1].."_xrot")) .."]"..
		    	    "textarea[".. bx + 1.2 ..",".. by + 1.7 ..";1,0.7;"..bone[1].."_yrot;Y Rot;".. esc(meta:get_string(bone[1].."_yrot")) .."]"..
		    	    "textarea[".. bx + 2.2 ..",".. by + 1.7 ..";1,0.7;"..bone[1].."_zrot;Z Rot;".. esc(meta:get_string(bone[1].."_zrot")) .."]"	
		    	end
		
                meta:set_string("formspec", "size[12,8]" ..
                    "no_prepend[]"..
                    -- Properties
                    "button[4.5,0;3,1;body_full;Full Body]"..
                    -- Bones
                    "button[0,1;1.5,1;bodycc_Head;Head]"..
                    "button[10.5,1;1.5,1;bodycc_Body;Body]"..
                    "button[0,2;1.5,1;bodycc_Arm_Left;Left Arm]"..
                    "button[10.5,2;1.5,1;bodycc_Arm_Right;Right Arm]"..
                    "button[0,3;1.5,1;bodycc_Leg_Left;Left Leg]"..
                    "button[10.5,3;1.5,1;bodycc_Leg_Right;Right Leg]"..
                    -- Other
                    "button[0,4;1.5,1;page_particles;Particles]"..
                    "button[10.5,4;1.5,1;page_special;Special]"..
                    -- Nice View
                    "bgcolor[#80808040]"..
	                -- Save
	                "button[0,7.3;3,1;save;Save]"..
	                "button[9,7.3;3,1;page_inv;Inventory]")
	        elseif meta:get_string("page") == "body" then
	            local fp = "size[12,8]" .. "no_prepend[]"
	            if meta:get_string("viewbody") == "full" then
			    	fp = fp .. "label[0,-0.1;Full Body]"..
			
		                "image[10.7,1.2;1,1;ihm_rot.png]"..
		            	"textarea[10.4,2.7;2,1;yawi;Yaw;".. esc(meta:get_string("yaw")) .."]"..
		                "field_enter_after_edit[yawi;true]"..
		                "field_close_on_enter[yawi;false]"..
		                "image[5.5,0.2;1,1;ihm_full.png]"
	            end
	            -- It's a bone?
	            for i in ipairs(bodyparts) do
	                local bd = bodyparts[i]
	                if meta:get_string("viewbody") == bd[1] then
					    fp = fp .. "label[0,-0.1;".. bd[2] .."]"..
					    	"image[0,1.2;1,1;ihm_move.png]"..
		                	"textarea[0.2,2.7;1,1;xpos;X;".. esc(meta:get_string(bd[1].."_x-pos")) .."]"..
		                	"textarea[0.2,4.0;1,1;ypos;Y;".. esc(meta:get_string(bd[1].."_y-pos")) .."]"..
		                	"textarea[0.2,5.3;1,1;zpos;Z;".. esc(meta:get_string(bd[1].."_z-pos")) .."]"..
		                    "field_enter_after_edit[xpos;true]"..
		                    "field_close_on_enter[xpos;false]"..
		                    "field_enter_after_edit[ypos;true]"..
		                    "field_close_on_enter[ypos;false]"..
		                    "field_enter_after_edit[zpos;true]"..
                            "field_close_on_enter[zpos;false]"..
		
		                    "image[1,1.2;1,1;(ihm_scale.png^[colorize:#80808080)]"..
		                    "textarea[1.2,2.7;1,1;xscale;X;".. esc(meta:get_string(bd[1].."_x-scale")) .."]"..
		                	"textarea[1.2,4.0;1,1;yscale;Y;".. esc(meta:get_string(bd[1].."_y-scale")) .."]"..
		                	"textarea[1.2,5.3;1,1;zscale;Z;".. esc(meta:get_string(bd[1].."_z-scale")) .."]"..
		                    "field_enter_after_edit[xscale;true]"..
		                    "field_close_on_enter[xscale;false]"..
		                    "field_enter_after_edit[yscale;true]"..
		                    "field_close_on_enter[yscale;false]"..
		                    "field_enter_after_edit[zscale;true]"..
                            "field_close_on_enter[zscale;false]"..
		
		                    "image[11,1.2;1,1;(ihm_rot.png^[colorize:#80808080)]"..
		                	"textarea[11.4,2.7;1,1;xrot;X;".. esc(meta:get_string(bd[1].."_x-rot")) .."]"..
		                    "textarea[11.4,4.0;1,1;yrot;Y;".. esc(meta:get_string(bd[1].."_y-rot")) .."]"..
		                    "textarea[11.4,5.3;1,1;zrot;Z;".. esc(meta:get_string(bd[1].."_z-rot")) .."]"..
		                    "field_enter_after_edit[xrot;true]"..
		                    "field_close_on_enter[xrot;false]"..
		                    "field_enter_after_edit[yrot;true]"..
		                    "field_close_on_enter[yrot;false]"..
		                    "field_enter_after_edit[zrot;true]"..
                            "field_close_on_enter[zrot;false]"..
                            
		                    "image[5.5,0.2;1,1;ihm_"..bd[3]..".png]"
		
		                break
					end
	            end
	            -- Particles!
	            if meta:get_string("viewbody") == "particles" then
			    	fp = fp .. "label[0,-0.1;Particles]"..
				    	"field[0.2,1.2;3,1;particle_tex;Texture;".. esc(meta:get_string("particle_tex")) .."]"..
				        "field_enter_after_edit[particle_tex;true]"..
		                "field_close_on_enter[particle_tex;false]"..
				
			            "textarea[0.2,3.7;1,1;p_x;X;".. esc(meta:get_string("p_x")) .."]"..
		            	"textarea[0.2,5.0;1,1;p_y;Y;".. esc(meta:get_string("p_y")) .."]"..
		            	"textarea[0.2,6.3;1,1;p_z;Z;".. esc(meta:get_string("p_z")) .."]"..
		
		                "field_enter_after_edit[p_x;true]"..
		                "field_close_on_enter[p_x;false]"..
		                "field_enter_after_edit[p_y;true]"..
		                "field_close_on_enter[p_y;false]"..
		                "field_enter_after_edit[p_z;true]"..
                        "field_close_on_enter[p_z;false]"
				end
				-- Special
				if meta:get_string("viewbody") == "special" then
			    	fp = fp .. "label[0,-0.1;Special]"..
					    "field[0.2,2.7;3,1;character;Skin;".. meta:get_string("character") .."]"..
				    	"field_enter_after_edit[character;true]"..
		                "field_close_on_enter[character;false]"
				end
	            -- Always
				meta:set_string("formspec", fp..
				    -- Nice View
				    "bgcolor[#80808040]"..
				    -- Save
	                "button[0,7.3;3,1;save;Save]"..
	                "button[9,7.3;3,1;page_mod;Editor]")
	       end
	    end
	end
})

-- Separate the formspec into it's own function


