local bodyparts = {
	{"Head"},
	{"Body"},
	{"Arm_Right"},
	{"Arm_Left"},
	{"Leg_Right"},
	{"Leg_Left"}
}

item_holders.default_emote = {
    ["Head"] = {{x=0, y=0, z=0}, {x=1, y=1, z=1}, {x=0, y=0, z=0}},
    ["Body"] = {{x=0, y=0, z=0}, {x=1, y=1, z=1}, {x=0, y=0, z=0}},
    
    ["Arm_Right"] = {{x=0, y=0, z=0}, {x=1, y=1, z=1}, {x=0, y=0, z=0}},
    ["Arm_Left"] = {{x=0, y=0, z=0}, {x=1, y=1, z=1}, {x=0, y=0, z=0}},
    
    ["Leg_Right"] = {{x=0, y=0, z=0}, {x=1, y=1, z=1}, {x=0, y=0, z=0}},
    ["Leg_Left"] = {{x=0, y=0, z=0}, {x=1, y=1, z=1}, {x=0, y=0, z=0}},
}

function item_holders.process_emote(emote, md)
	for i in ipairs(bodyparts) do
	    local bd = bodyparts[i][1]
	
	    if emote[bd] then
	        if emote[bd][1] then
	            md:set_string(bd .. "_x-pos", emote[bd][1].x)
	            md:set_string(bd .. "_y-pos", emote[bd][1].y)
	            md:set_string(bd .. "_z-pos", emote[bd][1].z)
	        end
	        if emote[bd][2] then
	            md:set_string(bd .. "_x-scale", emote[bd][2].x)
	            md:set_string(bd .. "_y-scale", emote[bd][2].y)
	            md:set_string(bd .. "_z-scale", emote[bd][2].z)
	        else
	            md:set_string(bd .. "_x-scale", 1)
	            md:set_string(bd .. "_y-scale", 1)
	            md:set_string(bd .. "_z-scale", 1)
	        end
	        if emote[bd][3] then
	            md:set_string(bd .. "_x-rot", emote[bd][3].x)
	            md:set_string(bd .. "_y-rot", emote[bd][3].y)
	            md:set_string(bd .. "_z-rot", emote[bd][3].z)
	        end
	    end
	end
end

function item_holders.use_emote(ent, md)
    for i in ipairs(bodyparts) do
        local bd = bodyparts[i]
        local bdm = {}
        
        bdm.pos = {
            x = (tonumber(md:get_string(bd[1] .. "_x-pos"))) or 0,
            y = (tonumber(md:get_string(bd[1] .. "_y-pos"))) or 0,
            z = (tonumber(md:get_string(bd[1] .. "_z-pos"))) or 0
        }
        
        bdm.scale = {
            x = (tonumber(md:get_string(bd[1] .. "_x-scale"))) or 0,
            y = (tonumber(md:get_string(bd[1] .. "_y-scale"))) or 0,
            z = (tonumber(md:get_string(bd[1] .. "_z-scale"))) or 0
        }
        
        bdm.rot = {
            x = (((tonumber(md:get_string(bd[1] .. "_x-rot"))) or 0)/2) * math.pi,
            y = (((tonumber(md:get_string(bd[1] .. "_y-rot"))) or 0)/2) * math.pi,
            z = (((tonumber(md:get_string(bd[1] .. "_z-rot"))) or 0)/2) * math.pi
        }
        
        ent:set_bone_override(bd[1], {
            position = { vec = bdm.pos },
            rotation = { vec = bdm.rot },
            scale = { vec = bdm.scale }
         })
    end
end

--=====
-- Stand
--=====
standfunc = function() return end

item_holders.register_emote("== STANDING ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Stand", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Stand & Hold Right", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(-3, 5.75, 0), {x=0, y=0, z=-25})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
item_holders.register_emote("Stand & Hold Left", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=25})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
--===
-- Sit
--===
item_holders.register_emote("== SITTING ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Sit", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 4.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 0 + yu + (yi*1.25), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 3.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 3.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, -1, 0), {x=90, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, -1, 0), {x=90, y=0, z=0})
end)
item_holders.register_emote("Sit & Hold Right", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 4.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 0 + yu + (yi*1.25), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(3, 3.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(-3, 3.75, 0), {x=0, y=0, z=-25})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, -1, 0), {x=90, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, -1, 0), {x=90, y=0, z=0})
end)
item_holders.register_emote("Sit & Hold Left", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 4.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 0 + yu + (yi*1.25), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 3.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 3.75, 0), {x=0, y=0, z=25})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, -1, 0), {x=90, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, -1, 0), {x=90, y=0, z=0})
end)
--=====
-- Point
--=====
item_holders.register_emote("== POINTING ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Point", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=90, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
--=====
-- Fight
--=====
item_holders.register_emote("== FIGHTING ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Front Slash", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=45, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
item_holders.register_emote("Victory Pose", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=135, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)

--=====
-- Lay
--=====
item_holders.register_emote("== LAYING ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Lay Front", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, -1.25 + yu + (yi*2), 0 + zu), {x=90, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
item_holders.register_emote("Lay Back", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, -1.25 + yu + (yi*2), 0 + zu), {x=-90, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
--=====
-- Handsup
--=====
item_holders.register_emote("== HANDS UP ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Right Hand Up", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=0, z=180})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)

item_holders.register_emote("Hands Up!", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=0, z=180})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=180})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)

item_holders.register_emote("Left Hand Up", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=180})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)

--=====
-- Kicks
--=====
item_holders.register_emote("== KICKING ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Low Kick", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=45, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)

item_holders.register_emote("Middle Kick", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=90, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
--====
-- Walk
--====
item_holders.register_emote("== MOVING ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Walk", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=45, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=-45, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=45, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=-45, y=0, z=0})
end)
item_holders.register_emote("Run", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=75, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=-75, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=75, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=-75, y=0, z=0})
end)
--====
-- Grip
--====
item_holders.register_emote("== GRIPS ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("Backhand Grip", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi*2), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=0, y=180, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=0, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
--=====
-- Trick
--=====
item_holders.register_emote("== MISC ==", function(ent, h, pm) standfunc(ent, h, pm) end)
item_holders.register_emote("T-pose", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 4.75 + yu + (yi * 1.25), 0 + zu), {x=0, y=0, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 6, 0), {x = -180, y = 180, z = 90})
    ent:set_bone_position("Arm_Left", vector.new(3, 6, 0), {x = 180, y = 180, z = -90})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)
item_holders.register_emote("Trick 1", function(ent, h, pm)
    local yi = h or 0
    
    if not pm then pm = {} end
    local xu = pm.x or 0
    local yu = pm.y or 0
    local zu = pm.z or 0
    
    ent:set_bone_position("Head", vector.new(0, 6.5, 0), {x=0, y=0, z=0})

    ent:set_bone_position("Body", vector.new(0 + xu, 10.5 + yu + (yi*2), 0 + zu), {x=180, y=180, z=0})
    
    ent:set_bone_position("Arm_Right", vector.new(-3, 5.75, 0), {x=180, y=0, z=0})
    ent:set_bone_position("Arm_Left", vector.new(3, 5.75, 0), {x=180, y=0, z=0})
    
    ent:set_bone_position("Leg_Right", vector.new(-1, 0, 0), {x=0, y=0, z=0})
    ent:set_bone_position("Leg_Left", vector.new(1, 0, 0), {x=0, y=0, z=0})
end)