local wlist = {
	{"Apple", "wood", "wood"},
	{"Aspen", "aspen", "aspen_wood"},
	{"Pine", "pine", "pine_wood"},
	{"Jungle Wood", "junglewood", "junglewood"},
	{"Acacia", "acacia", "acacia_wood"},
}

for i in ipairs(wlist) do
local wname = wlist[i][1]
local wid = wlist[i][2]
local wii = wlist[i][3]

item_holders.register_holder("item_holders:"..wid.."_display_shelf", {
	description = wname.." Display Shelf",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			--{ Left, Up, Front, Right, Down, Back}
			-- Top
            { -0.5, 0.45, 0.35, 0.5, 0.5, 0.5},
            -- Sides
            { -0.5, -0.5, 0.35, -0.45,  0.5,  0.5}, -- Left
            {  0.45, -0.5, 0.35,  0.5,  0.5,  0.5}, -- Right
            { -0.5, -0.5,  0.45,  0.5,  0.5,  0.5}, -- Back
            { -0.5, -0.5,  0.40,  0.5,  0.5,  0.35}, -- Front
            -- Bottom
            { -0.5, -0.5, 0.35, 0.5, -0.45, 0.5},
        }
	},
	tiles = {"default_".. wii ..".png", "default_".. wii ..".png", "default_".. wii ..".png", "default_".. wii ..".png", "default_".. wii ..".png", "default_glass.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	is_itemcase = true,
	itemcase = "items",
	groups = {choppy = 3, itemcases = 1},
	moveitem = {
		[0] = {x=0,y=0,z= 0.45},
		[1] = {x= 0.45,y=0,z=0},
		[2] = {x=0,y=0,z= -0.45},
		[3] = {x= -0.45,y=0,z=0},
	},
	itemplacehold = "default_".. wii ..".png",
	background = "default_".. wii ..".png^",
	is_itemcase = true,
	itemcase = "items",
	ic_mods = {
	    "blank.png",
	    "[transformFYR180",
	},
	groups = {choppy = 3, oddly_breakable_by_hand = 1, itemcases = 1},
})



item_holders.register_holder("item_holders:"..wid.."_four_shelf", {
	description = wname.." Four Shelf",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			--{ Left, Up, Front, Right, Down, Back}
			-- Top
            { -0.5, 0.45, 0.35, 0.5, 0.5, 0.5},
            -- Sides
            { -0.5, -0.5, 0.35, -0.45,  0.5,  0.5}, -- Left
            {  0.45, -0.5, 0.35,  0.5,  0.5,  0.5}, -- Right
            { -0.5, -0.5,  0.45,  0.5,  0.5,  0.5}, -- Back
            { -0.5, -0.5,  0.40,  0.5,  0.5,  0.35}, -- Front
            -- Bottom
            { -0.5, -0.5, 0.35, 0.5, -0.45, 0.5},
        }
	},
	tiles = {"default_".. wii ..".png", "default_".. wii ..".png", "default_".. wii ..".png", "default_".. wii ..".png", "default_".. wii ..".png", "default_glass.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	itemplacehold = "default_"..wii..".png",
	background = "(default_"..wii..".png^[resize:256x256)^",
	is_itemcase = true,
	moveitem = {
		[0] = {x= 0,y=0,z= 0.45},
		[1] = {x= 0.45,y=0,z= 0},
		[2] = {x= 0,y=0,z=-0.45},
		[3] = {x=-0.45,y=0,z= 0},
	},
	itemcase = "items",
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos, img, aimg, iimg)
	    local bl = "default_"..wii..".png"
	    ent:set_properties({visual_size = {x=10,y=10,z=0.01}, visual = "mesh", mesh = "item_holders_four_shelf.obj", textures = {iimg[1] or bl, iimg[2] or bl, iimg[3] or bl, iimg[4] or bl}})
	end,
})


end