local on_construct = function(pos)
	local meta = minetest.get_meta(pos)
	meta:set_string("stored_formspec", item_holders.itemframe_formspec(pos))
	meta:set_string("owner", "")
	local inv = meta:get_inventory()
	inv:set_size("itemcase", 8)
end

local can_dig = function(pos, player)
	local meta = minetest.get_meta(pos)
	local inv = meta:get_inventory()
	local name = player:get_player_name()
	local owner = meta:get_string("owner")
	if owner == name then
		return inv:is_empty("itemcase")
	end
	return false
end

local after_place_node = function(pos, placer)
	local meta = minetest.get_meta(pos)
	meta:set_string("owner", placer:get_player_name() or "")
	meta:set_string("infotext", "Item Holder (owned by "..meta:get_string("owner")..")")
    local timer = minetest.get_node_timer(pos)
	timer:start(1)
end

local on_timer = function(pos)
    local timer = minetest.get_node_timer(pos)
    update_itemcase(pos)
    timer:start(1)
end

local amip = function(pos, listname, index, stack, player)
	local meta = minetest.get_meta(pos)
	local name = player:get_player_name()
	local owner = meta:get_string("owner")
	if owner == name then
		return stack:get_count()
	end
	return 0
end

local amit = function(pos, listname, index, stack, player)
	local meta = minetest.get_meta(pos)
	local name = player:get_player_name()
	local owner = meta:get_string("owner")
	if owner == name then
		return stack:get_count()
	end
	return 0
end

local amim = function(pos, from_list, from_index, to_list, to_index, count, player)
	local meta = minetest.get_meta(pos)
	local name = player:get_player_name()
	local owner = meta:get_string("owner")
	if owner == name then
		return count
	end
	return 0
end

local onmip = function(pos)
	update_itemcase(pos)
end

local onmit = function(pos)
	update_itemcase(pos)
end

local after_destruct = function(pos)
	update_itemcase(pos)
end

local right_click = function(pos, node, player)
    local meta = minetest.get_meta(pos)
    if player and player:get_player_name() then
        if meta:get_string("owner") == player:get_player_name() then
            minetest.show_formspec(player:get_player_name(),
                pos.x .. "," .. pos.y .. "," .. pos.z .. "-,-Item Holder",
                meta:get_string("stored_formspec"))
        end
    end
end

-- This function is actually to inject some definitions.
function item_holders.register_holder(id, def)
	def.on_construct = def.on_construct or on_construct
	def.can_dig = def.can_dig or can_dig
	def.after_place_node = def.after_place_node or after_place_node
	def.on_timer = def.on_timer or on_timer
	def.allow_metadata_inventory_put = def.allow_metadata_inventory_put or amip
	def.allow_metadata_inventory_take = def.allow_metadata_invemtory_take or amit
	def.allow_metadata_inventory_move = def.allow_metadata_inventory_move or amim
	def.on_metadata_inventory_put = def.on_metadata_inventory_put or onmip
	def.on_metadata_inventory_take = def.on_metadata_inventory_take or onmit
	def.after_destruct = def.after_destruct or after_destruct
	def.on_rightclick = def.on_rightclick or right_click
	def.use_texture_alpha = "clip"
	
	minetest.register_node(id, def)
end

-- General receiver
minetest.register_on_player_receive_fields(function(player, formname, fields)
    local fsplit = formname:split("-,-") or nil
    if not fields.quit and fsplit and fsplit[2] and fsplit[2] == "Item Holder" then
        local posd = fsplit[1]:split(",")
        
        local npos = {
        	x = posd[1],
            y = posd[2],
            z = posd[3]
        }
        
        local node = minetest.get_node(npos)
        local nodef = minetest.registered_nodes[node.name]
        if nodef and nodef.on_receive_fields then
            nodef.on_receive_fields(npos, formname, fields, player)
        end
    end
end)
