item_holders.register_holder("item_holders:itemframe", {
	description = "Itemframe",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, 7/16, 0.5, 0.5, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, 7/16, 0.5, 0.5, 0.5}
	},
	tiles = {"blank.png"},
	inventory_image = "item_holders_itemframe.png",
	wield_image = "item_holders_itemframe.png",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	itemcase = "items",
	ic_mods = {
	    "blank.png",
	    "[transformFYR180",
	    "[transformFYR270",
	    "[transformFYR360",
        "[transformR270",
        "[transformR180",
        "[transformR90",
        "blank.png"
	},
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
})

item_holders.register_holder("item_holders:floor_itemframe", {
	description = "Floor Itemframe",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -7/16, -0.5, 0.5, -0.5, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -7/16, -0.5, 0.5, -0.5, 0.5}
	},
	tiles = {"blank.png"},
	inventory_image = "default_cobble.png^item_holders_itemframe.png",
	wield_image = "default_cobble.png^item_holders_itemframe.png",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	itemcase2 = 2,
	itemcase = "items",
	moveitem = {
		[0] = {x=0,y=-0.49,z=0},
		[1] = {x=0,y=-0.49,z=0},
		[2] = {x=0,y=-0.49,z=0},
		[3] = {x=0,y=-0.49,z=0},
	},
	ic_mods = {
	    "blank.png",
	    "[transformFYR180",
	    "[transformFYR270",
	    "[transformFYR360",
        "[transformR270",
        "[transformR180",
        "[transformR90",
        "blank.png"
	},
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos)
	    ent:set_properties({visual_size = {x=1, y=0.01, z=1}})
	end,
})

--====
-- Incrusted
--====

item_holders.register_holder("item_holders:incrusted_itemframe", {
	description = "Incrusted Itemframe",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, 7/16, 0.5, 0.5, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, 7/16, 0.5, 0.5, 0.5}
	},
	tiles = {"blank.png"},
	inventory_image = "item_holders_itemframe.png^default_tool_woodpick.png",
	wield_image = "item_holders_itemframe.png^default_tool_woodpick.png",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	itemcase = "items",
	ic_mods = {
	    "blank.png",
	    "[transformFYR180",
	    "[transformFYR270",
	    "[transformFYR360",
        "[transformR90",
        "[transformR180",
        "[transformR270",
        "blank.png"
	},
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos)
	    local node = minetest.get_node(pos)
	    local rot = node.param2 % 4
		local yaw = 0
	
        if rot == 1 then
			yaw = 3 * math.pi
		elseif rot == 2 then
			yaw = 3 * math.pi / 2
		elseif rot == 3 then
			yaw = 2 * math.pi
		elseif rot == 0 then
			yaw = 1 * math.pi / 2
		end
		
		ent:set_yaw(yaw)
	end,
})

item_holders.register_holder("item_holders:straight_incrusted_itemframe", {
	description = "Straight Incrusted Itemframe",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, 7/16, 0.5, 0.5, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, 7/16, 0.5, 0.5, 0.5}
	},
	tiles = {"blank.png"},
	inventory_image = "item_holders_itemframe.png^default_tool_woodsword.png",
	wield_image = "item_holders_itemframe.png^default_tool_woodsword.png",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	itemcase2 = 2,
	itemcase = "items",
	ic_mods = {
	    "blank.png",
	    "[transformFYR180",
	    "[transformFYR270",
	    "[transformFYR360",
        "[transformR90",
        "[transformR180",
        "[transformR270",
        "blank.png"
	},
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos)
	    ent:set_properties({visual_size = {x=1, y=0.01, z=1}})
	    local node = minetest.get_node(pos)
	    local rot = node.param2 % 4
		local yaw = 0
	
        if rot == 1 then
			yaw = (3 * math.pi / 2)
		elseif rot == 2 then
			yaw = (3 * math.pi / 2) * 2
		elseif rot == 3 then
			yaw = (3 * math.pi / 2) * 3
		elseif rot == 0 then
			yaw = (3 * math.pi / 2) * 4
		end
		
		ent:set_rotation({x=(3 * math.pi / 2) * 2.5, y=yaw, z=(3 * math.pi / 2) * 3})
	end,
})

item_holders.register_holder("item_holders:floor_incrusted_itemframe", {
	description = "Floor Incrusted Itemframe",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -7/16, -0.5, 0.5, -0.5, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -7/16, -0.5, 0.5, -0.5, 0.5}
	},
	tiles = {"blank.png"},
	inventory_image = "default_dirt.png^item_holders_itemframe.png^default_tool_woodpick.png",
	wield_image = "default_dirt.png^item_holders_itemframe.png^default_tool_woodpick.png",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	itemcase2 = 2,
	itemcase = "items",
	moveitem = {
		[0] = {x=0,y=-0.49,z=0},
		[1] = {x=0,y=-0.49,z=0},
		[2] = {x=0,y=-0.49,z=0},
		[3] = {x=0,y=-0.49,z=0},
	},
	ic_mods = {
	    "blank.png",
	    "[transformFYR180",
	    "[transformFYR270",
	    "[transformFYR360",
        "[transformR90",
        "[transformR180",
        "[transformR270",
        "blank.png"
	},
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos)
	    ent:set_properties({visual_size = {x=1, y=0.01, z=1}})
	    local node = minetest.get_node(pos)
	    local rot = node.param2 % 4
		local yaw = 0
	
        if rot == 1 then
			yaw = 3 * math.pi
		elseif rot == 2 then
			yaw = 3 * math.pi / 2
		elseif rot == 3 then
			yaw = 2 * math.pi
		elseif rot == 0 then
			yaw = 1 * math.pi / 2
		end
		
		ent:set_rotation({x=(3 * math.pi / 2), y=yaw, z=0})
	end
})

item_holders.register_holder("item_holders:straight_floor_incrusted_itemframe", {
	description = "Straight Floor Incrusted Itemframe",
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {-0.5, -7/16, -0.5, 0.5, -0.5, 0.5}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -7/16, -0.5, 0.5, -0.5, 0.5}
	},
	tiles = {"blank.png"},
	inventory_image = "default_dirt.png^item_holders_itemframe.png^default_tool_woodsword.png",
	wield_image = "default_dirt.png^item_holders_itemframe.png^default_tool_woodsword.png",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	is_itemcase = true,
	itemcase2 = 2,
	itemcase = "items",
	moveitem = {
		[0] = {x=0,y=-0.49,z=0},
		[1] = {x=0,y=-0.49,z=0},
		[2] = {x=0,y=-0.49,z=0},
		[3] = {x=0,y=-0.49,z=0},
	},
	ic_mods = {
	    "[transformFYR270",
	},
	groups = {choppy = 3, itemframe = 1, oddly_breakable_by_hand = 1, itemcases = 1},
	pos_entity_mod = function(ent, pos)
	    ent:set_properties({visual_size = {x=1, y=0.01, z=1}})
	    local node = minetest.get_node(pos)
	    local rot = node.param2 % 4
		local yaw = 0
	
        if rot == 1 then
			yaw = 3 * math.pi
		elseif rot == 2 then
			yaw = 3 * math.pi / 2
		elseif rot == 3 then
			yaw = 2 * math.pi
		elseif rot == 0 then
			yaw = 1 * math.pi / 2
		end
		
		ent:set_rotation({x=(3 * math.pi / 2) * 0.5, y=yaw * 1.5, z=(3 * math.pi / 2)})
	end,
})
