-- Blank.
minetest.register_craftitem("lootboxes:blank", {
	inventory_image = "blank.png",
	groups = {not_in_creative_inventory = 1},
})

-- Get chances.
local function get_chances(group)
    if not lootboxes.loots[group] then return end
    if not lootboxes.loots[group].items then return end
    local num = 0
    -- Get the max chance
	for i in ipairs(lootboxes.loots[group].items) do
		num = num + lootboxes.loots[group].items[i][2]
	end
	--
	local chances = {}
	for i in ipairs(lootboxes.loots[group].items) do
	    local iitem = lootboxes.loots[group].items[i][1].item
	    local icounts = lootboxes.loots[group].items[i][1].count or lootboxes.loots[group].items[i][1].rcount
        local ichance = math.floor((lootboxes.loots[group].items[i][2] * 10000) / num) / 100
        table.insert(chances, {item = iitem, counts = icounts, chance = ichance})
	end
	return chances
end

-- The Logic
local main_func = function(item, command, player, data)
    -- When a box is clicked
    for str in pairs(command) do
        local cstr = str:split("-str-")
        if cstr[1] == "box" then
            data.view = "boxes_items"
            data.view_box = cstr[2]
        end
    end
    -- When puzzles button is clicked
    if command.puzzles then
        data.view = "puzzles"
    end
	-- When boxes button is clicked
	if command.boxes then
	    data.view = "boxes"
	end
end

-- The Form
local main_form = function(item, player, data)
	local form = "size[8,10]"
	
	if not data.view then data.view = "boxes" end
	
	-- Creates main
	
	form = form.."box[0,0;7.85,2.5;#808080]"
	form = form.."box[0,3;7.85,6.05;#808080]"
	
	if not lootboxes.loots[data.view_box] then
        data.view = "boxes"
    end
	
	if data.view == "puzzles" then
	    local fitem = ItemStack("lootboxes:random_lootbox")
	    local fmeta = fitem:get_meta()
	    fmeta:set_string("inventory_image", "iit_assets_unknown.png")
	    
	    local count = -4
	
	    form = form .. "item_image[0,0;3,3;".. fitem:to_string() .."]"
	
	    form = form .. "scroll_container[0,3.85;9.85,7.05;scroll_container;vertical;1.75]"
	    
	    local c = 0
	    for i in pairs(lootboxes.puzzles) do
	        c = c + 1
	        local ldata = lootboxes.puzzles[i]
	        local lname = ldata.name or "???"
	        local limage = ldata.image or "iit_assets_unknown.png"
	
	        local lstack = ItemStack("lootboxes:blank")
	        local lmeta = lstack:get_meta()
	        lmeta:set_string("inventory_image", limage)
	
	        form = form .. "item_image_button[0.15,".. (c * 1.515) - 1.75 ..";1.5,1.5;lootboxes:blank;puzzle-str-"..i..";]"
			form = form .. "item_image[0.215,".. (c * 1.515) - 1.75 ..";1.5,1.5;" .. lstack:to_string() .."]"
			form = form .. "label[1.5,".. (c * 1.515) - 1.75 ..";"..lname.."]"
			form = form .. "tooltip[puzzle-str-"..i..";"..lname..";#202020;#FFFFFF]"
			
			count = count + 1
	    end
	    
	    form = form .. "scroll_container_end[]"
    
         -- Add the scrollbar
        form = form .. "scrollbaroptions[max="..count.."]"
        form = form .. "scrollbar[7.125,3;0.75,6.125;vertical;scroll_container;0]"
	elseif data.view == "boxes" then
	    local fitem = ItemStack("lootboxes:random_lootbox")
	    local fmeta = fitem:get_meta()
	    local iunk = "(iit_assets_unknown.png^[colorize\\:#808080FF)"
        local dimage = lootboxes.generate_eimg("default_coal_block.png", iunk, iunk, iunk),
	    fmeta:set_string("inventory_image", dimage)
	    
	    local count = -4
	
	    form = form .. "item_image[0,0;3,3;".. fitem:to_string() .."]"
	
	    form = form .. "scroll_container[0,3.85;9.85,7.05;scroll_container;vertical;1.75]"
	    
	    local c = 0
	    for i in pairs(lootboxes.loots) do
	        c = c + 1
	        local ldata = lootboxes.loots[i]
	        local lname = ldata.name or "???"
	        local limage = ldata.image or "iit_assets_unknown.png"
	
	        local lstack = ItemStack("lootboxes:blank")
	        local lmeta = lstack:get_meta()
	        lmeta:set_string("inventory_image", limage)
	
	        form = form .. "item_image_button[0.15,".. (c * 1.515) - 1.75 ..";1.5,1.5;lootboxes:blank;box-str-"..i..";]"
			form = form .. "item_image[0.215,".. (c * 1.515) - 1.75 ..";1.5,1.5;" .. lstack:to_string() .."]"
			form = form .. "label[1.5,".. (c * 1.515) - 1.75 ..";"..lname.."]"
			form = form .. "tooltip[box-str-"..i..";"..lname..";#202020;#FFFFFF]"
			
			count = count + 1
	    end
	    
	    form = form .. "scroll_container_end[]"
    
         -- Add the scrollbar
        form = form .. "scrollbaroptions[max="..count.."]"
        form = form .. "scrollbar[7.125,3;0.75,6.125;vertical;scroll_container;0]"
	elseif data.view == "boxes_items" then
    	if not lootboxes.loots[data.view_box] then return end
        local ldata = lootboxes.loots[data.view_box]
    	local fitem = ItemStack("lootboxes:random_lootbox")
	    local fmeta = fitem:get_meta()
	    fmeta:set_string("inventory_image", ldata.image or "iit_assets_unknown.png")
	    
	    local count = -4
	
	    form = form .. "item_image[0,0;3,3;".. fitem:to_string() .."]"
    	form = form .. "label[1.75,0;"..  ldata.name .. "]"
	
	    form = form .. "scroll_container[0,3.85;9.85,7.05;scroll_container;vertical;1.75]"
	    
	    local ilist = get_chances(data.view_box)
	    for i in ipairs(ilist) do
	        local rc = ilist[i]
	
	        local stack = ItemStack(ilist[i].item)
	        local rg = minetest.registered_items[stack:get_name()]
	
			form = form .. "item_image_button[0.15,".. (i * 1.515) - 1.75 ..";1.5,1.5;lootboxes:blank;none_"..i..";]"
			form = form .. "item_image[0.215,".. (i * 1.515) - 1.75 ..";1.5,1.5;" .. stack:to_string() .."]"
			form = form .. "label[1.5,".. (i * 1.515) - 1.75 ..";".. rg.description .."]"
			if type(rc.counts) == "table" then
		    	form = form .. "label[1.5,".. (i * 1.515) - 1.25 ..";".. ilist[i].chance .."% ("..(rc.counts[1] or "???").." - "..(rc.counts[2] or "???").."x)]"
		    else
		        form = form .. "label[1.5,".. (i * 1.515) - 1.25 ..";".. ilist[i].chance .."% ("..(rc.counts or "???").."x)]"
		    end
			form = form .. "tooltip[none_"..i..";"..rg.description..";#202020;#FFFFFF]"
			
			count = count + 1
	    end
	    
	    form = form .. "scroll_container_end[]"
    
         -- Add the scrollbar
        form = form .. "scrollbaroptions[max="..count.."]"
        form = form .. "scrollbar[7.125,3;0.75,6.125;vertical;scroll_container;0]"
    end
    -- Nav Buttons.
    form = form .. "image_button[0,9.25;1,1;iit_assets_left.png;boxes;]"
    form = form .. "image_button[1,9.25;1,1;iit_assets_unknown.png;puzzles;]"

    return form
end

-- Register the chancebook action.

interactive_item.register_action("lootboxes:chance_book", {
	-- Form
	forms = {
        main = main_form,
	},
	-- Logic
	logics = {
		main = main_func,
	},
	options = {
		storeable = true,
	}
})

-- Now the item
interactive_item.register_item("lootboxes:chance_book", {
	description = "Lootboxes Book",
	inventory_image = "lootboxes_book.png",
	on_use = function(item, user)
	    local meta = item:get_meta()
	    local acc = meta:get_string("action")
	
	    if acc == "" then
	        meta:set_string("action", "lootboxes:chance_book")
	    end
	end
})

-- Recipe for it.
minetest.register_craft({
	output = "lootboxes:chance_book",
	recipe = {
		{"default:mese_crystal", "default:book", "default:chest"},
	}
})